/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.commands;

import java.util.Collections;
import java.util.List;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogCommand;
import org.apache.ignite.internal.catalog.CatalogValidationException;
import org.apache.ignite.internal.catalog.UpdateContext;
import org.apache.ignite.internal.catalog.commands.AbstractZoneCommand;
import org.apache.ignite.internal.catalog.commands.AbstractZoneCommandBuilder;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.catalog.storage.SetDefaultZoneEntry;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;

public class AlterZoneSetDefaultCommand
extends AbstractZoneCommand {
    private final boolean ifExists;

    public static Builder builder() {
        return new Builder();
    }

    private AlterZoneSetDefaultCommand(String zoneName, boolean ifExists) throws CatalogValidationException {
        super(zoneName);
        this.ifExists = ifExists;
    }

    @Override
    public List<UpdateEntry> get(UpdateContext updateContext) {
        Catalog catalog = updateContext.catalog();
        CatalogZoneDescriptor zone = CatalogUtils.zone(catalog, this.zoneName, !this.ifExists);
        if (zone == null) {
            return List.of();
        }
        CatalogZoneDescriptor defaultZone = catalog.defaultZone();
        if (defaultZone != null && zone.id() == defaultZone.id()) {
            return Collections.emptyList();
        }
        return List.of(new SetDefaultZoneEntry(zone.id()));
    }

    public boolean ifExists() {
        return this.ifExists;
    }

    public static class Builder
    implements AbstractZoneCommandBuilder<Builder> {
        private String zoneName;
        private boolean ifExists;

        @Override
        public Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        public Builder ifExists(boolean ifExists) {
            this.ifExists = ifExists;
            return this;
        }

        @Override
        public CatalogCommand build() {
            return new AlterZoneSetDefaultCommand(this.zoneName, this.ifExists);
        }
    }
}

