/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.schema;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelReferentialConstraint;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.util.ImmutableBitSet;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Statistics {
    public static final Statistic UNKNOWN = new Statistic(){};

    private Statistics() {
    }

    public static Statistic of(@Nullable List<RelReferentialConstraint> referentialConstraints) {
        return Statistics.of(null, null, referentialConstraints, null);
    }

    public static Statistic of(double rowCount, @Nullable List<ImmutableBitSet> keys) {
        return Statistics.of(rowCount, keys, null, null);
    }

    public static Statistic of(double rowCount, @Nullable List<ImmutableBitSet> keys, @Nullable List<RelCollation> collations) {
        return Statistics.of(rowCount, keys, null, collations);
    }

    public static Statistic of(final @Nullable Double rowCount, @Nullable List<ImmutableBitSet> keys, @Nullable List<RelReferentialConstraint> referentialConstraints, @Nullable List<RelCollation> collations) {
        ImmutableList keysCopy = keys == null ? ImmutableList.of() : ImmutableList.copyOf(keys);
        ImmutableList referentialConstraintsCopy = referentialConstraints == null ? null : ImmutableList.copyOf(referentialConstraints);
        ImmutableList collationsCopy = collations == null ? null : ImmutableList.copyOf(collations);
        return new Statistic((List)keysCopy, (List)referentialConstraintsCopy, (List)collationsCopy){
            final /* synthetic */ List val$keysCopy;
            final /* synthetic */ List val$referentialConstraintsCopy;
            final /* synthetic */ List val$collationsCopy;
            {
                this.val$keysCopy = list;
                this.val$referentialConstraintsCopy = list2;
                this.val$collationsCopy = list3;
            }

            @Override
            public @Nullable Double getRowCount() {
                return rowCount;
            }

            @Override
            public boolean isKey(ImmutableBitSet columns) {
                for (ImmutableBitSet key : this.val$keysCopy) {
                    if (!columns.contains(key)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public @Nullable List<ImmutableBitSet> getKeys() {
                return this.val$keysCopy;
            }

            @Override
            public @Nullable List<RelReferentialConstraint> getReferentialConstraints() {
                return this.val$referentialConstraintsCopy;
            }

            @Override
            public @Nullable List<RelCollation> getCollations() {
                return this.val$collationsCopy;
            }
        };
    }
}

