/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.raft.snapshot;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.lang.IgniteBiTuple;
import org.apache.ignite.internal.partition.replicator.raft.PartitionSnapshotInfo;
import org.apache.ignite.internal.partition.replicator.raft.PartitionSnapshotInfoSerializer;
import org.apache.ignite.internal.partition.replicator.raft.snapshot.PartitionTxStateAccess;
import org.apache.ignite.internal.raft.RaftGroupConfiguration;
import org.apache.ignite.internal.raft.RaftGroupConfigurationConverter;
import org.apache.ignite.internal.storage.engine.MvPartitionMeta;
import org.apache.ignite.internal.storage.lease.LeaseInfo;
import org.apache.ignite.internal.tx.TxMeta;
import org.apache.ignite.internal.tx.storage.state.TxStatePartitionStorage;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.internal.versioned.VersionedSerialization;
import org.apache.ignite.internal.versioned.VersionedSerializer;
import org.jetbrains.annotations.Nullable;

public class PartitionTxStateAccessImpl
implements PartitionTxStateAccess {
    private final TxStatePartitionStorage storage;
    private final RaftGroupConfigurationConverter raftGroupConfigurationConverter = new RaftGroupConfigurationConverter();

    public PartitionTxStateAccessImpl(TxStatePartitionStorage storage) {
        this.storage = storage;
    }

    @Override
    public Cursor<IgniteBiTuple<UUID, TxMeta>> getAllTxMeta() {
        return this.storage.scan();
    }

    @Override
    public void addTxMeta(UUID txId, TxMeta txMeta) {
        this.storage.putForRebalance(txId, txMeta);
    }

    @Override
    public long lastAppliedIndex() {
        return this.storage.lastAppliedIndex();
    }

    @Override
    public long lastAppliedTerm() {
        return this.storage.lastAppliedTerm();
    }

    @Override
    @Nullable
    public RaftGroupConfiguration committedGroupConfiguration() {
        return this.raftGroupConfigurationConverter.fromBytes(this.storage.committedGroupConfiguration());
    }

    @Override
    @Nullable
    public LeaseInfo leaseInfo() {
        return this.storage.leaseInfo();
    }

    @Override
    @Nullable
    public PartitionSnapshotInfo snapshotInfo() {
        byte[] snapshotInfo = this.storage.snapshotInfo();
        return snapshotInfo == null ? null : (PartitionSnapshotInfo)VersionedSerialization.fromBytes((byte[])snapshotInfo, (VersionedSerializer)PartitionSnapshotInfoSerializer.INSTANCE);
    }

    @Override
    public CompletableFuture<Void> startRebalance() {
        return this.storage.startRebalance();
    }

    @Override
    public CompletableFuture<Void> abortRebalance() {
        return this.storage.abortRebalance();
    }

    @Override
    public CompletableFuture<Void> finishRebalance(MvPartitionMeta partitionMeta) {
        return this.storage.finishRebalance(partitionMeta).thenCompose(v -> this.storage.flush());
    }
}

