/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.storage.state.rocksdb;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.ignite.internal.rocksdb.ColumnFamily;
import org.apache.ignite.internal.rocksdb.RocksUtils;
import org.apache.ignite.internal.storage.lease.LeaseInfo;
import org.apache.ignite.internal.storage.lease.LeaseInfoSerializer;
import org.apache.ignite.internal.tx.storage.state.rocksdb.TxStateRocksDbSharedStorage;
import org.apache.ignite.internal.versioned.VersionedSerialization;
import org.apache.ignite.internal.versioned.VersionedSerializer;
import org.jetbrains.annotations.Nullable;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteBatch;

class TxStateMetaRocksDbPartitionStorage {
    static final int TABLE_OR_ZONE_PREFIX_SIZE_BYTES = 5;
    private static final int KEY_SIZE_BYTES = 7;
    static final byte LAST_APPLIED_PREFIX = 0;
    private static final byte CONF_PREFIX = 1;
    private static final byte LEASE_INFO_PREFIX = 2;
    private static final byte SNAPSHOT_INFO_PREFIX = 3;
    private final ColumnFamily columnFamily;
    private final int tableOrZoneId;
    private final int partitionId;
    private final byte[] lastAppliedKey;
    private final byte[] confKey;
    private final byte[] leaseInfoKey;
    private final byte[] snapshotInfoKey;
    private volatile long lastAppliedIndex;
    private volatile long lastAppliedTerm;
    private volatile byte @Nullable [] config;
    @Nullable
    private volatile LeaseInfo leaseInfo;

    TxStateMetaRocksDbPartitionStorage(ColumnFamily columnFamily, int tableOrZoneId, int partitionId) {
        this.columnFamily = columnFamily;
        this.partitionId = partitionId;
        this.tableOrZoneId = tableOrZoneId;
        this.lastAppliedKey = this.createKey((byte)0);
        this.confKey = this.createKey((byte)1);
        this.leaseInfoKey = this.createKey((byte)2);
        this.snapshotInfoKey = this.createKey((byte)3);
    }

    private byte[] createKey(byte prefix) {
        return ByteBuffer.allocate(7).order(TxStateRocksDbSharedStorage.BYTE_ORDER).put(prefix).putInt(this.tableOrZoneId).putShort((short)this.partitionId).array();
    }

    private static byte[] createKeyPrefixForTableOrZone(byte prefix, int tableOrZoneId) {
        return ByteBuffer.allocate(5).order(TxStateRocksDbSharedStorage.BYTE_ORDER).put(prefix).putInt(tableOrZoneId).array();
    }

    void start() throws RocksDBException {
        byte[] lastAppliedBytes = this.columnFamily.get(this.lastAppliedKey);
        if (lastAppliedBytes != null) {
            ByteBuffer buf = ByteBuffer.wrap(lastAppliedBytes).order(TxStateRocksDbSharedStorage.BYTE_ORDER);
            this.lastAppliedIndex = buf.getLong();
            this.lastAppliedTerm = buf.getLong();
        }
        this.config = this.columnFamily.get(this.confKey);
        byte[] leaseBytes = this.columnFamily.get(this.leaseInfoKey);
        if (leaseBytes != null) {
            this.leaseInfo = (LeaseInfo)VersionedSerialization.fromBytes((byte[])leaseBytes, (VersionedSerializer)LeaseInfoSerializer.INSTANCE);
        }
    }

    void startInCompatibilityMode(long lastAppliedIndex, long lastAppliedTerm) throws RocksDBException {
        byte[] lastAppliedBytes = this.columnFamily.get(this.lastAppliedKey);
        if (lastAppliedBytes != null) {
            ByteBuffer buf = ByteBuffer.wrap(lastAppliedBytes).order(TxStateRocksDbSharedStorage.BYTE_ORDER);
            this.lastAppliedIndex = buf.getLong();
            this.lastAppliedTerm = buf.getLong();
        } else {
            this.lastAppliedIndex = lastAppliedIndex;
            this.lastAppliedTerm = lastAppliedTerm;
        }
        this.config = this.columnFamily.get(this.confKey);
        byte[] leaseBytes = this.columnFamily.get(this.leaseInfoKey);
        if (leaseBytes != null) {
            this.leaseInfo = (LeaseInfo)VersionedSerialization.fromBytes((byte[])leaseBytes, (VersionedSerializer)LeaseInfoSerializer.INSTANCE);
        }
    }

    long lastAppliedIndex() {
        return this.lastAppliedIndex;
    }

    long lastAppliedTerm() {
        return this.lastAppliedTerm;
    }

    byte @Nullable [] configuration() {
        return this.config;
    }

    @Nullable
    LeaseInfo leaseInfo() {
        return this.leaseInfo;
    }

    byte @Nullable [] snapshotInfo() throws RocksDBException {
        return this.columnFamily.get(this.snapshotInfoKey);
    }

    void updateLastApplied(WriteBatch writeBatch, long index, long term) throws RocksDBException {
        this.columnFamily.put(writeBatch, this.lastAppliedKey, TxStateMetaRocksDbPartitionStorage.indexAndTermToBytes(index, term));
        this.lastAppliedIndex = index;
        this.lastAppliedTerm = term;
    }

    void updateConfiguration(WriteBatch writeBatch, byte[] config) throws RocksDBException {
        this.columnFamily.put(writeBatch, this.confKey, config);
        this.config = config;
    }

    void updateLease(WriteBatch writeBatch, LeaseInfo leaseInfo) throws RocksDBException {
        this.columnFamily.put(writeBatch, this.leaseInfoKey, VersionedSerialization.toBytes((Object)leaseInfo, (VersionedSerializer)LeaseInfoSerializer.INSTANCE));
        this.leaseInfo = leaseInfo;
    }

    void updateSnapshotInfo(WriteBatch writeBatch, byte[] snapshotInfo) throws RocksDBException {
        this.columnFamily.put(writeBatch, this.snapshotInfoKey, snapshotInfo);
    }

    private static byte[] indexAndTermToBytes(long lastAppliedIndex, long lastAppliedTerm) {
        return ByteBuffer.allocate(16).order(TxStateRocksDbSharedStorage.BYTE_ORDER).putLong(lastAppliedIndex).putLong(lastAppliedTerm).array();
    }

    void clear(WriteBatch writeBatch) throws RocksDBException {
        this.columnFamily.delete(writeBatch, this.lastAppliedKey);
        this.columnFamily.delete(writeBatch, this.confKey);
        this.columnFamily.delete(writeBatch, this.leaseInfoKey);
        this.columnFamily.delete(writeBatch, this.snapshotInfoKey);
        this.lastAppliedIndex = 0L;
        this.lastAppliedTerm = 0L;
        this.config = null;
        this.leaseInfo = null;
    }

    static void clearForTableOrZone(WriteBatch writeBatch, ColumnFamilyHandle cf, int tableOrZoneId) throws RocksDBException {
        for (byte prefixByte : List.of(Byte.valueOf((byte)0), Byte.valueOf((byte)1), Byte.valueOf((byte)2), Byte.valueOf((byte)3))) {
            byte[] start = TxStateMetaRocksDbPartitionStorage.createKeyPrefixForTableOrZone(prefixByte, tableOrZoneId);
            byte[] end = RocksUtils.incrementPrefix((byte[])start);
            writeBatch.deleteRange(cf, start, end);
        }
    }
}

