/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.util;

import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.ignite.internal.sql.engine.QueryCancelledException;
import org.apache.ignite.internal.sql.engine.exec.AsyncDataCursor;
import org.apache.ignite.internal.util.AsyncWrapper;
import org.apache.ignite.internal.util.CompletableFutures;

public class IteratorToDataCursorAdapter<T>
extends AsyncWrapper<T>
implements AsyncDataCursor<T> {
    private final CompletableFuture<?> initialized;

    public IteratorToDataCursorAdapter(CompletableFuture<Iterator<T>> initFut, Executor exec) {
        super(initFut, exec);
        this.initialized = initFut;
    }

    public IteratorToDataCursorAdapter(Iterator<T> source) {
        this(CompletableFuture.completedFuture(source), Runnable::run);
    }

    public CompletableFuture<Void> onClose() {
        return CompletableFutures.nullCompletedFuture();
    }

    public CompletableFuture<Void> onFirstPageReady() {
        return this.initialized.thenRun(() -> {});
    }

    public CompletableFuture<Void> cancelAsync(AsyncDataCursor.CancellationReason reason) {
        if (reason == AsyncDataCursor.CancellationReason.TIMEOUT && !this.initialized.isDone()) {
            this.initialized.completeExceptionally((Throwable)((Object)new QueryCancelledException("Query timeout")));
        }
        return CompletableFutures.nullCompletedFuture();
    }
}

