/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.mapping.smallcluster;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.internal.partitiondistribution.Assignment;
import org.apache.ignite.internal.partitiondistribution.TokenizedAssignments;
import org.apache.ignite.internal.sql.engine.exec.NodeWithConsistencyToken;
import org.apache.ignite.internal.sql.engine.exec.mapping.ExecutionTarget;
import org.apache.ignite.internal.sql.engine.exec.mapping.ExecutionTargetFactory;
import org.apache.ignite.internal.sql.engine.exec.mapping.MappingException;
import org.apache.ignite.internal.sql.engine.exec.mapping.smallcluster.AbstractTarget;
import org.apache.ignite.internal.sql.engine.exec.mapping.smallcluster.AllOfTarget;
import org.apache.ignite.internal.sql.engine.exec.mapping.smallcluster.OneOfTarget;
import org.apache.ignite.internal.sql.engine.exec.mapping.smallcluster.PartitionedTarget;
import org.apache.ignite.internal.sql.engine.exec.mapping.smallcluster.SomeOfTarget;
import org.apache.ignite.internal.util.IgniteUtils;

public class SmallClusterFactory
implements ExecutionTargetFactory {
    private final List<String> nodes;
    private final Object2LongMap<String> nodeNameToId;

    public SmallClusterFactory(List<String> nodes) {
        if (nodes.size() > 64) {
            throw new IllegalArgumentException("Supported up to 64 nodes, but was " + nodes.size());
        }
        this.nodes = nodes.stream().sorted().collect(Collectors.toList());
        this.nodeNameToId = new Object2LongOpenHashMap(nodes.size());
        int idx = 0;
        for (String name : this.nodes) {
            this.nodeNameToId.putIfAbsent((Object)name, 1L << idx++);
        }
    }

    @Override
    public ExecutionTarget allOf(List<String> nodes) {
        long nodesMap = 0L;
        for (String name : nodes) {
            long node = this.nodeNameToId.getOrDefault((Object)name, -1L);
            if (node == -1L) {
                throw new MappingException("Mandatory node was excluded from mapping: " + name);
            }
            nodesMap |= node;
        }
        return new AllOfTarget(nodesMap);
    }

    @Override
    public ExecutionTarget oneOf(List<String> nodes) {
        return new OneOfTarget(this.nodeListToMap(nodes));
    }

    @Override
    public ExecutionTarget someOf(List<String> nodes) {
        return new SomeOfTarget(this.nodeListToMap(nodes));
    }

    @Override
    public ExecutionTarget partitioned(List<TokenizedAssignments> assignments) {
        long[] partitionNodes = new long[assignments.size()];
        long[] enlistmentConsistencyTokens = new long[assignments.size()];
        int idx = 0;
        boolean finalised = true;
        for (TokenizedAssignments assignment : assignments) {
            long currentPartitionNodes = 0L;
            for (Assignment a : assignment.nodes()) {
                long node = this.nodeNameToId.getOrDefault((Object)a.consistentId(), -1L);
                if (node == -1L) continue;
                currentPartitionNodes |= node;
            }
            if (currentPartitionNodes == 0L) {
                List nodes = assignment.nodes().stream().map(Assignment::consistentId).collect(Collectors.toList());
                throw new MappingException("Mandatory nodes was excluded from mapping: " + String.valueOf(nodes));
            }
            finalised = finalised && IgniteUtils.isPow2((long)currentPartitionNodes);
            partitionNodes[idx] = currentPartitionNodes;
            enlistmentConsistencyTokens[idx] = assignment.token();
            ++idx;
        }
        return new PartitionedTarget(finalised, partitionNodes, enlistmentConsistencyTokens);
    }

    @Override
    public List<String> resolveNodes(ExecutionTarget target) {
        assert (target instanceof AbstractTarget) : target == null ? "<null>" : target.getClass().getCanonicalName();
        target = ((AbstractTarget)target).finalise();
        return ((AbstractTarget)target).nodes(this.nodes);
    }

    @Override
    public Int2ObjectMap<NodeWithConsistencyToken> resolveAssignments(ExecutionTarget target) {
        assert (target instanceof AbstractTarget) : target == null ? "<null>" : target.getClass().getCanonicalName();
        target = ((AbstractTarget)target).finalise();
        return ((AbstractTarget)target).assignments(this.nodes);
    }

    private long nodeListToMap(List<String> nodes) {
        assert (!nodes.isEmpty()) : "Empty target is not allowed";
        long nodesMap = 0L;
        for (String name : nodes) {
            long node = this.nodeNameToId.getOrDefault((Object)name, -1L);
            if (node < 0L) continue;
            nodesMap |= node;
        }
        if (nodesMap == 0L) {
            throw new MappingException("Mandatory nodes was excluded from mapping: " + String.valueOf(nodes));
        }
        return nodesMap;
    }
}

