/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.jta.jndi;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import javax.cache.configuration.Factory;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.util.typedef.internal.U;

public class CacheJndiTmFactory
implements Factory<TransactionManager> {
    private static final long serialVersionUID = 0L;
    private String[] jndiNames;
    private Map<?, ?> environment;

    public CacheJndiTmFactory() {
    }

    public CacheJndiTmFactory(String ... jndiNames) {
        this.jndiNames = jndiNames;
    }

    public String[] getJndiNames() {
        return this.jndiNames;
    }

    public void setJndiNames(String ... jndiNames) {
        this.jndiNames = jndiNames;
    }

    public Map<?, ?> getInitialContextEnvironment() {
        return this.environment;
    }

    public void setInitialContextEnvironment(Map<?, ?> environment) {
        this.environment = environment;
    }

    public TransactionManager create() {
        InitialContext ctx;
        assert (this.jndiNames != null);
        assert (this.jndiNames.length != 0);
        try {
            ctx = new InitialContext(this.environment == null ? null : new Hashtable(this.environment));
        }
        catch (NamingException e) {
            throw new IgniteException("Failed to instantiate InitialContext: " + this.environment, (Throwable)e);
        }
        for (String s : this.jndiNames) {
            Object obj;
            try {
                obj = ctx.lookup(s);
            }
            catch (NamingException e) {
                U.warn(null, (Object)("Failed to lookup resourse: " + e));
                continue;
            }
            if (obj == null || !(obj instanceof TransactionManager)) continue;
            return (TransactionManager)obj;
        }
        throw new IgniteException("Failed to lookup TM by: " + Arrays.toString(this.jndiNames));
    }
}

