/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.util.LinkedList;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.ignite.internal.util.typedef.internal.U;

public final class ThreadLocalObjectPool<E extends AutoCloseable> {
    private final ThreadLocal<Queue<E>> bag = ThreadLocal.withInitial(LinkedList::new);
    private final int poolSize;
    private final Supplier<E> objFactory;
    private final Consumer<E> closer;
    private final Consumer<E> recycler;

    public ThreadLocalObjectPool(int poolSize, Supplier<E> objFactory, Consumer<E> closer, Consumer<E> recycler) {
        this.poolSize = poolSize;
        this.objFactory = objFactory;
        this.closer = closer;
        this.recycler = recycler;
    }

    public Reusable borrow() {
        AutoCloseable obj = (AutoCloseable)this.bag.get().poll();
        if (obj == null) {
            obj = (AutoCloseable)this.objFactory.get();
        }
        return new Reusable(this, obj);
    }

    int bagSize() {
        return this.bag.get().size();
    }

    public static class Reusable {
        private E object;
        final /* synthetic */ ThreadLocalObjectPool this$0;

        private Reusable(E object) {
            this.this$0 = this$0;
            this.object = object;
        }

        public E object() {
            return this.object;
        }

        public void recycle() {
            assert (this.object != null) : "The object is already recycled";
            if (this.this$0.bag.get().size() < this.this$0.poolSize) {
                if (this.this$0.recycler != null) {
                    this.this$0.recycler.accept(this.object);
                }
                this.this$0.bag.get().add(this.object);
            } else if (this.this$0.closer != null) {
                this.this$0.closer.accept(this.object);
            } else {
                U.closeQuiet(this.object);
            }
            this.object = null;
        }
    }
}

