/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.jdbc.vendors;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.yardstick.jdbc.AbstractJdbcBenchmark;
import org.apache.ignite.yardstick.jdbc.vendors.QueryFactory;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkUtils;

public abstract class BaseSelectRangeBenchmark
extends AbstractJdbcBenchmark {
    protected QueryFactory queries;
    private static final int ORG_TO_PERS_FACTOR = 10;
    private static final int BATCH_SIZE = 10000;
    private List<AutoCloseable> toClose = Collections.synchronizedList(new ArrayList());
    protected ThreadLocal<PreparedStatement> select = new ThreadLocal<PreparedStatement>(){

        @Override
        protected PreparedStatement initialValue() {
            try {
                Connection locConn = (Connection)BaseSelectRangeBenchmark.this.conn.get();
                PreparedStatement sel = locConn.prepareStatement(BaseSelectRangeBenchmark.this.testedSqlQuery());
                BaseSelectRangeBenchmark.this.toClose.add(sel);
                return sel;
            }
            catch (SQLException e) {
                throw new RuntimeException("Can't create thread local statement.", e);
            }
        }
    };

    protected abstract String testedSqlQuery();

    protected abstract void fillTestedQueryParams(PreparedStatement var1) throws SQLException;

    @Override
    protected void setupData() throws Exception {
        Collection srvNodes = this.ignite().cluster().forServers().nodes();
        if (srvNodes.size() > 1) {
            throw new IllegalStateException("This benchmark is designed to no more than one server (data) node. Currently cluster contains " + srvNodes.size() + " server nodes : " + srvNodes);
        }
    }

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        long percent;
        super.setUp(cfg);
        this.queries = new QueryFactory();
        Connection conn0 = (Connection)this.conn.get();
        BaseSelectRangeBenchmark.executeUpdate(conn0, this.queries.dropPersonIfExist());
        BaseSelectRangeBenchmark.executeUpdate(conn0, this.queries.dropOrgIfExist());
        BaseSelectRangeBenchmark.executeUpdate(conn0, this.queries.createPersonTab());
        BaseSelectRangeBenchmark.executeUpdate(conn0, this.queries.createOrgTab());
        BaseSelectRangeBenchmark.executeUpdate(conn0, this.queries.createSalaryIdx());
        BaseSelectRangeBenchmark.executeUpdate(conn0, this.queries.createOrgIdIdx());
        BaseSelectRangeBenchmark.executeUpdate(conn0, this.queries.beforeLoad());
        boolean oldAutoCommit = conn0.getAutoCommit();
        this.trySetAutoCommit(conn0, false);
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        long orgRng = this.args.range() / 10;
        BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)"Populating Organization table.");
        try (PreparedStatement insOrg = conn0.prepareStatement(this.queries.insertIntoOrganization());){
            percent = 0L;
            for (long orgId = 0L; orgId < orgRng; ++orgId) {
                insOrg.setLong(1, orgId);
                insOrg.setString(2, "organization#" + orgId);
                insOrg.addBatch();
                if ((orgId + 1L) % 10000L != 0L && orgId + 1L != orgRng) continue;
                insOrg.executeBatch();
                long newPercent = (orgId + 1L) * 100L / orgRng;
                if (percent == newPercent) continue;
                percent = newPercent;
                BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)(orgId + 1L + " out of " + orgRng + " rows have been uploaded (" + percent + "%)."));
            }
        }
        BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)"Populating Person table.");
        try (PreparedStatement insPers = conn0.prepareStatement(this.queries.insertIntoPerson());){
            percent = 0L;
            for (long persId = 0L; persId < (long)this.args.range(); ++persId) {
                long orgId = rnd.nextLong(orgRng);
                BaseSelectRangeBenchmark.fillPersonArgs(insPers, persId, orgId).addBatch();
                if ((persId + 1L) % 10000L != 0L) continue;
                insPers.executeBatch();
                long newPercent = (persId + 1L) * 100L / (long)this.args.range();
                if (percent == newPercent) continue;
                percent = newPercent;
                BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)(persId + 1L + " out of " + this.args.range() + " rows have been uploaded (" + percent + "%)."));
            }
        }
        this.trySetAutoCommit(conn0, oldAutoCommit);
        BaseSelectRangeBenchmark.executeUpdate(conn0, this.queries.afterLoad());
        BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)"Database have been populated.");
        String explainSql = "EXPLAIN " + this.testedSqlQuery();
        try (PreparedStatement expStat = conn0.prepareStatement(explainSql);){
            this.fillTestedQueryParams(expStat);
            try (ResultSet explain = expStat.executeQuery();){
                BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)("Explain query " + explainSql + " result:"));
                BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)BaseSelectRangeBenchmark.tableToString(explain));
            }
        }
    }

    private static String tableToString(ResultSet rs) throws SQLException {
        String cell;
        int i;
        StringBuilder buf = new StringBuilder();
        for (i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
            cell = String.format("%-20s", rs.getMetaData().getColumnName(i));
            buf.append(cell).append("\t");
        }
        buf.append("\n");
        while (rs.next()) {
            for (i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                cell = String.format("%-20s", rs.getString(i));
                buf.append(cell).append("\t");
            }
            buf.append("\t");
        }
        return buf.toString();
    }

    private void trySetAutoCommit(Connection conn, boolean autocommit) throws SQLException {
        try {
            conn.setAutoCommit(autocommit);
        }
        catch (SQLFeatureNotSupportedException ignored) {
            BenchmarkUtils.println((BenchmarkConfiguration)this.cfg, (String)("Failed to set auto commit to " + autocommit + " because it is unsupported operation, will just ignore it."));
        }
    }

    static void executeUpdate(Connection c, String sql) throws SQLException {
        if (F.isEmpty((String)sql)) {
            return;
        }
        try (Statement upd = c.createStatement();){
            upd.executeUpdate(sql);
        }
    }

    protected void fillRandomSalaryRange(PreparedStatement selectBySalary) throws SQLException {
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        long minId = rnd.nextLong(this.args.range() - this.args.sqlRange() + 1);
        long maxId = minId + (long)this.args.sqlRange() - 1L;
        long minSalary = minId * 1000L;
        long maxSalary = maxId * 1000L;
        selectBySalary.setLong(1, minSalary);
        selectBySalary.setLong(2, maxSalary);
    }

    public final boolean test(Map<Object, Object> map) throws Exception {
        PreparedStatement select0 = this.select.get();
        this.fillTestedQueryParams(select0);
        try (ResultSet res = select0.executeQuery();){
            this.readResults(res);
        }
        return true;
    }

    private void readResults(ResultSet qryRes) throws SQLException {
        long rsCnt = 0L;
        while (qryRes.next()) {
            ++rsCnt;
        }
        if (rsCnt != (long)this.args.sqlRange()) {
            throw new AssertionError((Object)("Server returned wrong number of lines: [expected=" + this.args.sqlRange() + ", actual=" + rsCnt + "]."));
        }
    }

    @Override
    public void tearDown() throws Exception {
        try {
            BaseSelectRangeBenchmark.executeUpdate((Connection)this.conn.get(), this.queries.dropPersonIfExist());
            BaseSelectRangeBenchmark.executeUpdate((Connection)this.conn.get(), this.queries.dropOrgIfExist());
            for (AutoCloseable stmt : this.toClose) {
                stmt.close();
            }
        }
        finally {
            super.tearDown();
        }
    }

    static PreparedStatement fillPersonArgs(PreparedStatement insPers, long id, long orgId) throws SQLException {
        insPers.setLong(1, id);
        insPers.setLong(2, orgId);
        insPers.setString(3, "firstName" + id);
        insPers.setString(4, "lastName" + id);
        insPers.setLong(5, id * 1000L);
        return insPers;
    }
}

