/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.jdbc;

import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;

public class DisjointRangeGenerator {
    private final int maxThreadsCnt;
    private final long rangeWidth;
    private final long tableSize;
    private final AtomicInteger registeredThreads = new AtomicInteger(0);
    private final ThreadLocal<Integer> threadOrder = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            if (DisjointRangeGenerator.this.maxThreadsCnt == DisjointRangeGenerator.this.registeredThreads.get()) {
                throw new IllegalStateException("Limit of threads using this generator exceeded. Limit is " + DisjointRangeGenerator.this.maxThreadsCnt);
            }
            return DisjointRangeGenerator.this.registeredThreads.getAndIncrement();
        }
    };

    public DisjointRangeGenerator(int maxThreadsCnt, long tableSize, long rangeWidth) {
        if (tableSize < (long)maxThreadsCnt * rangeWidth) {
            throw new IllegalArgumentException("Table size is too small to generate ranges");
        }
        this.maxThreadsCnt = maxThreadsCnt;
        this.rangeWidth = rangeWidth;
        this.tableSize = tableSize;
    }

    public long rangeWidth() {
        return this.rangeWidth;
    }

    public long nextRangeStartId() {
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        long blockWidth = this.rangeWidth * (long)this.maxThreadsCnt;
        long blocksCnt = this.tableSize / blockWidth;
        long firstBlockId = rnd.nextLong(blocksCnt) * blockWidth + 1L;
        long off = (long)this.threadOrder.get().intValue() * this.rangeWidth;
        return firstBlockId + off;
    }

    public long endRangeId(long startId) {
        return startId + this.rangeWidth - 1L;
    }
}

