/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache.dml;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.yardstick.cache.IgniteCacheAbstractBenchmark;
import org.apache.ignite.yardstick.cache.model.Person;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkUtils;

public class IgniteSqlDeleteFilteredBenchmark
extends IgniteCacheAbstractBenchmark<Integer, Object> {
    private AtomicInteger putCnt = new AtomicInteger();
    private AtomicInteger delCnt = new AtomicInteger();
    private AtomicLong delItemsCnt = new AtomicLong();

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
    }

    public boolean test(Map<Object, Object> ctx) throws Exception {
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        if (rnd.nextBoolean()) {
            double salary = rnd.nextDouble() * (double)this.args.range() * 1000.0;
            double maxSalary = salary + 1000.0;
            Long res = (Long)((List)this.cache().query(new SqlFieldsQuery("delete from Person where salary >= ? and salary <= ?").setArgs(new Object[]{salary, maxSalary})).getAll().get(0)).get(0);
            this.delItemsCnt.getAndAdd(res);
            this.delCnt.getAndIncrement();
        } else {
            int i = rnd.nextInt(this.args.range());
            this.cache.put((Object)i, (Object)new Person(i, "firstName" + i, "lastName" + i, i * 1000));
            this.putCnt.getAndIncrement();
        }
        return true;
    }

    @Override
    protected IgniteCache<Integer, Object> cache() {
        return this.ignite().cache("query");
    }

    @Override
    public void tearDown() throws Exception {
        BenchmarkUtils.println((BenchmarkConfiguration)this.cfg, (String)("Finished SQL DELETE query benchmark [putCnt=" + this.putCnt.get() + ", delCnt=" + this.delCnt.get() + ", delItemsCnt=" + this.delItemsCnt.get() + "]"));
        super.tearDown();
    }
}

