/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache;

import java.util.Map;
import java.util.TreeSet;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCompute;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.cache.CacheEntryProcessor;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.yardstick.cache.IgniteCacheAbstractBenchmark;
import org.apache.ignite.yardstick.cache.model.SampleValue;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkUtils;

public class IgniteGetFromComputeBenchmark
extends IgniteCacheAbstractBenchmark<Integer, Object> {
    private static final String CACHE_NAME = "atomic";
    private IgniteCompute compute;
    private IgniteCache asyncCache;
    private ThreadLocal<IgniteFuture> invokeFut = new ThreadLocal();

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        if (this.args.preloadAmount() > this.args.range()) {
            throw new IllegalArgumentException("Preloading amount (\"-pa\", \"--preloadAmount\") must by less then the range (\"-r\", \"--range\").");
        }
        String cacheName = this.cache().getName();
        BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)("Loading data for cache: " + cacheName));
        long start = System.nanoTime();
        try (IgniteDataStreamer dataLdr = this.ignite().dataStreamer(cacheName);){
            for (int i = 0; i < this.args.preloadAmount(); ++i) {
                dataLdr.addData((Object)i, (Object)new SampleValue(i));
                if (i % 100000 != 0) continue;
                if (Thread.currentThread().isInterrupted()) {
                    break;
                }
                BenchmarkUtils.println((String)("Loaded entries: " + i));
            }
        }
        BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)("Finished populating data [time=" + (System.nanoTime() - start) / 1000000L + "ms, amount=" + this.args.preloadAmount() + "]"));
        this.compute = this.ignite().compute();
        this.asyncCache = this.cache().withAsync();
    }

    public boolean test(Map<Object, Object> ctx) throws Exception {
        IgniteFuture fut = this.invokeFut.get();
        if (fut == null || fut.isDone()) {
            TreeSet<Integer> keys = new TreeSet<Integer>();
            for (int i = 0; i < 3; ++i) {
                keys.add(IgniteGetFromComputeBenchmark.nextRandom(this.args.range()));
            }
            this.asyncCache.invokeAll(keys, (CacheEntryProcessor)new SlowEntryProcessor(0), new Object[0]);
            this.invokeFut.set(this.asyncCache.future());
        }
        int key = IgniteGetFromComputeBenchmark.nextRandom(this.args.range());
        this.compute.affinityCall(CACHE_NAME, (Object)key, (IgniteCallable)new GetClosure(key));
        return true;
    }

    @Override
    protected IgniteCache<Integer, Object> cache() {
        return this.ignite().cache(CACHE_NAME);
    }

    public static class SlowEntryProcessor
    implements CacheEntryProcessor<Integer, Object, Object> {
        private Object val;

        public SlowEntryProcessor(Object val) {
            this.val = val;
        }

        public Object process(MutableEntry<Integer, Object> entry, Object ... args) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            entry.setValue(this.val);
            return null;
        }
    }

    public static class GetClosure
    implements IgniteCallable<Object> {
        @IgniteInstanceResource
        private Ignite ignite;
        private final int key;

        public GetClosure(int key) {
            this.key = key;
        }

        public Object call() throws Exception {
            return this.ignite.cache(IgniteGetFromComputeBenchmark.CACHE_NAME).get((Object)this.key);
        }
    }
}

