/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.indexing;

import java.util.Set;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheAffinityManager;

public class IndexingQueryCacheFilter {
    private final GridCacheAffinityManager aff;
    private final Set<Integer> parts;
    private final AffinityTopologyVersion topVer;
    private final ClusterNode locNode;

    public IndexingQueryCacheFilter(GridCacheAffinityManager aff, Set<Integer> parts, AffinityTopologyVersion topVer, ClusterNode locNode) {
        this.aff = aff;
        this.parts = parts;
        this.topVer = topVer;
        this.locNode = locNode;
    }

    public boolean apply(Object key) {
        int part = this.aff.partition(key);
        return this.applyPartition(part);
    }

    public boolean applyPartition(int part) {
        if (this.parts == null) {
            return this.aff.primaryByPartition(this.locNode, part, this.topVer);
        }
        return this.parts.contains(part);
    }
}

