/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cluster.baseline.autoadjust;

import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.cluster.DistributedBaselineConfiguration;
import org.apache.ignite.internal.cluster.IgniteClusterImpl;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCachePartitionExchangeManager;
import org.apache.ignite.internal.processors.cluster.GridClusterStateProcessor;
import org.apache.ignite.internal.processors.cluster.baseline.autoadjust.BaselineAutoAdjustData;
import org.apache.ignite.internal.processors.cluster.baseline.autoadjust.BaselineAutoAdjustExecutor;
import org.apache.ignite.internal.processors.cluster.baseline.autoadjust.BaselineAutoAdjustScheduler;
import org.apache.ignite.internal.processors.cluster.baseline.autoadjust.BaselineAutoAdjustStatus;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.internal.CU;

public class BaselineTopologyUpdater {
    public static final int DFLT_BASELINE_AUTO_ADJUST_LOG_INTERVAL = 60000;
    private final IgniteLogger log;
    private final IgniteClusterImpl cluster;
    private final GridCachePartitionExchangeManager<?, ?> exchangeManager;
    private final DistributedBaselineConfiguration baselineConfiguration;
    private final GridDiscoveryManager discoveryMgr;
    private final GridClusterStateProcessor stateProcessor;
    private final BaselineAutoAdjustScheduler baselineAutoAdjustScheduler;
    private final boolean isPersistenceEnabled;
    private final boolean isSupportedByLocalNode;
    private BaselineAutoAdjustData lastBaselineData = BaselineAutoAdjustData.NULL_BASELINE_DATA;

    public BaselineTopologyUpdater(GridKernalContext ctx) {
        this.log = ctx.log(BaselineTopologyUpdater.class);
        this.cluster = ctx.cluster().get();
        this.baselineConfiguration = ctx.state().baselineConfiguration();
        this.exchangeManager = ctx.cache().context().exchange();
        this.stateProcessor = ctx.state();
        this.baselineAutoAdjustScheduler = new BaselineAutoAdjustScheduler(ctx.timeout(), new BaselineAutoAdjustExecutor(ctx.log(BaselineAutoAdjustExecutor.class), this.cluster, ctx.pools().getSystemExecutorService(), this::isTopologyWatcherEnabled), ctx.log(BaselineAutoAdjustScheduler.class));
        this.discoveryMgr = ctx.discovery();
        this.isSupportedByLocalNode = !ctx.clientNode();
        this.isPersistenceEnabled = CU.isPersistenceEnabled(this.cluster.ignite().configuration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerBaselineUpdate(long topologyVersion) {
        if (!this.isTopologyWatcherEnabled()) {
            BaselineTopologyUpdater baselineTopologyUpdater = this;
            synchronized (baselineTopologyUpdater) {
                this.lastBaselineData = BaselineAutoAdjustData.NULL_BASELINE_DATA;
            }
            return;
        }
        BaselineTopologyUpdater baselineTopologyUpdater = this;
        synchronized (baselineTopologyUpdater) {
            BaselineAutoAdjustData baselineData = this.lastBaselineData = this.lastBaselineData.next(topologyVersion);
            if (IgniteUtils.isLocalNodeCoordinator(this.discoveryMgr)) {
                this.exchangeManager.affinityReadyFuture(new AffinityTopologyVersion(topologyVersion)).listen(future -> {
                    if (future.error() != null) {
                        return;
                    }
                    if (this.exchangeManager.lastFinishedFuture().hasLostPartitions()) {
                        this.log.warning("Baseline won't be changed cause lost partitions were detected");
                        return;
                    }
                    long timeout = this.baselineConfiguration.getBaselineAutoAdjustTimeout();
                    if (this.baselineAutoAdjustScheduler.schedule(baselineData, timeout)) {
                        this.log.warning("Baseline auto-adjust will be executed in '" + timeout + "' ms");
                    }
                });
            }
        }
    }

    private boolean isTopologyWatcherEnabled() {
        return this.isSupportedByLocalNode && this.stateProcessor.clusterState().active() && this.baselineConfiguration.isBaselineAutoAdjustEnabled() && (this.isPersistenceEnabled || this.cluster.baselineAutoAdjustTimeout() != 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaselineAutoAdjustStatus getStatus() {
        BaselineTopologyUpdater baselineTopologyUpdater = this;
        synchronized (baselineTopologyUpdater) {
            if (this.lastBaselineData.isAdjusted() || this.baselineAutoAdjustScheduler.isExecutionExpired(this.lastBaselineData)) {
                return BaselineAutoAdjustStatus.notScheduled();
            }
            long timeToLastTask = this.baselineAutoAdjustScheduler.lastScheduledTaskTime();
            if (timeToLastTask <= 0L) {
                return BaselineAutoAdjustStatus.inProgress();
            }
            return BaselineAutoAdjustStatus.scheduled(timeToLastTask);
        }
    }
}

