/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.testing.async;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.client5.testing.auth.AuthResult;
import org.apache.hc.client5.testing.auth.AuthenticationHandler;
import org.apache.hc.client5.testing.auth.Authenticator;
import org.apache.hc.client5.testing.auth.BasicAuthenticationHandler;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.AsyncResponseProducer;
import org.apache.hc.core5.http.nio.AsyncServerExchangeHandler;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.ResponseChannel;
import org.apache.hc.core5.http.nio.entity.BasicAsyncEntityProducer;
import org.apache.hc.core5.http.nio.support.BasicResponseProducer;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.util.Args;

public class AuthenticatingAsyncDecorator
implements AsyncServerExchangeHandler {
    private final AsyncServerExchangeHandler exchangeHandler;
    private final AuthenticationHandler<String> authenticationHandler;
    private final Authenticator authenticator;
    private final AtomicReference<AsyncResponseProducer> responseProducerRef;

    public AuthenticatingAsyncDecorator(AsyncServerExchangeHandler exchangeHandler, AuthenticationHandler<String> authenticationHandler, Authenticator authenticator) {
        this.exchangeHandler = (AsyncServerExchangeHandler)Args.notNull((Object)exchangeHandler, (String)"Request handler");
        this.authenticationHandler = (AuthenticationHandler)Args.notNull(authenticationHandler, (String)"Authentication handler");
        this.authenticator = (Authenticator)Args.notNull((Object)authenticator, (String)"Authenticator");
        this.responseProducerRef = new AtomicReference();
    }

    public AuthenticatingAsyncDecorator(AsyncServerExchangeHandler exchangeHandler, Authenticator authenticator) {
        this(exchangeHandler, new BasicAuthenticationHandler(), authenticator);
    }

    protected void customizeUnauthorizedResponse(HttpResponse unauthorized) {
    }

    public void handleRequest(HttpRequest request, EntityDetails entityDetails, ResponseChannel responseChannel, HttpContext context) throws HttpException, IOException {
        boolean expectContinue;
        Header h = request.getFirstHeader("Authorization");
        String challengeResponse = h != null ? this.authenticationHandler.extractAuthToken(h.getValue()) : null;
        URIAuthority authority = request.getAuthority();
        String requestUri = request.getRequestUri();
        AuthResult authResult = this.authenticator.perform(authority, requestUri, challengeResponse);
        Header expect = request.getFirstHeader("Expect");
        boolean bl = expectContinue = expect != null && "100-continue".equalsIgnoreCase(expect.getValue());
        if (authResult.isSuccess()) {
            if (expectContinue) {
                responseChannel.sendInformation((HttpResponse)new BasicClassicHttpResponse(100), context);
            }
            this.exchangeHandler.handleRequest(request, entityDetails, responseChannel, context);
        } else {
            BasicHttpResponse unauthorized = new BasicHttpResponse(401);
            ArrayList<NameValuePair> challengeParams = new ArrayList<NameValuePair>();
            String realm = this.authenticator.getRealm(authority, requestUri);
            if (realm != null) {
                challengeParams.add((NameValuePair)new BasicNameValuePair("realm", realm));
            }
            if (authResult.hasParams()) {
                challengeParams.addAll(authResult.getParams());
            }
            String challenge = this.authenticationHandler.challenge(challengeParams);
            unauthorized.addHeader("WWW-Authenticate", (Object)challenge);
            this.customizeUnauthorizedResponse((HttpResponse)unauthorized);
            BasicResponseProducer responseProducer = new BasicResponseProducer((HttpResponse)unauthorized, (AsyncEntityProducer)new BasicAsyncEntityProducer((CharSequence)"Unauthorized", ContentType.TEXT_PLAIN));
            this.responseProducerRef.set((AsyncResponseProducer)responseProducer);
            responseProducer.sendResponse(responseChannel, context);
        }
    }

    public final void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        AsyncResponseProducer responseProducer = this.responseProducerRef.get();
        if (responseProducer == null) {
            this.exchangeHandler.updateCapacity(capacityChannel);
        } else {
            capacityChannel.update(Integer.MAX_VALUE);
        }
    }

    public final void consume(ByteBuffer src) throws IOException {
        AsyncResponseProducer responseProducer = this.responseProducerRef.get();
        if (responseProducer == null) {
            this.exchangeHandler.consume(src);
        }
    }

    public final void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
        AsyncResponseProducer responseProducer = this.responseProducerRef.get();
        if (responseProducer == null) {
            this.exchangeHandler.streamEnd(trailers);
        }
    }

    public final int available() {
        AsyncResponseProducer responseProducer = this.responseProducerRef.get();
        if (responseProducer == null) {
            return this.exchangeHandler.available();
        }
        return responseProducer.available();
    }

    public final void produce(DataStreamChannel channel) throws IOException {
        AsyncResponseProducer responseProducer = this.responseProducerRef.get();
        if (responseProducer == null) {
            this.exchangeHandler.produce(channel);
        } else {
            responseProducer.produce(channel);
        }
    }

    public final void failed(Exception cause) {
        try {
            this.exchangeHandler.failed(cause);
            AsyncResponseProducer dataProducer = this.responseProducerRef.getAndSet(null);
            if (dataProducer != null) {
                dataProducer.failed(cause);
            }
        }
        finally {
            this.releaseResources();
        }
    }

    public final void releaseResources() {
        this.exchangeHandler.releaseResources();
        AsyncResponseProducer dataProducer = this.responseProducerRef.getAndSet(null);
        if (dataProducer != null) {
            dataProducer.releaseResources();
        }
    }
}

