/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.agent;

import groovyx.gpars.actor.Actors;
import groovyx.gpars.group.PGroup;
import groovyx.gpars.scheduler.Pool;
import groovyx.gpars.util.AsyncMessagingCore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AgentCore {
    private final AsyncMessagingCore core = new AsyncMessagingCore(Actors.defaultActorPGroup.getThreadPool()){

        @Override
        protected void registerError(Throwable e) {
            AgentCore.this.registerError(e);
        }

        @Override
        protected void handleMessage(Object message) {
            AgentCore.this.handleMessage(message);
        }

        @Override
        protected void threadAssigned() {
            AgentCore.this.currentThread = Thread.currentThread();
        }

        @Override
        protected void threadUnassigned() {
            AgentCore.this.currentThread = null;
        }
    };
    protected volatile Thread currentThread;
    private List<Throwable> errors;

    protected AgentCore() {
    }

    public final void attachToThreadPool(Pool threadPool) {
        this.core.attachToThreadPool(threadPool);
    }

    public void setPGroup(PGroup pGroup) {
        this.attachToThreadPool(pGroup.getThreadPool());
    }

    public boolean isFair() {
        return this.core.isFair();
    }

    public void makeFair() {
        this.core.makeFair();
    }

    public final void send(Object message) {
        this.core.store(message);
    }

    public final void leftShift(Object message) {
        this.send(message);
    }

    public final void call(Object message) {
        this.send(message);
    }

    abstract void handleMessage(Object var1);

    synchronized void registerError(Throwable e) {
        if (this.errors == null) {
            this.errors = new ArrayList<Throwable>();
        }
        this.errors.add(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<Throwable> getErrors() {
        if (this.errors == null) {
            return Collections.emptyList();
        }
        try {
            List<Throwable> list = this.errors;
            return list;
        }
        finally {
            this.errors = null;
        }
    }

    public synchronized boolean hasErrors() {
        if (this.errors == null) {
            return false;
        }
        return !this.errors.isEmpty();
    }
}

