/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.dump;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.HistogramStatistics;
import org.apache.flink.metrics.Meter;
import org.apache.flink.runtime.metrics.dump.MetricDump;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricDumpSerialization {
    private static final Logger LOG = LoggerFactory.getLogger(MetricDumpSerialization.class);

    private MetricDumpSerialization() {
    }

    private static void serializeMetricInfo(DataOutput out, QueryScopeInfo info) throws IOException {
        out.writeUTF(info.scope);
        out.writeByte(info.getCategory());
        switch (info.getCategory()) {
            case 0: {
                break;
            }
            case 1: {
                String tmID = ((QueryScopeInfo.TaskManagerQueryScopeInfo)info).taskManagerID;
                out.writeUTF(tmID);
                break;
            }
            case 2: {
                QueryScopeInfo.JobQueryScopeInfo jobInfo = (QueryScopeInfo.JobQueryScopeInfo)info;
                out.writeUTF(jobInfo.jobID);
                break;
            }
            case 3: {
                QueryScopeInfo.TaskQueryScopeInfo taskInfo = (QueryScopeInfo.TaskQueryScopeInfo)info;
                out.writeUTF(taskInfo.jobID);
                out.writeUTF(taskInfo.vertexID);
                out.writeInt(taskInfo.subtaskIndex);
                break;
            }
            case 4: {
                QueryScopeInfo.OperatorQueryScopeInfo operatorInfo = (QueryScopeInfo.OperatorQueryScopeInfo)info;
                out.writeUTF(operatorInfo.jobID);
                out.writeUTF(operatorInfo.vertexID);
                out.writeInt(operatorInfo.subtaskIndex);
                out.writeUTF(operatorInfo.operatorName);
                break;
            }
            default: {
                throw new IOException("Unknown scope category: " + info.getCategory());
            }
        }
    }

    private static void serializeCounter(DataOutput out, QueryScopeInfo info, String name, Counter counter) throws IOException {
        long count = counter.getCount();
        MetricDumpSerialization.serializeMetricInfo(out, info);
        out.writeUTF(name);
        out.writeLong(count);
    }

    private static void serializeGauge(DataOutput out, QueryScopeInfo info, String name, Gauge<?> gauge) throws IOException {
        Object value = gauge.getValue();
        if (value == null) {
            throw new NullPointerException("Value returned by gauge " + name + " was null.");
        }
        String stringValue = value.toString();
        if (stringValue == null) {
            throw new NullPointerException("toString() of the value returned by gauge " + name + " returned null.");
        }
        MetricDumpSerialization.serializeMetricInfo(out, info);
        out.writeUTF(name);
        out.writeUTF(stringValue);
    }

    private static void serializeHistogram(DataOutput out, QueryScopeInfo info, String name, Histogram histogram) throws IOException {
        HistogramStatistics stat = histogram.getStatistics();
        long min = stat.getMin();
        long max = stat.getMax();
        double mean = stat.getMean();
        double median = stat.getQuantile(0.5);
        double stddev = stat.getStdDev();
        double p75 = stat.getQuantile(0.75);
        double p90 = stat.getQuantile(0.9);
        double p95 = stat.getQuantile(0.95);
        double p98 = stat.getQuantile(0.98);
        double p99 = stat.getQuantile(0.99);
        double p999 = stat.getQuantile(0.999);
        MetricDumpSerialization.serializeMetricInfo(out, info);
        out.writeUTF(name);
        out.writeLong(min);
        out.writeLong(max);
        out.writeDouble(mean);
        out.writeDouble(median);
        out.writeDouble(stddev);
        out.writeDouble(p75);
        out.writeDouble(p90);
        out.writeDouble(p95);
        out.writeDouble(p98);
        out.writeDouble(p99);
        out.writeDouble(p999);
    }

    private static void serializeMeter(DataOutput out, QueryScopeInfo info, String name, Meter meter) throws IOException {
        MetricDumpSerialization.serializeMetricInfo(out, info);
        out.writeUTF(name);
        out.writeDouble(meter.getRate());
    }

    private static MetricDump.CounterDump deserializeCounter(DataInputView dis) throws IOException {
        QueryScopeInfo scope = MetricDumpSerialization.deserializeMetricInfo(dis);
        String name = dis.readUTF();
        long count = dis.readLong();
        return new MetricDump.CounterDump(scope, name, count);
    }

    private static MetricDump.GaugeDump deserializeGauge(DataInputView dis) throws IOException {
        QueryScopeInfo scope = MetricDumpSerialization.deserializeMetricInfo(dis);
        String name = dis.readUTF();
        String value = dis.readUTF();
        return new MetricDump.GaugeDump(scope, name, value);
    }

    private static MetricDump.HistogramDump deserializeHistogram(DataInputView dis) throws IOException {
        QueryScopeInfo info = MetricDumpSerialization.deserializeMetricInfo(dis);
        String name = dis.readUTF();
        long min = dis.readLong();
        long max = dis.readLong();
        double mean = dis.readDouble();
        double median = dis.readDouble();
        double stddev = dis.readDouble();
        double p75 = dis.readDouble();
        double p90 = dis.readDouble();
        double p95 = dis.readDouble();
        double p98 = dis.readDouble();
        double p99 = dis.readDouble();
        double p999 = dis.readDouble();
        return new MetricDump.HistogramDump(info, name, min, max, mean, median, stddev, p75, p90, p95, p98, p99, p999);
    }

    private static MetricDump.MeterDump deserializeMeter(DataInputView dis) throws IOException {
        QueryScopeInfo info = MetricDumpSerialization.deserializeMetricInfo(dis);
        String name = dis.readUTF();
        double rate = dis.readDouble();
        return new MetricDump.MeterDump(info, name, rate);
    }

    private static QueryScopeInfo deserializeMetricInfo(DataInput dis) throws IOException {
        String scope = dis.readUTF();
        byte cat = dis.readByte();
        switch (cat) {
            case 0: {
                return new QueryScopeInfo.JobManagerQueryScopeInfo(scope);
            }
            case 1: {
                String tmID = dis.readUTF();
                return new QueryScopeInfo.TaskManagerQueryScopeInfo(tmID, scope);
            }
            case 2: {
                String jobID = dis.readUTF();
                return new QueryScopeInfo.JobQueryScopeInfo(jobID, scope);
            }
            case 3: {
                String jobID = dis.readUTF();
                String vertexID = dis.readUTF();
                int subtaskIndex = dis.readInt();
                return new QueryScopeInfo.TaskQueryScopeInfo(jobID, vertexID, subtaskIndex, scope);
            }
            case 4: {
                String jobID = dis.readUTF();
                String vertexID = dis.readUTF();
                int subtaskIndex = dis.readInt();
                String operatorName = dis.readUTF();
                return new QueryScopeInfo.OperatorQueryScopeInfo(jobID, vertexID, subtaskIndex, operatorName, scope);
            }
        }
        throw new IOException("Unknown scope category: " + cat);
    }

    public static class MetricDumpDeserializer {
        public List<MetricDump> deserialize(MetricSerializationResult data) {
            int x;
            DataInputDeserializer countersInputView = new DataInputDeserializer(data.serializedCounters, 0, data.serializedCounters.length);
            DataInputDeserializer gaugesInputView = new DataInputDeserializer(data.serializedGauges, 0, data.serializedGauges.length);
            DataInputDeserializer metersInputView = new DataInputDeserializer(data.serializedMeters, 0, data.serializedMeters.length);
            DataInputDeserializer histogramsInputView = new DataInputDeserializer(data.serializedHistograms, 0, data.serializedHistograms.length);
            ArrayList<MetricDump> metrics = new ArrayList<MetricDump>(data.numCounters + data.numGauges + data.numMeters + data.numHistograms);
            for (x = 0; x < data.numCounters; ++x) {
                try {
                    metrics.add(MetricDumpSerialization.deserializeCounter(countersInputView));
                    continue;
                }
                catch (Exception e) {
                    LOG.debug("Failed to deserialize counter.", (Throwable)e);
                }
            }
            for (x = 0; x < data.numGauges; ++x) {
                try {
                    metrics.add(MetricDumpSerialization.deserializeGauge(gaugesInputView));
                    continue;
                }
                catch (Exception e) {
                    LOG.debug("Failed to deserialize gauge.", (Throwable)e);
                }
            }
            for (x = 0; x < data.numMeters; ++x) {
                try {
                    metrics.add(MetricDumpSerialization.deserializeMeter(metersInputView));
                    continue;
                }
                catch (Exception e) {
                    LOG.debug("Failed to deserialize meter.", (Throwable)e);
                }
            }
            for (x = 0; x < data.numHistograms; ++x) {
                try {
                    metrics.add(MetricDumpSerialization.deserializeHistogram(histogramsInputView));
                    continue;
                }
                catch (Exception e) {
                    LOG.debug("Failed to deserialize histogram.", (Throwable)e);
                }
            }
            return metrics;
        }
    }

    public static class MetricDumpSerializer {
        private DataOutputSerializer countersBuffer = new DataOutputSerializer(8192);
        private DataOutputSerializer gaugesBuffer = new DataOutputSerializer(8192);
        private DataOutputSerializer metersBuffer = new DataOutputSerializer(8192);
        private DataOutputSerializer histogramsBuffer = new DataOutputSerializer(8192);

        /*
         * WARNING - void declaration
         */
        public MetricSerializationResult serialize(Map<Counter, Tuple2<QueryScopeInfo, String>> counters, Map<Gauge<?>, Tuple2<QueryScopeInfo, String>> gauges, Map<Histogram, Tuple2<QueryScopeInfo, String>> histograms, Map<Meter, Tuple2<QueryScopeInfo, String>> meters) {
            void var8_17;
            void var7_11;
            this.countersBuffer.clear();
            int numCounters = 0;
            for (Map.Entry<Counter, Tuple2<QueryScopeInfo, String>> entry : counters.entrySet()) {
                try {
                    MetricDumpSerialization.serializeCounter(this.countersBuffer, (QueryScopeInfo)entry.getValue().f0, (String)entry.getValue().f1, entry.getKey());
                    ++numCounters;
                }
                catch (Exception exception) {
                    LOG.debug("Failed to serialize counter.", (Throwable)exception);
                }
            }
            this.gaugesBuffer.clear();
            int numGauges = 0;
            for (Map.Entry<Gauge<?>, Tuple2<QueryScopeInfo, String>> entry : gauges.entrySet()) {
                try {
                    MetricDumpSerialization.serializeGauge(this.gaugesBuffer, (QueryScopeInfo)entry.getValue().f0, (String)entry.getValue().f1, entry.getKey());
                    ++numGauges;
                }
                catch (Exception exception) {
                    LOG.debug("Failed to serialize gauge.", (Throwable)exception);
                }
            }
            this.histogramsBuffer.clear();
            boolean bl = false;
            for (Map.Entry<Histogram, Tuple2<QueryScopeInfo, String>> entry : histograms.entrySet()) {
                try {
                    MetricDumpSerialization.serializeHistogram(this.histogramsBuffer, (QueryScopeInfo)entry.getValue().f0, (String)entry.getValue().f1, entry.getKey());
                    ++var7_11;
                }
                catch (Exception e) {
                    LOG.debug("Failed to serialize histogram.", (Throwable)e);
                }
            }
            this.metersBuffer.clear();
            boolean bl2 = false;
            for (Map.Entry<Meter, Tuple2<QueryScopeInfo, String>> entry : meters.entrySet()) {
                try {
                    MetricDumpSerialization.serializeMeter(this.metersBuffer, (QueryScopeInfo)entry.getValue().f0, (String)entry.getValue().f1, entry.getKey());
                    ++var8_17;
                }
                catch (Exception e) {
                    LOG.debug("Failed to serialize meter.", (Throwable)e);
                }
            }
            return new MetricSerializationResult(this.countersBuffer.getCopyOfBuffer(), this.gaugesBuffer.getCopyOfBuffer(), this.metersBuffer.getCopyOfBuffer(), this.histogramsBuffer.getCopyOfBuffer(), numCounters, numGauges, (int)var8_17, (int)var7_11);
        }

        public void close() {
            this.countersBuffer = null;
            this.gaugesBuffer = null;
            this.metersBuffer = null;
            this.histogramsBuffer = null;
        }
    }

    public static class MetricSerializationResult
    implements Serializable {
        private static final long serialVersionUID = 6928770855951536906L;
        public final byte[] serializedCounters;
        public final byte[] serializedGauges;
        public final byte[] serializedMeters;
        public final byte[] serializedHistograms;
        public final int numCounters;
        public final int numGauges;
        public final int numMeters;
        public final int numHistograms;

        public MetricSerializationResult(byte[] serializedCounters, byte[] serializedGauges, byte[] serializedMeters, byte[] serializedHistograms, int numCounters, int numGauges, int numMeters, int numHistograms) {
            Preconditions.checkNotNull(serializedCounters);
            Preconditions.checkNotNull(serializedGauges);
            Preconditions.checkNotNull(serializedMeters);
            Preconditions.checkNotNull(serializedHistograms);
            Preconditions.checkArgument(numCounters >= 0);
            Preconditions.checkArgument(numGauges >= 0);
            Preconditions.checkArgument(numMeters >= 0);
            Preconditions.checkArgument(numHistograms >= 0);
            this.serializedCounters = serializedCounters;
            this.serializedGauges = serializedGauges;
            this.serializedMeters = serializedMeters;
            this.serializedHistograms = serializedHistograms;
            this.numCounters = numCounters;
            this.numGauges = numGauges;
            this.numMeters = numMeters;
            this.numHistograms = numHistograms;
        }
    }
}

