/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.kafka.clients.admin;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.table.store.shaded.org.apache.kafka.clients.admin.LogDirDescription;
import org.apache.flink.table.store.shaded.org.apache.kafka.clients.admin.ReplicaInfo;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.KafkaFuture;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.requests.DescribeLogDirsResponse;

@InterfaceStability.Evolving
public class DescribeLogDirsResult {
    private final Map<Integer, KafkaFuture<Map<String, LogDirDescription>>> futures;

    DescribeLogDirsResult(Map<Integer, KafkaFuture<Map<String, LogDirDescription>>> futures) {
        this.futures = futures;
    }

    @Deprecated
    public Map<Integer, KafkaFuture<Map<String, DescribeLogDirsResponse.LogDirInfo>>> values() {
        return this.descriptions().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((KafkaFuture)entry.getValue()).thenApply(map -> this.convertMapValues((Map<String, LogDirDescription>)map))));
    }

    private Map<String, DescribeLogDirsResponse.LogDirInfo> convertMapValues(Map<String, LogDirDescription> map) {
        Stream stream = map.entrySet().stream();
        return stream.collect(Collectors.toMap(Map.Entry::getKey, infoEntry -> {
            LogDirDescription logDir = (LogDirDescription)infoEntry.getValue();
            return new DescribeLogDirsResponse.LogDirInfo(logDir.error() == null ? Errors.NONE : Errors.forException(logDir.error()), logDir.replicaInfos().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, replicaEntry -> new DescribeLogDirsResponse.ReplicaInfo(((ReplicaInfo)replicaEntry.getValue()).size(), ((ReplicaInfo)replicaEntry.getValue()).offsetLag(), ((ReplicaInfo)replicaEntry.getValue()).isFuture()))));
        }));
    }

    public Map<Integer, KafkaFuture<Map<String, LogDirDescription>>> descriptions() {
        return this.futures;
    }

    @Deprecated
    public KafkaFuture<Map<Integer, Map<String, DescribeLogDirsResponse.LogDirInfo>>> all() {
        return this.allDescriptions().thenApply(map -> map.entrySet().stream().collect(Collectors.toMap(entry -> (Integer)entry.getKey(), entry -> this.convertMapValues((Map)entry.getValue()))));
    }

    public KafkaFuture<Map<Integer, Map<String, LogDirDescription>>> allDescriptions() {
        return KafkaFuture.allOf(this.futures.values().toArray(new KafkaFuture[0])).thenApply(v -> {
            HashMap<Integer, Map<String, LogDirDescription>> descriptions = new HashMap<Integer, Map<String, LogDirDescription>>(this.futures.size());
            for (Map.Entry<Integer, KafkaFuture<Map<String, LogDirDescription>>> entry : this.futures.entrySet()) {
                try {
                    descriptions.put(entry.getKey(), entry.getValue().get());
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
            return descriptions;
        });
    }
}

