/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.writer;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.flink.table.store.file.writer.FileWriter;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;

public class RollingFileWriter<T, R>
implements FileWriter<T, List<R>> {
    private final Supplier<? extends FileWriter<T, R>> writerFactory;
    private final long targetFileSize;
    private final List<FileWriter<T, R>> openedWriters;
    private final List<R> results;
    private FileWriter<T, R> currentWriter = null;
    private long lengthOfClosedFiles = 0L;
    private long recordCount = 0L;
    private boolean closed = false;

    public RollingFileWriter(Supplier<? extends FileWriter<T, R>> writerFactory, long targetFileSize) {
        this.writerFactory = writerFactory;
        this.targetFileSize = targetFileSize;
        this.openedWriters = new ArrayList<FileWriter<T, R>>();
        this.results = new ArrayList<R>();
    }

    @Override
    public void write(T row) throws IOException {
        if (this.currentWriter == null) {
            this.openCurrentWriter();
        }
        this.currentWriter.write(row);
        ++this.recordCount;
        if (this.currentWriter.length() >= this.targetFileSize) {
            this.closeCurrentWriter();
        }
    }

    private void openCurrentWriter() {
        this.currentWriter = this.writerFactory.get();
        this.openedWriters.add(this.currentWriter);
    }

    private void closeCurrentWriter() {
        if (this.currentWriter != null) {
            try {
                this.lengthOfClosedFiles += this.currentWriter.length();
                this.currentWriter.close();
                this.results.add(this.currentWriter.result());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            this.currentWriter = null;
        }
    }

    @Override
    public long recordCount() {
        return this.recordCount;
    }

    @Override
    public long length() throws IOException {
        long length = this.lengthOfClosedFiles;
        if (this.currentWriter != null) {
            length += this.currentWriter.length();
        }
        return length;
    }

    @Override
    public void abort() {
        IOUtils.closeQuietly((AutoCloseable)this);
        for (FileWriter<T, R> writer : this.openedWriters) {
            writer.abort();
        }
    }

    @Override
    public List<R> result() {
        Preconditions.checkState((boolean)this.closed, (Object)"Cannot access the results unless close all writers.");
        return this.results;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closeCurrentWriter();
            this.closed = true;
        }
    }
}

