/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationRun;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.TestConfiguration;

public class KillMaster
extends BaseJDBCTestCase {
    private static String masterJvmVersion = null;
    private static String derbyMasterVersion = null;
    private static String masterServerHost = null;
    private static int masterServerPort = -1;
    private static ReplicationRun repRun = new ReplicationRun("KillMaster");

    public KillMaster(String string) {
        super(string);
    }

    public static Test suite() throws Exception {
        System.out.println("**** KillMaster.suite()");
        System.out.println("'KillMaster' can not be run outside the 'ReplicationRun' framework.");
        BaseTestSuite baseTestSuite = new BaseTestSuite("KillMaster");
        String string = System.getProperty("test.serverHost", "localhost");
        int n = Integer.parseInt(System.getProperty("test.serverPort", "1527"));
        masterServerHost = string;
        masterServerPort = n;
        repRun.initEnvironment();
        masterJvmVersion = ReplicationRun.masterJvmVersion;
        derbyMasterVersion = ReplicationRun.derbyMasterVersion;
        baseTestSuite.addTest(KillMaster.suite(string, n));
        return baseTestSuite;
    }

    public static Test suite(String string, int n) throws IOException {
        System.out.println("*** KillMaster.replSuite(serverHost,serverPort)");
        Test test = TestConfiguration.existingServerSuite(KillMaster.class, false, string, n);
        System.out.println("*** Done TestConfiguration.defaultExistingServerSuite(KillMaster.class,false,serverHost,serverPort)");
        return test;
    }

    public void testKillMaster() throws Exception {
        Statement statement;
        Connection connection;
        block3: {
            int n;
            System.out.println("**** KillMaster.testKillMaster() " + this.getTestConfiguration().getJDBCClient().getJDBCDriverName());
            connection = this.getConnection();
            statement = connection.createStatement();
            statement.executeUpdate("create table t (i integer primary key, vc varchar(20))");
            PreparedStatement preparedStatement = this.prepareStatement("insert into t values (?,?)");
            try {
                for (n = 0; n < 1000; ++n) {
                    preparedStatement.setInt(1, n);
                    preparedStatement.setString(2, "i" + n);
                    preparedStatement.execute();
                    System.out.println("i: " + n);
                    if (n != 500) continue;
                    repRun.killMaster(masterServerHost, masterServerPort);
                }
            }
            catch (SQLException sQLException) {
                System.out.println("SQLException @ i=" + n + " (" + sQLException.getMessage() + ")");
                if (n > 500) break block3;
                KillMaster.fail((String)("**** Unexpected SQLException @ i=" + n + " (" + sQLException.getMessage() + ")"));
            }
        }
        connection.close();
        Thread.sleep(5000L);
        repRun.startServer(masterJvmVersion, derbyMasterVersion, masterServerHost, "0.0.0.0", masterServerPort, ReplicationRun.masterDbSubPath);
        connection = this.getConnection();
        statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select count(*) from t");
        resultSet.next();
        int n = resultSet.getInt(1);
        System.out.println("count: " + n);
    }
}

