/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.File;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Properties;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.ClasspathSetup;
import org.apache.derbyTesting.junit.DatabaseChangeSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.TimeZoneTestSetup;

public class NativeAuthenticationServiceTest
extends GeneratedColumnsHelper {
    private static final int FILE = 0;
    private static final int JAR = 1;
    private static final int CLASSPATH = 2;
    private static final int NONE = 3;
    private static final int JAR_ENCRYPTED = 4;
    private static final boolean NATIVE = true;
    private static final boolean NO_AUTH = false;
    private static final boolean LOCAL = true;
    private static final boolean SYSTEM_WIDE = false;
    private static final boolean DISABLE_AUTHORIZATION = true;
    private static final boolean DONT_DISABLE_AUTH = false;
    private static final String DBO = "KIWI";
    private static final String APPLE_USER = "APPLE";
    private static final String PEAR_USER = "PEAR";
    private static final String PRICKLY_PEAR_USER = "PeAr";
    private static final String ORANGE_USER = "ORANGE";
    private static final String BANANA_USER = "BANANA";
    private static final String GRAPE_USER = "GRAPE";
    private static final String PINEAPPLE_USER = "PINEAPPLE";
    private static final String CAMEL_CASE_DBO = "kIwI";
    private static final String WALNUT_USER = "WALNUT";
    private static final String BUILTIN_USER = "PECAN";
    private static final String CREDENTIALS_DB = "credDB";
    private static final String SECOND_DB = "secondDB";
    private static final String THIRD_DB = "thirdDB";
    private static final String FOURTH_DB = "fourthDB";
    private static final String FIFTH_DB = "fifthDB";
    private static final String SIXTH_DB = "sixthDB";
    private static final String SEVENTH_DB = "seventhDB";
    private static final String EIGHTH_DB = "eighthDB";
    private static final String NINTH_DB = "ninthDB";
    private static final String TENTH_DB = "tenthDB";
    private static final String ELEVENTH_DB = "eleventhDB";
    private static final String TWELTH_DB = "twelthDB";
    private static final String THIRTEENTH_DB = "thirteenthDB";
    private static final String FOURTEENTH_DB = "fourteenthDB";
    private static final String FIFTEENTH_DB = "fifteenthDB";
    private static final String NAST1_JAR_FILE = "nast1.jar";
    private static final String NAST2_JAR_FILE = "nast2.jar";
    private static final String[] SUPPORT_FILES_SOURCE = new String[]{"functionTests/tests/lang/nast1.jar", "functionTests/tests/lang/nast1.jar"};
    private static final String[] SUPPORT_FILES_TARGET = new String[]{"nast1.jar", "nast2.jar"};
    private static final String PROVIDER_PROPERTY = "derby.authentication.provider";
    private static final String REQUIRE_AUTHENTICATION_PROPERTY = "derby.connection.requireAuthentication";
    private static final String SQL_AUTHORIZATION_PROPERTY = "derby.database.sqlAuthorization";
    private static final String UPGRADE_TO_BETA_PROPERTY = "derby.database.allowPreReleaseUpgrade";
    private static final String CREDENTIALS_DB_DOES_NOT_EXIST = "4251I";
    private static final String BAD_NETWORK_AUTHENTICATION = "08001";
    private static final String INVALID_AUTHENTICATION = "08004";
    private static final String DBO_ONLY_OPERATION = "4251D";
    private static final String INVALID_PROVIDER_CHANGE = "XCY05";
    private static final String CANT_DROP_DBO = "4251F";
    private static final String NO_COLUMN_PERMISSION = "42502";
    private static final String NO_EXECUTE_PERMISSION = "42504";
    private static final String PASSWORD_EXPIRING = "01J15";
    private static final String DBO_PASSWORD_EXPIRING = "01J16";
    private static final String BAD_PASSWORD_PROPERTY = "4251J";
    private static final String BAD_PROPERTY_CHANGE = "XCY02";
    private static final String SQL_AUTHORIZATION_NOT_ON = "42Z60";
    private static final String CANT_BOOT_DATABASE = "XJ040";
    private static final String MISSING_USER = "XK001";
    private static final String BAD_USER_AUTHENTICATOR_CLASS = "XBM0M";
    private static final String USER_ALREADY_EXISTS = "X0Y68";
    private static final String WEAK_AUTHENTICATION = "4251G";
    private static final String HASHING_FORMAT_10_9 = "3b62";
    private static final int HEX_CHARS_PER_BYTE = 2;
    private final int _credentialsDBLocation;
    private final boolean _nativeAuthentication;
    private final boolean _localAuthentication;
    private final boolean _turnOffAuthenticationAndAuthorization;
    private String _credentialsDBPhysicalName;
    private DatabaseChangeSetup _fourthDBSetup;
    private DatabaseChangeSetup _fifthDBSetup;
    private DatabaseChangeSetup _sixthDBSetup;
    private DatabaseChangeSetup _seventhDBSetup;
    private DatabaseChangeSetup _eighthDBSetup;
    private DatabaseChangeSetup _ninthDBSetup;
    private DatabaseChangeSetup _fifteenthDBSetup;
    private String _derbySystemHome;
    private String _fullBackupDir;

    public NativeAuthenticationServiceTest(int n, boolean bl, boolean bl2, boolean bl3) {
        super("testAll");
        this._credentialsDBLocation = n;
        this._nativeAuthentication = bl;
        this._localAuthentication = bl2;
        this._turnOffAuthenticationAndAuthorization = bl3;
    }

    public void setUp() throws Exception {
        super.setUp();
        this._derbySystemHome = NativeAuthenticationServiceTest.getSystemProperty("derby.system.home");
        this._fullBackupDir = this._derbySystemHome + "/backupDir";
    }

    private Properties systemProperties(String string) throws Exception {
        Object object;
        Properties properties = new Properties();
        switch (this._credentialsDBLocation) {
            case 1: 
            case 4: {
                this._credentialsDBPhysicalName = NativeAuthenticationServiceTest.jarDBName(this._credentialsDBLocation);
                break;
            }
            case 2: {
                this._credentialsDBPhysicalName = NativeAuthenticationServiceTest.classpathDBName();
                break;
            }
            case 0: 
            case 3: {
                this._credentialsDBPhysicalName = string;
                break;
            }
            default: {
                throw new Exception("Unknown location of credentials db: " + this._credentialsDBLocation);
            }
        }
        if (!this._nativeAuthentication) {
            object = "NONE";
        } else {
            object = "NATIVE:" + this._credentialsDBPhysicalName;
            if (this._localAuthentication) {
                object = (String)object + ":LOCAL";
            }
        }
        properties.put(UPGRADE_TO_BETA_PROPERTY, "true");
        properties.put(PROVIDER_PROPERTY, object);
        if (this._turnOffAuthenticationAndAuthorization) {
            properties.put(REQUIRE_AUTHENTICATION_PROPERTY, "false");
            properties.put(SQL_AUTHORIZATION_PROPERTY, "false");
        }
        return properties;
    }

    private boolean credentialsViaSubprotocol() {
        switch (this._credentialsDBLocation) {
            case 1: 
            case 2: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    private String nameOfTest() {
        String string = "";
        switch (this._credentialsDBLocation) {
            case 1: {
                string = "JAR, ";
                break;
            }
            case 4: {
                string = "JAR_ENCRYPTED, ";
                break;
            }
            case 2: {
                string = "CLASSPATH, ";
                break;
            }
            case 0: 
            case 3: {
                string = "FILE, ";
                break;
            }
            default: {
                string = "UNKNOWN, ";
            }
        }
        String string2 = this._nativeAuthentication ? "NATIVE authentication on, " : "Authentication off, ";
        String string3 = this._localAuthentication ? "LOCAL authentication ON, " : "LOCAL authentication OFF, ";
        String string4 = this._turnOffAuthenticationAndAuthorization ? "Authentication/Authorization turned OFF, " : "Authentication/Authorization DEFAULT, ";
        String string5 = this.isEmbedded() ? "Embedded" : "Client/Server";
        return "[ " + string + string2 + string3 + string4 + string5 + " ]";
    }

    public boolean isEmbedded() {
        return this.getTestConfiguration().getJDBCClient().isEmbedded();
    }

    public static Test suite() throws Exception {
        BaseTestSuite baseTestSuite = new BaseTestSuite();
        if (NativeAuthenticationServiceTest.enableSubprotocolTests()) {
            baseTestSuite.addTest(new NativeAuthenticationServiceTest(4, true, true, false).decorate(false));
        }
        baseTestSuite.addTest(NativeAuthenticationServiceTest.allConfigurations(false));
        if (!JDBC.vmSupportsJSR169()) {
            baseTestSuite.addTest(NativeAuthenticationServiceTest.allConfigurations(true));
        }
        return new TimeZoneTestSetup((Test)baseTestSuite, "GMT");
    }

    private static boolean enableSubprotocolTests() {
        return ClasspathSetup.supportsClose() || !NativeAuthenticationServiceTest.isWindowsPlatform();
    }

    private static Test allConfigurations(boolean bl) throws Exception {
        BaseTestSuite baseTestSuite = new BaseTestSuite();
        baseTestSuite.addTest(new NativeAuthenticationServiceTest(3, false, false, false).decorate(bl));
        baseTestSuite.addTest(new NativeAuthenticationServiceTest(0, true, true, true).decorate(bl));
        baseTestSuite.addTest(new NativeAuthenticationServiceTest(0, true, true, false).decorate(bl));
        baseTestSuite.addTest(new NativeAuthenticationServiceTest(0, true, false, true).decorate(bl));
        baseTestSuite.addTest(new NativeAuthenticationServiceTest(0, true, false, false).decorate(bl));
        if (NativeAuthenticationServiceTest.enableSubprotocolTests()) {
            baseTestSuite.addTest(new NativeAuthenticationServiceTest(1, true, false, false).decorate(bl));
            baseTestSuite.addTest(new NativeAuthenticationServiceTest(1, true, true, false).decorate(bl));
            baseTestSuite.addTest(new NativeAuthenticationServiceTest(2, true, false, false).decorate(bl));
            baseTestSuite.addTest(new NativeAuthenticationServiceTest(2, true, true, false).decorate(bl));
        }
        return baseTestSuite;
    }

    private Test decorate(boolean bl) throws Exception {
        String string = TestConfiguration.generateUniqueDatabaseName();
        Object object = this;
        if (bl) {
            object = TestConfiguration.clientServerDecorator((Test)object);
        }
        Properties properties = null;
        try {
            properties = this.systemProperties(string);
        }
        catch (Exception exception) {
            NativeAuthenticationServiceTest.printStackTrace(exception);
        }
        NativeAuthenticationServiceTest.println(this.nameOfTest());
        NativeAuthenticationServiceTest.println("    NativeAuthenticationServiceTest.decorate() systemProperties = " + String.valueOf(properties));
        object = new SystemPropertyTestSetup((Test)object, properties, true);
        if (NativeAuthenticationServiceTest.enableSubprotocolTests()) {
            URL uRL = SupportFilesSetup.getReadOnlyURL(NAST2_JAR_FILE);
            object = new ClasspathSetup((Test)object, uRL);
            object = new SupportFilesSetup((Test)object, SUPPORT_FILES_SOURCE, null, SUPPORT_FILES_TARGET, null);
        }
        object = TestConfiguration.additionalDatabaseDecoratorNoShutdown((Test)object, CREDENTIALS_DB, string);
        object = TestConfiguration.additionalDatabaseDecoratorNoShutdown((Test)object, SECOND_DB);
        object = TestConfiguration.additionalDatabaseDecoratorNoShutdown((Test)object, THIRD_DB);
        this._fourthDBSetup = TestConfiguration.additionalDatabaseDecoratorNoShutdown((Test)object, FOURTH_DB, true);
        object = this._fourthDBSetup;
        this._fifthDBSetup = TestConfiguration.additionalDatabaseDecoratorNoShutdown((Test)object, FIFTH_DB, true);
        object = this._fifthDBSetup;
        this._sixthDBSetup = TestConfiguration.additionalDatabaseDecoratorNoShutdown((Test)object, SIXTH_DB, true);
        object = this._sixthDBSetup;
        this._seventhDBSetup = TestConfiguration.additionalDatabaseDecoratorNoShutdown((Test)object, SEVENTH_DB, true);
        object = this._seventhDBSetup;
        this._eighthDBSetup = TestConfiguration.additionalDatabaseDecoratorNoShutdown((Test)object, EIGHTH_DB, true);
        object = this._eighthDBSetup;
        this._ninthDBSetup = TestConfiguration.additionalDatabaseDecoratorNoShutdown((Test)object, NINTH_DB, true);
        object = this._ninthDBSetup;
        object = TestConfiguration.additionalDatabaseDecoratorNoShutdown((Test)object, TENTH_DB);
        object = TestConfiguration.additionalDatabaseDecoratorNoShutdown((Test)object, ELEVENTH_DB);
        object = TestConfiguration.additionalDatabaseDecoratorNoShutdown((Test)object, TWELTH_DB);
        object = TestConfiguration.additionalDatabaseDecoratorNoShutdown((Test)object, THIRTEENTH_DB);
        object = TestConfiguration.additionalDatabaseDecoratorNoShutdown((Test)object, FOURTEENTH_DB);
        this._fifteenthDBSetup = TestConfiguration.additionalDatabaseDecoratorNoShutdown((Test)object, FIFTEENTH_DB, true);
        object = this._fifteenthDBSetup;
        object = TestConfiguration.changeUserDecorator((Test)object, DBO, NativeAuthenticationServiceTest.getPassword(DBO));
        return object;
    }

    public void testAll() throws Exception {
        NativeAuthenticationServiceTest.println(this.nameOfTest());
        NativeAuthenticationServiceTest.println("Credentials DB physical name = " + this._credentialsDBPhysicalName);
        NativeAuthenticationServiceTest.println("derby.authentication.provider = " + NativeAuthenticationServiceTest.getSystemProperty(PROVIDER_PROPERTY));
        if (this._credentialsDBLocation == 4) {
            this.vetEncryptedCredentialsDB();
        } else if (this.credentialsViaSubprotocol()) {
            this.vetCredentialsViaSubprotocol();
        } else {
            this.vetCoreBehavior();
            this.vetCasing();
            this.vetSystemWideOperations();
            if (!this._nativeAuthentication) {
                this.vetProviderChanges();
            }
            if (this._localAuthentication && this.isEmbedded()) {
                this.vetPasswordLifetime();
            }
        }
    }

    private void vetEncryptedCredentialsDB() throws Exception {
        Connection connection = this.getConnection(true, true, THIRTEENTH_DB, DBO, CANT_BOOT_DATABASE);
        Properties properties = new Properties();
        properties.setProperty("bootPassword", "clo760uds2caPe");
        Connection connection2 = this.openConnection(NativeAuthenticationServiceTest.jarDBName(this._credentialsDBLocation), DBO, false, properties);
        Connection connection3 = this.getConnection(false, true, THIRTEENTH_DB, GRAPE_USER, null);
        this.getConnection(true, true, FOURTEENTH_DB, WALNUT_USER, INVALID_AUTHENTICATION);
    }

    private void vetCredentialsViaSubprotocol() throws Exception {
        String[][] stringArray;
        Connection connection = this.openConnection(TENTH_DB, GRAPE_USER, true, null);
        if (this._localAuthentication) {
            String[][] stringArrayArray = new String[1][];
            stringArray = stringArrayArray;
            stringArrayArray[0] = new String[]{GRAPE_USER};
        } else {
            stringArray = new String[][]{};
        }
        String[][] stringArray2 = stringArray;
        this.assertResults(connection, "select username from sys.sysusers order by username", stringArray2, false);
        Connection connection2 = this.getConnection(true, true, ELEVENTH_DB, WALNUT_USER, INVALID_AUTHENTICATION);
    }

    private void vetCoreBehavior() throws Exception {
        String[][] stringArrayArray;
        String[][] stringArrayArray2;
        String[][] stringArray;
        Connection connection = this.getConnection(this._nativeAuthentication, true, SECOND_DB, APPLE_USER, CREDENTIALS_DB_DOES_NOT_EXIST);
        if (this._nativeAuthentication) {
            this.vetEmptyCredentials();
        }
        Connection connection2 = this.openConnection(CREDENTIALS_DB, DBO, true, null);
        this.getConnection(this._nativeAuthentication, true, CREDENTIALS_DB, DBO, null, INVALID_AUTHENTICATION);
        if (!this._nativeAuthentication) {
            stringArray = this.openConnection(CREDENTIALS_DB, PINEAPPLE_USER, true, null);
            this.addUser((Connection)stringArray, DBO, DBO_ONLY_OPERATION);
            this.addUser(connection2, DBO);
        }
        this.addUser(connection2, APPLE_USER);
        this.addUser(connection2, BANANA_USER);
        stringArray = new String[][]{{APPLE_USER}, {BANANA_USER}, {DBO}};
        this.assertResults(connection2, "select username from sys.sysusers order by username", stringArray, false);
        String[][] stringArray2 = new String[][]{{"NATIVE::LOCAL"}};
        this.assertResults(connection2, "values ( syscs_util.syscs_get_database_property( 'derby.authentication.provider' ) )", stringArray2, false);
        String[][] stringArray3 = new String[][]{{null}};
        this.assertResults(connection2, "values ( syscs_util.syscs_get_database_property( 'derby.database.sqlAuthorization' ) )", stringArray3, false);
        this.vetSQLAuthorizationOn();
        String[][] stringArray4 = new String[][]{{DBO}};
        this.assertResults(connection2, "select authorizationID from sys.sysschemas where schemaName = 'SYS'", stringArray4, false);
        if (this._localAuthentication) {
            this.passwordHashingTests(connection2);
        }
        Connection connection3 = this.getConnection(this._nativeAuthentication, true, THIRD_DB, WALNUT_USER, INVALID_AUTHENTICATION);
        if (connection == null) {
            connection = this.getConnection(false, true, SECOND_DB, APPLE_USER, null);
        }
        this.assertResults(connection, "select authorizationID from sys.sysschemas where schemaName = 'SYS'", new String[][]{{APPLE_USER}}, false);
        this.assertResults(connection, "values ( syscs_util.syscs_get_database_property( 'derby.database.sqlAuthorization' ) )", stringArray3, false);
        if (this._localAuthentication) {
            String[][] stringArrayArray3 = new String[1][];
            stringArrayArray2 = stringArrayArray3;
            stringArrayArray3[0] = new String[]{"NATIVE::LOCAL"};
        } else {
            String[][] stringArrayArray4 = new String[1][];
            stringArrayArray2 = stringArrayArray4;
            stringArrayArray4[0] = new String[]{null};
        }
        stringArray2 = stringArrayArray2;
        this.assertResults(connection, "values ( syscs_util.syscs_get_database_property( 'derby.authentication.provider' ) )", stringArray2, false);
        if (this._localAuthentication) {
            String[][] stringArrayArray5 = new String[1][];
            stringArrayArray = stringArrayArray5;
            stringArrayArray5[0] = new String[]{APPLE_USER};
        } else {
            stringArrayArray = new String[][]{};
        }
        stringArray = stringArrayArray;
        this.assertResults(connection, "select username from sys.sysusers order by username", stringArray, false);
        Connection connection4 = this.openConnection(SEVENTH_DB, DBO, true, null);
        if (this._localAuthentication) {
            this.addUser(connection4, APPLE_USER);
        }
        this.goodStatement(connection4, "create table t1( a int )");
        this.goodStatement(connection4, "insert into t1( a ) values ( 10 )");
        this.setDatabaseProperty(this._nativeAuthentication, connection4, SQL_AUTHORIZATION_PROPERTY, "false", BAD_PROPERTY_CHANGE);
        this.goodStatement(connection4, "call syscs_util.syscs_set_database_property( 'derby.connection.requireAuthentication', 'false' )");
        this.goodStatement(connection4, "call syscs_util.syscs_set_database_property( 'derby.database.propertiesOnly', 'true' )");
        this._seventhDBSetup.getTestConfiguration().shutdownDatabase();
        Connection connection5 = this.openConnection(SEVENTH_DB, APPLE_USER, true, null);
        this.vetStatement(this._localAuthentication, connection5, "select * from KIWI.t1", NO_COLUMN_PERMISSION);
        Connection connection6 = this.getConnection(this._localAuthentication, true, SEVENTH_DB, WALNUT_USER, INVALID_AUTHENTICATION);
        Connection connection7 = this.openConnection(EIGHTH_DB, DBO, true, null);
        this.setDatabaseProperty(this._localAuthentication, connection7, PROVIDER_PROPERTY, "BUILTIN", INVALID_PROVIDER_CHANGE);
        this.setDatabaseProperty(false, connection7, REQUIRE_AUTHENTICATION_PROPERTY, "true", null);
        this.setDatabaseProperty(false, connection7, "derby.database.propertiesOnly", "true", null);
        this.addBuiltinUser(connection7, DBO);
        this.addBuiltinUser(connection7, BUILTIN_USER);
        this._eighthDBSetup.getTestConfiguration().shutdownDatabase();
        Connection connection8 = this.getConnection(this._localAuthentication, true, EIGHTH_DB, BUILTIN_USER, INVALID_AUTHENTICATION);
        if (NativeAuthenticationServiceTest.enableSubprotocolTests()) {
            this.vetProtocol(NativeAuthenticationServiceTest.jarDBName(this._credentialsDBLocation));
            this.vetProtocol(NativeAuthenticationServiceTest.classpathDBName());
        }
        Connection connection9 = this.openConnection(TWELTH_DB, DBO, true, null);
        if (this._localAuthentication) {
            this.addUser(connection9, APPLE_USER);
        }
        Connection connection10 = this.openConnection(TWELTH_DB, APPLE_USER, true, null);
        if (this._localAuthentication) {
            this.vetStatement(this._nativeAuthentication, connection10, "call syscs_util.syscs_create_user( 'JULIUS', 'juliuspassword' )", NO_EXECUTE_PERMISSION);
            this.vetStatement(this._nativeAuthentication, connection10, "call syscs_util.syscs_reset_password( 'JULIUS', 'foopassword' )", NO_EXECUTE_PERMISSION);
            this.vetStatement(this._nativeAuthentication, connection10, "call syscs_util.syscs_drop_user( 'JULIUS' )", NO_EXECUTE_PERMISSION);
        }
        this.vetStatement(!this._localAuthentication, connection10, "call syscs_util.syscs_modify_password( 'foo' )", MISSING_USER);
        this.vetStatement(!this._nativeAuthentication, connection9, "grant execute on procedure syscs_util.syscs_create_user to APPLE", SQL_AUTHORIZATION_NOT_ON);
        this.vetStatement(!this._nativeAuthentication, connection9, "grant execute on procedure syscs_util.syscs_reset_password to APPLE", SQL_AUTHORIZATION_NOT_ON);
        this.vetStatement(!this._nativeAuthentication, connection9, "grant execute on procedure syscs_util.syscs_drop_user to APPLE", SQL_AUTHORIZATION_NOT_ON);
        if (this._localAuthentication) {
            this.goodStatement(connection10, "call syscs_util.syscs_create_user( 'HORACE', 'horacepassword' )");
            this.goodStatement(connection10, "call syscs_util.syscs_reset_password( 'HORACE', 'foopassword' )");
            this.goodStatement(connection10, "call syscs_util.syscs_drop_user( 'HORACE' )");
        }
        this.vetStatement(!this._nativeAuthentication, connection9, "revoke execute on procedure syscs_util.syscs_create_user from APPLE restrict", SQL_AUTHORIZATION_NOT_ON);
        this.vetStatement(!this._nativeAuthentication, connection9, "revoke execute on procedure syscs_util.syscs_reset_password from APPLE restrict", SQL_AUTHORIZATION_NOT_ON);
        this.vetStatement(!this._nativeAuthentication, connection9, "revoke execute on procedure syscs_util.syscs_drop_user from APPLE restrict", SQL_AUTHORIZATION_NOT_ON);
        if (this._localAuthentication) {
            this.vetStatement(this._nativeAuthentication, connection10, "call syscs_util.syscs_create_user( 'CORNELIA', 'corneliapassword' )", NO_EXECUTE_PERMISSION);
            this.vetStatement(this._nativeAuthentication, connection10, "call syscs_util.syscs_reset_password( 'CORNELIA', 'foopassword' )", NO_EXECUTE_PERMISSION);
            this.vetStatement(this._nativeAuthentication, connection10, "call syscs_util.syscs_drop_user( 'CORNELIA' )", NO_EXECUTE_PERMISSION);
        }
    }

    private static String jarDBName(int n) throws Exception {
        String string = n == 4 ? "nastEncrypted" : "nast";
        return "jar:(" + SupportFilesSetup.getReadOnlyFileName(NAST1_JAR_FILE) + ")" + string;
    }

    private static String classpathDBName() {
        return "classpath:nast";
    }

    private void vetEmptyCredentials() throws Exception {
        this.vetEmptyCredentials(null, null);
        this.vetEmptyCredentials("", null);
        this.vetEmptyCredentials(null, "");
        this.vetEmptyCredentials("", "");
        this.vetEmptyCredentials("foo", null);
        this.vetEmptyCredentials("foo", "");
        if (this.isEmbedded()) {
            this.vetEmptyCredentials(null, "bar");
        }
        this.vetEmptyCredentials("", "bar");
    }

    private void vetEmptyCredentials(String string, String string2) throws Exception {
        String[] stringArray = new String[]{INVALID_AUTHENTICATION, BAD_NETWORK_AUTHENTICATION};
        this.getConnection(true, true, CREDENTIALS_DB, string, string2, stringArray);
    }

    private void addBuiltinUser(Connection connection, String string) throws Exception {
        String string2 = "derby.user." + string;
        String string3 = NativeAuthenticationServiceTest.getPassword(string);
        this.setDatabaseProperty(false, connection, string2, string3, null);
    }

    private void vetProtocol(String string) throws Exception {
        Connection connection = this.getConnection(false, false, string, GRAPE_USER, null);
        this.vetStatement(true, connection, "select * from KIWI.t", NO_COLUMN_PERMISSION);
        this.getConnection(true, false, string, WALNUT_USER, INVALID_AUTHENTICATION);
    }

    private void vetCasing() throws Exception {
        if (!this._nativeAuthentication) {
            return;
        }
        if (this._localAuthentication) {
            return;
        }
        String string = "prickly_pear_password";
        Connection connection = this.openConnection(CREDENTIALS_DB, DBO, true, null);
        this.addUser(connection, CAMEL_CASE_DBO, USER_ALREADY_EXISTS);
        this.addUser(connection, PEAR_USER, null);
        NativeAuthenticationServiceTest.assertFalse((boolean)PEAR_USER.equals(PRICKLY_PEAR_USER));
        NativeAuthenticationServiceTest.assertTrue((boolean)PEAR_USER.toUpperCase().equals(PRICKLY_PEAR_USER.toUpperCase()));
        this.goodStatement(connection, "call syscs_util.syscs_create_user( '\"PeAr\"', '" + string + "' )");
        String[][] stringArray = new String[][]{{PEAR_USER}, {PRICKLY_PEAR_USER}};
        this.assertResults(connection, "select username from sys.sysusers where username like 'P%' order by username", stringArray, false);
        Connection connection2 = this.openConnection(CREDENTIALS_DB, PEAR_USER, true, null);
        this.assertResults(connection2, "values current schema", new String[][]{{PEAR_USER.toUpperCase()}}, false);
        Connection connection3 = this.openConnection(CREDENTIALS_DB, this.doubleQuote(PRICKLY_PEAR_USER), string, true, null);
        this.assertResults(connection3, "values current schema", new String[][]{{PRICKLY_PEAR_USER}}, false);
        String string2 = "password_rev2";
        this.goodStatement(connection3, "call syscs_util.syscs_modify_password( '" + string2 + "' )");
        this.getConnection(true, true, CREDENTIALS_DB, this.doubleQuote(PRICKLY_PEAR_USER), string, INVALID_AUTHENTICATION);
        connection3 = this.openConnection(CREDENTIALS_DB, this.doubleQuote(PRICKLY_PEAR_USER), string2, true, null);
        String string3 = "password_rev3";
        this.goodStatement(connection, "call syscs_util.syscs_reset_password( '" + this.doubleQuote(PRICKLY_PEAR_USER) + "', '" + string3 + "' )");
        this.getConnection(true, true, CREDENTIALS_DB, this.doubleQuote(PRICKLY_PEAR_USER), string2, INVALID_AUTHENTICATION);
        connection3 = this.openConnection(CREDENTIALS_DB, this.doubleQuote(PRICKLY_PEAR_USER), string3, true, null);
        int n = this.countUsers(connection);
        this.goodStatement(connection, "call syscs_util.syscs_drop_user( '" + this.doubleQuote(PRICKLY_PEAR_USER) + "' )");
        NativeAuthenticationServiceTest.assertEquals((int)(n - 1), (int)this.countUsers(connection));
        this.getConnection(true, true, CREDENTIALS_DB, this.doubleQuote(PRICKLY_PEAR_USER), string3, INVALID_AUTHENTICATION);
    }

    private String doubleQuote(String string) {
        return "\"" + string + "\"";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countUsers(Connection connection) throws Exception {
        PreparedStatement preparedStatement = this.chattyPrepare(connection, "select count(*) from sys.sysusers");
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        try {
            int n = resultSet.getInt(1);
            return n;
        }
        finally {
            resultSet.close();
            preparedStatement.close();
        }
    }

    private void vetSystemWideOperations() throws Exception {
        Connection connection = this.openConnection(SIXTH_DB, DBO, true, null);
        if (this._localAuthentication) {
            this.addUser(connection, BANANA_USER);
        }
        this.goodStatement(connection, "create table t( a int )");
        this.goodStatement(connection, "insert into t( a ) values ( 1000 )");
        if (this._nativeAuthentication) {
            this.goodStatement(connection, "grant select on table t to public");
            this.goodStatement(connection, "grant insert on table t to public");
        }
        this.goodStatement(connection, "call syscs_util.syscs_backup_database( '" + this._fullBackupDir + "' )");
        this.goodStatement(connection, "delete from t");
        this.shutdownAndRestoreDB(true, BANANA_USER, null);
        this.shutdownAndRestoreDB(!this._localAuthentication, APPLE_USER, INVALID_AUTHENTICATION);
        NativeAuthenticationServiceTest.assertDirectoryDeleted(new File(this._fullBackupDir));
    }

    private void shutdownAndRestoreDB(boolean bl, String string, String string2) throws Exception {
        this._sixthDBSetup.getTestConfiguration().shutdownDatabase();
        String string3 = this._sixthDBSetup.physicalDatabaseName();
        int n = string3.lastIndexOf("/");
        if (n >= 0) {
            string3 = string3.substring(n + 1);
        }
        DataSource dataSource = JDBCDataSource.getDataSourceLogical(SIXTH_DB);
        String string4 = this._fullBackupDir + "/" + string3;
        JDBCDataSource.setBeanProperty(dataSource, "connectionAttributes", "restoreFrom=" + string4);
        Connection connection = null;
        try {
            connection = dataSource.getConnection(string, NativeAuthenticationServiceTest.getPassword(string));
            if (!bl) {
                NativeAuthenticationServiceTest.fail((String)this.tagError("Database restoration should have failed."));
            }
        }
        catch (SQLException sQLException) {
            if (bl) {
                NativeAuthenticationServiceTest.fail((String)this.tagError("Database restoration unexpectedly failed."));
            }
            NativeAuthenticationServiceTest.assertSQLState(string2, sQLException);
        }
        if (connection != null) {
            this.assertResults(connection, "select a from KIWI.t", new String[][]{{"1000"}}, false);
            this.goodStatement(connection, "insert into KIWI.t( a ) values ( 2000 )");
        }
    }

    private void vetProviderChanges() throws Exception {
        String string = ORANGE_USER;
        Connection connection = this.openConnection(FOURTH_DB, string, true, null);
        this.goodStatement(connection, "call syscs_util.syscs_set_database_property( 'derby.authentication.provider', 'com.acme.AcmeAuthenticator' )");
        this.expectExecutionError(connection, INVALID_PROVIDER_CHANGE, "call syscs_util.syscs_set_database_property( 'derby.authentication.provider', 'NATIVE::LOCAL' )");
        this.expectExecutionError(connection, INVALID_PROVIDER_CHANGE, "call syscs_util.syscs_set_database_property( 'derby.authentication.provider', 'NATIVE:db:LOCAL' )");
        this.expectExecutionError(connection, INVALID_PROVIDER_CHANGE, "call syscs_util.syscs_set_database_property( 'derby.authentication.provider', 'NATIVE:LOCAL' )");
        this.addUser(connection, string);
        this.addUser(connection, PEAR_USER);
        this.expectExecutionError(connection, CANT_DROP_DBO, "call syscs_util.syscs_drop_user( '" + string + "' )");
        String[][] stringArray = new String[][]{{string}, {PEAR_USER}};
        this.assertResults(connection, "select username from sys.sysusers order by username", stringArray, false);
        this.expectExecutionError(connection, INVALID_PROVIDER_CHANGE, "call syscs_util.syscs_set_database_property( 'derby.authentication.provider', 'NATIVE::LOCAL' )");
        this.expectExecutionError(connection, INVALID_PROVIDER_CHANGE, "call syscs_util.syscs_set_database_property( 'derby.authentication.provider', null )");
        this.expectExecutionError(connection, INVALID_PROVIDER_CHANGE, "call syscs_util.syscs_set_database_property( 'derby.authentication.provider', 'com.acme.AcmeAuthenticator' )");
        String[][] stringArray2 = new String[][]{{"NATIVE::LOCAL"}};
        this.assertResults(connection, "values ( syscs_util.syscs_get_database_property( 'derby.authentication.provider' ) )", stringArray2, false);
        this.goodStatement(connection, "create table t( a int )");
        this._fourthDBSetup.getTestConfiguration().shutdownDatabase();
        Connection connection2 = this.getConnection(true, true, FOURTH_DB, APPLE_USER, INVALID_AUTHENTICATION);
        Connection connection3 = this.openConnection(FOURTH_DB, PEAR_USER, true, null);
        this.expectExecutionError(connection3, NO_COLUMN_PERMISSION, "select * from " + string + ".t");
        this.expectCompilationError(connection3, DBO_ONLY_OPERATION, "select username from sys.sysusers");
        if (this.isEmbedded()) {
            Connection connection4 = this.openConnection(FIFTEENTH_DB, string, true, null);
            this.goodStatement(connection4, "call syscs_util.syscs_set_database_property( 'derby.connection.requireAuthentication', 'true' )");
            this.goodStatement(connection4, "call syscs_util.syscs_set_database_property( 'derby.authentication.provider', 'NATIVE' )");
            this._fifteenthDBSetup.getTestConfiguration().shutdownDatabase();
            this.getConnection(true, true, FIFTEENTH_DB, DBO, BAD_USER_AUTHENTICATOR_CLASS);
        }
    }

    private void vetPasswordLifetime() throws Exception {
        Connection connection = this.openConnection(FIFTH_DB, DBO, true, null);
        this.addUser(connection, APPLE_USER);
        Connection connection2 = this.passwordExpiring(false, FIFTH_DB, APPLE_USER);
        this.goodStatement(connection, "call syscs_util.syscs_set_database_property( 'derby.authentication.native.passwordLifetimeMillis', '86400000' )");
        this.goodStatement(connection, "call syscs_util.syscs_set_database_property( 'derby.authentication.native.passwordLifetimeThreshold', '2.0' )");
        this._fifthDBSetup.getTestConfiguration().shutdownDatabase();
        connection = this.passwordExpiring(true, FIFTH_DB, DBO);
        connection2 = this.passwordExpiring(true, FIFTH_DB, APPLE_USER);
        this.goodStatement(connection, "call syscs_util.syscs_set_database_property( 'derby.authentication.native.passwordLifetimeMillis', '1' )");
        this._fifthDBSetup.getTestConfiguration().shutdownDatabase();
        connection = this.openConnection(FIFTH_DB, DBO, true, null);
        connection2 = this.getConnection(true, true, FIFTH_DB, APPLE_USER, INVALID_AUTHENTICATION);
        this.goodStatement(connection, "call syscs_util.syscs_set_database_property( 'derby.authentication.native.passwordLifetimeMillis', '0' )");
        this._fifthDBSetup.getTestConfiguration().shutdownDatabase();
        connection = this.passwordExpiring(false, FIFTH_DB, DBO);
        connection2 = this.passwordExpiring(false, FIFTH_DB, APPLE_USER);
        this.expectExecutionError(connection, BAD_PASSWORD_PROPERTY, "call syscs_util.syscs_set_database_property( 'derby.authentication.native.passwordLifetimeMillis', 'rabbit' )");
        this.expectExecutionError(connection, BAD_PASSWORD_PROPERTY, "call syscs_util.syscs_set_database_property( 'derby.authentication.native.passwordLifetimeThreshold', '-1' )");
    }

    private void passwordHashingTests(Connection connection) throws Exception {
        String string = this.getDatabaseProperty(connection, "derby.authentication.builtin.algorithm");
        if (string == null) {
            this.setDatabaseProperty(connection, "derby.authentication.builtin.algorithm", "SHA-1");
        }
        String string2 = this.getDatabaseProperty(connection, "derby.authentication.builtin.algorithm");
        this.goodStatement(connection, "call syscs_util.syscs_create_user( 'pht', 'phtpassword' )");
        this.vetHashingScheme(connection, "pht", HASHING_FORMAT_10_9, 16, 1000, string2);
        int n = 5;
        this.setDatabaseProperty(connection, "derby.authentication.builtin.saltLength", Integer.toString(n));
        this.goodStatement(connection, "call syscs_util.syscs_reset_password( 'pht', 'newsaltlength' )");
        this.vetHashingScheme(connection, "pht", HASHING_FORMAT_10_9, n, 1000, string2);
        int n2 = 10;
        this.setDatabaseProperty(connection, "derby.authentication.builtin.iterations", Integer.toString(n2));
        this.goodStatement(connection, "call syscs_util.syscs_reset_password( 'pht', 'newiterations' )");
        this.vetHashingScheme(connection, "pht", HASHING_FORMAT_10_9, n, n2, string2);
        String string3 = "SHA-1";
        this.setDatabaseProperty(connection, "derby.authentication.builtin.algorithm", string3);
        this.goodStatement(connection, "call syscs_util.syscs_reset_password( 'pht', 'newiterations' )");
        this.vetHashingScheme(connection, "pht", HASHING_FORMAT_10_9, n, n2, string3);
        this.setDatabaseProperty(connection, "derby.authentication.builtin.algorithm", null);
        this.expectExecutionError(connection, WEAK_AUTHENTICATION, "call syscs_util.syscs_reset_password( 'pht', 'badalgorithm' )");
        this.setDatabaseProperty(connection, "derby.authentication.builtin.saltLength", null);
        this.setDatabaseProperty(connection, "derby.authentication.builtin.iterations", null);
        this.setDatabaseProperty(connection, "derby.authentication.builtin.algorithm", string2);
        this.goodStatement(connection, "call syscs_util.syscs_drop_user( 'pht' )");
        if (string == null) {
            this.setDatabaseProperty(connection, "derby.authentication.builtin.algorithm", null);
        }
    }

    private void setDatabaseProperty(Connection connection, String string, String object) throws Exception {
        object = object == null ? "cast ( null as varchar( 32672 ) )" : "'" + (String)object + "'";
        String string2 = "call syscs_util.syscs_set_database_property( '" + string + "', " + (String)object + " )";
        this.goodStatement(connection, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDatabaseProperty(Connection connection, String string) throws Exception {
        PreparedStatement preparedStatement = this.chattyPrepare(connection, "values( syscs_util.syscs_get_database_property( '" + string + "' ) )");
        ResultSet resultSet = preparedStatement.executeQuery();
        try {
            resultSet.next();
            String string2 = resultSet.getString(1);
            return string2;
        }
        finally {
            resultSet.close();
            preparedStatement.close();
        }
    }

    private void vetHashingScheme(Connection connection, String string, String string2, int n, int n2, String string3) throws Exception {
        String string4 = this.getHashingScheme(connection, string);
        int n3 = string4.indexOf(":");
        int n4 = string4.indexOf(":", n3 + 1);
        int n5 = string4.indexOf(":", n4 + 1);
        String string5 = string4.substring(0, n3);
        String string6 = string4.substring(n3 + 1, n4);
        String string7 = string4.substring(n4 + 1, n5);
        String string8 = string4.substring(n5 + 1);
        int n6 = string6.length();
        int n7 = Integer.parseInt(string7);
        NativeAuthenticationServiceTest.assertEquals((String)string2, (String)string5);
        NativeAuthenticationServiceTest.assertEquals((int)(n * 2), (int)n6);
        NativeAuthenticationServiceTest.assertEquals((int)n2, (int)n7);
        NativeAuthenticationServiceTest.assertEquals((String)string3, (String)string8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getHashingScheme(Connection connection, String string) throws Exception {
        PreparedStatement preparedStatement = connection.prepareStatement("select userName, hashingScheme from sys.sysusers");
        ResultSet resultSet = preparedStatement.executeQuery();
        string = string.toUpperCase();
        try {
            while (resultSet.next()) {
                if (!string.equals(resultSet.getString(1))) continue;
                String string2 = resultSet.getString(2);
                return string2;
            }
        }
        finally {
            resultSet.close();
            preparedStatement.close();
        }
        NativeAuthenticationServiceTest.fail((String)("Could not find credentials for " + string));
        return null;
    }

    private void vetSQLAuthorizationOn() throws Exception {
        Connection connection = this.openConnection(CREDENTIALS_DB, APPLE_USER, true, null);
        String string = "select username from sys.sysusers";
        try {
            this.chattyPrepare(connection, string);
            if (this._nativeAuthentication) {
                NativeAuthenticationServiceTest.fail((String)"SQL Authorization not on!");
            }
        }
        catch (SQLException sQLException) {
            if (this._nativeAuthentication) {
                NativeAuthenticationServiceTest.assertSQLState(DBO_ONLY_OPERATION, sQLException);
            }
            NativeAuthenticationServiceTest.fail((String)("Caught unexpected SQLException: " + sQLException.getSQLState() + ": " + sQLException.getMessage()));
        }
    }

    private Connection getConnection(boolean bl, boolean bl2, String string, String string2, String string3) throws Exception {
        return this.getConnection(bl, bl2, string, string2, NativeAuthenticationServiceTest.getPassword(string2), string3);
    }

    private Connection getConnection(boolean bl, boolean bl2, String string, String string2, String string3, String string4) throws Exception {
        return this.getConnection(bl, bl2, string, string2, string3, new String[]{string4});
    }

    private Connection getConnection(boolean bl, boolean bl2, String string, String string2, String string3, String[] stringArray) throws Exception {
        Connection connection = null;
        this.reportConnectionAttempt(string, string2, string3, bl2);
        try {
            connection = this.openConnection(string, string2, string3, bl2, null);
            if (bl) {
                NativeAuthenticationServiceTest.fail((String)this.tagError("Connection to " + string + " should have failed."));
            }
        }
        catch (Throwable throwable) {
            if (bl && throwable instanceof SQLException) {
                SQLException sQLException = (SQLException)throwable;
                StringBuffer stringBuffer = new StringBuffer();
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string4 = stringArray[i];
                    stringBuffer.append(" " + string4);
                    if (!this.vetSQLState(sQLException, string4, arrayList)) continue;
                    return null;
                }
                NativeAuthenticationServiceTest.fail((String)this.tagError("SQLState(s) " + String.valueOf(arrayList) + " not in expected list: " + stringBuffer.toString()));
            }
            NativeAuthenticationServiceTest.printStackTrace(throwable);
            NativeAuthenticationServiceTest.fail((String)this.tagError("Connection to " + string + " unexpectedly failed."));
        }
        return connection;
    }

    private boolean vetSQLState(SQLException sQLException, String string, ArrayList<String> arrayList) throws Exception {
        if (sQLException == null) {
            return false;
        }
        String string2 = sQLException.getSQLState();
        arrayList.add(string2);
        if (string.equals(string2)) {
            return true;
        }
        Throwable throwable = sQLException.getCause();
        if (throwable instanceof SQLException && this.vetSQLState((SQLException)throwable, string, arrayList)) {
            return true;
        }
        return this.vetSQLState(sQLException.getNextException(), string, arrayList);
    }

    private Connection passwordExpiring(boolean bl, String string, String string2) throws Exception {
        Connection connection = null;
        this.reportConnectionAttempt(string, string2, NativeAuthenticationServiceTest.getPassword(string2), true);
        String string3 = DBO.equals(string2) ? DBO_PASSWORD_EXPIRING : PASSWORD_EXPIRING;
        connection = this.openConnection(string, string2, true, null);
        SQLWarning sQLWarning = connection.getWarnings();
        if (bl) {
            NativeAuthenticationServiceTest.assertNotNull((String)this.tagError("Should have seen a warning"), (Object)sQLWarning);
            NativeAuthenticationServiceTest.assertSQLState(string3, sQLWarning);
        } else {
            NativeAuthenticationServiceTest.assertNull((String)this.tagError("Should not have seen a warning"), (Object)sQLWarning);
        }
        return connection;
    }

    private void reportConnectionAttempt(String string, String string2, String string3, boolean bl) {
        String string4 = "User '" + string2 + "' with password '" + string3 + "' attempting to get connection to database " + string;
        if (bl) {
            string4 = string4 + " aka " + this.getTestConfiguration().getPhysicalDatabaseName(string);
        }
        NativeAuthenticationServiceTest.println(string4);
    }

    private void addUser(Connection connection, String string) throws Exception {
        this.addUser(connection, string, null);
    }

    private void addUser(Connection connection, String string, String string2) throws Exception {
        boolean bl = string2 != null;
        String string3 = NativeAuthenticationServiceTest.getPassword(string);
        String string4 = "call syscs_util.syscs_create_user( '" + string + "', '" + string3 + "' )";
        if (bl) {
            NativeAuthenticationServiceTest.println("Expecting " + string2 + " when executing '" + string4 + "'");
        }
        try {
            this.goodStatement(connection, string4);
            if (bl) {
                NativeAuthenticationServiceTest.fail((String)this.tagError("Should not have been allowed to create user " + string));
            }
        }
        catch (SQLException sQLException) {
            if (bl) {
                NativeAuthenticationServiceTest.assertSQLState(string2, sQLException);
            }
            NativeAuthenticationServiceTest.fail((String)this.tagError("Unexpectedly failed to create user " + string));
        }
    }

    private void setDatabaseProperty(boolean bl, Connection connection, String string, String object, String string2) throws Exception {
        object = object == null ? "cast ( null as varchar( 32672 ) )" : "'" + (String)object + "'";
        String string3 = "call syscs_util.syscs_set_database_property( '" + string + "', " + (String)object + " )";
        try {
            this.goodStatement(connection, string3);
            if (bl) {
                NativeAuthenticationServiceTest.fail((String)this.tagError("Property setting should have failed."));
            }
        }
        catch (SQLException sQLException) {
            if (bl) {
                NativeAuthenticationServiceTest.assertSQLState(string2, sQLException);
            }
            NativeAuthenticationServiceTest.fail((String)this.tagError("Property setting unexpectedly failed."));
        }
    }

    private void vetStatement(boolean bl, Connection connection, String string, String string2) throws Exception {
        try {
            this.goodStatement(connection, string);
            if (bl) {
                NativeAuthenticationServiceTest.fail((String)this.tagError("Statement should have failed."));
            }
        }
        catch (SQLException sQLException) {
            if (bl) {
                NativeAuthenticationServiceTest.assertSQLState(string2, sQLException);
            }
            String string3 = "Statement unexpectedly failed. SQLState = " + sQLException.getSQLState() + ": " + sQLException.getMessage();
            NativeAuthenticationServiceTest.fail((String)this.tagError(string3));
        }
    }

    private Connection openConnection(String string, String string2, boolean bl, Properties properties) throws SQLException {
        return this.openConnection(string, string2, NativeAuthenticationServiceTest.getPassword(string2), bl, properties);
    }

    private Connection openConnection(String string, String string2, String string3, boolean bl, Properties properties) throws SQLException {
        if (bl) {
            return this.getTestConfiguration().openConnection(string, string2, string3);
        }
        return this.getTestConfiguration().openPhysicalConnection(string, string2, string3, properties);
    }

    private static String getPassword(String string) {
        return string + "_password";
    }

    private String tagError(String string) {
        return this.nameOfTest() + ": " + string;
    }
}

