/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derby.catalog.SystemProcedures;
import org.apache.derby.shared.common.info.JVMInfo;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeChange;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.XML;

public class BasicSetup
extends UpgradeChange {
    final int TEST_COUNT = 0;
    final int FAILURES = 1;
    final String A_COL = "a";
    final String B_COL = "b";

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("Upgrade basic setup");
        baseTestSuite.addTest((Test)new BaseTestSuite(BasicSetup.class));
        if (XML.classpathMeetsXMLReqs()) {
            baseTestSuite.addTest((Test)new BasicSetup("xmlTestTriggerWithXMLOperators"));
        }
        return baseTestSuite;
    }

    public BasicSetup(String string) {
        super(string);
    }

    public void testTriggerBasic() throws SQLException {
        Statement statement = this.createStatement();
        switch (this.getPhase()) {
            case 0: {
                statement.executeUpdate("CREATE TABLE Trigger_t1 (c1 INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1), max_size INTEGER NOT NULL, CONSTRAINT c1_pk PRIMARY KEY (c1))");
                statement.executeUpdate("CREATE TABLE Trigger_t2 (c1 INTEGER DEFAULT 0 NOT NULL)");
                statement.executeUpdate("CREATE TRIGGER gls_blt_trg AFTER INSERT ON Trigger_t1 FOR EACH ROW MODE DB2SQL INSERT INTO Trigger_t2(c1) VALUES ( (select max(c1) from Trigger_t1))");
                statement.executeUpdate("INSERT INTO Trigger_t1(max_size) VALUES(20)");
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                statement.executeUpdate("INSERT INTO Trigger_t1(max_size) VALUES(20)");
            }
        }
        statement.close();
    }

    public void testOldVersion() throws SQLException {
        switch (this.getPhase()) {
            case 0: 
            case 2: {
                DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
                if (!JVMInfo.isModuleAware()) {
                    BasicSetup.assertEquals((String)"Old major (driver): ", (int)this.getOldMajor(), (int)databaseMetaData.getDriverMajorVersion());
                    BasicSetup.assertEquals((String)"Old minor (driver): ", (int)this.getOldMinor(), (int)databaseMetaData.getDriverMinorVersion());
                }
                BasicSetup.assertEquals((String)"Old major (database): ", (int)this.getOldMajor(), (int)databaseMetaData.getDatabaseMajorVersion());
                BasicSetup.assertEquals((String)"Old minor (database): ", (int)this.getOldMinor(), (int)databaseMetaData.getDatabaseMinorVersion());
            }
        }
    }

    public void testDML() throws SQLException {
        int n;
        int n2 = this.getPhase();
        Statement statement = this.createStatement();
        switch (n2) {
            case 0: {
                statement.executeUpdate("CREATE TABLE PHASE(id INT NOT NULL, ok INT)");
                statement.executeUpdate("CREATE TABLE TABLE1(id INT NOT NULL PRIMARY KEY, name varchar(200))");
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
        }
        statement.close();
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO PHASE(id) VALUES (?)");
        preparedStatement.setInt(1, n2);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        preparedStatement = this.prepareStatement("INSERT INTO TABLE1 VALUES (?, ?)");
        for (n = 1; n < 20; ++n) {
            preparedStatement.setInt(1, n + n2 * 100);
            preparedStatement.setString(2, "p" + n2 + "i" + n);
            preparedStatement.executeUpdate();
        }
        preparedStatement.close();
        preparedStatement = this.prepareStatement("UPDATE TABLE1 set name = name || 'U'  where id = ?");
        for (n = 1; n < 20; n += 3) {
            preparedStatement.setInt(1, n + n2 * 100);
            preparedStatement.executeUpdate();
        }
        preparedStatement.close();
        preparedStatement = this.prepareStatement("DELETE FROM TABLE1 where id = ?");
        for (n = 1; n < 20; n += 4) {
            preparedStatement.setInt(1, n + n2 * 100);
            preparedStatement.executeUpdate();
        }
        preparedStatement.close();
        this.commit();
    }

    public void testCreateTable() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = this.createStatement();
        try {
            statement.executeUpdate("DROP table t");
        }
        catch (SQLException sQLException) {
            BasicSetup.assertSQLState("42Y55", sQLException);
        }
        statement.executeUpdate("CREATE TABLE T (I INT)");
        TestConfiguration.getCurrent().shutdownDatabase();
        connection.close();
        statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT * from t");
        JDBC.assertEmpty(resultSet);
        resultSet.close();
    }

    public void testIndex() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = this.createStatement();
        try {
            statement.executeUpdate("DROP table ti");
        }
        catch (SQLException sQLException) {
            BasicSetup.assertSQLState("42Y55", sQLException);
        }
        statement.executeUpdate("CREATE TABLE TI (I INT primary key not null)");
        statement.executeUpdate("INSERT INTO  TI values(1)");
        statement.executeUpdate("INSERT INTO  TI values(2)");
        statement.executeUpdate("INSERT INTO  TI values(3)");
        TestConfiguration.getCurrent().shutdownDatabase();
        connection.close();
        statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT * from TI ORDER BY I");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1"}, {"2"}, {"3"}});
        resultSet.close();
    }

    public void noConnectionAfterHardUpgrade() {
        switch (this.getPhase()) {
            case 4: {
                try {
                    this.getConnection();
                    break;
                }
                catch (SQLException sQLException) {
                    SQLException sQLException2 = this.getLastSQLException(sQLException);
                    String string = sQLException2.getSQLState();
                    String string2 = sQLException2.getMessage();
                    String string3 = "XSLAN";
                    String string4 = "XSLAP";
                    String string5 = "XJ040";
                    if (string.equals(string4) || string.equals(string3) || string.equals(string5) || string2.contains(string4) || string2.contains(string3)) break;
                    BasicSetup.fail((String)("unexpected error after attempting a new connection: SQLstate = " + string + ", message = '" + sQLException2.getMessage() + "'"));
                }
            }
        }
    }

    public void dropAllTriggerPlans() throws Exception {
        Statement statement = this.createStatement();
        statement.execute("create procedure clear_sps_plans() language java parameter style java external name '" + ((Object)((Object)this)).getClass().getName() + ".clearSPSPlans'");
        statement.execute("call clear_sps_plans()");
        statement.execute("drop procedure clear_sps_plans");
    }

    public static void clearSPSPlans() throws SQLException {
        SystemProcedures.SYSCS_INVALIDATE_STORED_STATEMENTS();
    }

    public void testDropTableAfterUpgradeWithConstraint() throws SQLException {
        int n = this.getPhase();
        Statement statement = this.createStatement();
        switch (n) {
            case 0: {
                statement.executeUpdate("CREATE SCHEMA S");
                statement.executeUpdate("CREATE TABLE S.RS (R_TYPE_ID VARCHAR(64) NOT NULL)");
                statement.executeUpdate("ALTER TABLE S.RS ADD CONSTRAINT PK_RS PRIMARY KEY (R_TYPE_ID)");
                statement.executeUpdate("CREATE TABLE S.R_TYPE_ID (R_TYPE_ID VARCHAR(64) NOT NULL)");
                statement.executeUpdate("ALTER TABLE S.R_TYPE_ID ADD CONSTRAINT PK_R_TYPE_ID PRIMARY KEY (R_TYPE_ID)");
                statement.executeUpdate("ALTER TABLE S.RS ADD CONSTRAINT FK_RS_TYPEID FOREIGN KEY (R_TYPE_ID) REFERENCES S.R_TYPE_ID (R_TYPE_ID) ON DELETE CASCADE ON UPDATE NO ACTION");
                break;
            }
            case 1: {
                statement.executeUpdate("ALTER TABLE S.RS DROP CONSTRAINT FK_RS_TYPEID");
                statement.executeUpdate("ALTER TABLE S.R_TYPE_ID DROP CONSTRAINT PK_R_TYPE_ID");
                statement.executeUpdate("ALTER TABLE S.RS DROP CONSTRAINT PK_RS");
                statement.executeUpdate("DROP TABLE S.RS");
                statement.executeUpdate("DROP TABLE S.R_TYPE_ID");
                statement.executeUpdate("DROP SCHEMA S RESTRICT");
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public void testDERBY5121TriggerTest2() throws Exception {
        Statement statement = this.createStatement();
        boolean bl = this.oldAtLeast(10, 3);
        String string = "update media set name = 'Mon Liza', description = 'Something snarky.' where mediaID = 1";
        switch (this.getPhase()) {
            case 0: {
                statement.execute("create table folder ( folderType\tint\tnot null, folderID\tint\tnot null, folderParent int, folderName varchar(50) not null)");
                statement.execute("create table media ( mediaID int not null, name varchar(50)\tnot null, description clob not null, mediaType varchar(50), mediaContents\tblob, folderID int not null\tdefault 7)");
                statement.execute("create trigger mediaInsrtDupTrgr after INSERT on media referencing new as nr for each ROW " + (bl ? "" : "MODE DB2SQL ") + "values( nr.folderID, 7, nr.name)");
                statement.execute("create trigger mediaUpdtDupTrgr after UPDATE of folderID, name on media referencing new as nr for each ROW " + (bl ? "" : "MODE DB2SQL ") + "values( nr.folderID, 7, nr.name)");
                statement.executeUpdate("insert into folder(folderType, folderID, folderParent, folderName ) values ( 7, 7, null, 'media' )");
                statement.executeUpdate("insert into media(mediaID, name, description)values (1, 'Mona Lisa', 'A photo of the Mona Lisa')");
                if (this.oldIs(10, 7, 1, 1)) {
                    BasicSetup.assertStatementError("XCL12", statement, string);
                    break;
                }
                statement.executeUpdate(string);
                break;
            }
            case 1: {
                statement.executeUpdate(string);
                break;
            }
            case 2: {
                if (this.oldIs(10, 7, 1, 1)) {
                    BasicSetup.assertStatementError("S0022", statement, string);
                    break;
                }
                statement.executeUpdate(string);
                break;
            }
            case 3: {
                statement.executeUpdate(string);
                break;
            }
            case 4: {
                statement.executeUpdate(string);
                statement.executeUpdate("drop table media");
                statement.executeUpdate("drop table folder");
            }
        }
    }

    public void preapreFortDERBY5120() throws Exception {
        Statement statement = this.createStatement();
        boolean bl = this.oldAtLeast(10, 3);
        this.dropTable("ATDC_TAB1");
        this.dropTable("ATDC_BKUP1");
        statement.execute("create table ATDC_TAB1(c11 int, c12 int)");
        statement.execute("insert into ATDC_TAB1 values (1,11)");
        statement.execute("create table ATDC_BKUP1(c111 int, c112 int)");
        statement.execute("create trigger ATDC_TAB1_TRG1 after update of C11 on ATDC_TAB1 REFERENCING old_table as old for each statement " + (bl ? "" : "MODE DB2SQL ") + "insert into ATDC_BKUP1 select * from old");
        statement.execute("create trigger ATDC_TAB1_TRG2 after update on ATDC_TAB1 for each row " + (bl ? "" : "MODE DB2SQL ") + "values(1,2)");
    }

    public void testDERBY5120NumRowsInSydependsForTrigger() throws Exception {
        if (this.oldIs(10, 5, 1, 1) || this.oldIs(10, 5, 3, 0) || this.oldIs(10, 6, 1, 0) || this.oldIs(10, 6, 2, 1)) {
            return;
        }
        Statement statement = this.createStatement();
        boolean bl = this.oldAtLeast(10, 3);
        switch (this.getPhase()) {
            case 0: {
                this.preapreFortDERBY5120();
                statement.execute("update ATDC_TAB1 set c11=11");
                statement.executeUpdate("alter table ATDC_TAB1 add column c113 int");
                if (this.oldLessThan(10, 8, 2, 2)) {
                    statement.execute("update ATDC_TAB1 set c11=11");
                    break;
                }
                BasicSetup.assertStatementError("42802", statement, " update ATDC_TAB1 set c11=2");
                break;
            }
            case 1: 
            case 3: {
                BasicSetup.assertStatementError("42802", statement, " update ATDC_TAB1 set c11=2");
                break;
            }
            case 2: {
                BasicSetup.assertStatementError("42802", statement, " update ATDC_TAB1 set c11=2");
                this.preapreFortDERBY5120();
                statement.execute("update ATDC_TAB1 set c11=11");
                statement.executeUpdate("alter table ATDC_TAB1 add column c113 int");
                if (this.oldLessThan(10, 8, 2, 2)) {
                    statement.execute("update ATDC_TAB1 set c11=11");
                    break;
                }
                BasicSetup.assertStatementError("42802", statement, " update ATDC_TAB1 set c11=11");
                break;
            }
            case 4: {
                BasicSetup.assertStatementError("42802", statement, " update ATDC_TAB1 set c11=2");
                this.preapreFortDERBY5120();
                statement.execute("update ATDC_TAB1 set c12=11");
                statement.executeUpdate("alter table ATDC_TAB1 add column c113 int");
                BasicSetup.assertStatementError("42802", statement, " update ATDC_TAB1 set c11=2");
            }
        }
    }

    private int numberOfRowsInSysdepends(Statement statement) throws SQLException {
        ResultSet resultSet = statement.executeQuery("SELECT COUNT(*) FROM SYS.SYSDEPENDS");
        resultSet.next();
        return resultSet.getInt(1);
    }

    public void testDERBY5044_And_DERBY5120_DropColumn() throws Exception {
        if (!this.oldAtLeast(10, 3)) {
            return;
        }
        if (this.oldIs(10, 5, 1, 1) || this.oldIs(10, 5, 3, 0) || this.oldIs(10, 6, 1, 0) || this.oldIs(10, 6, 2, 1)) {
            return;
        }
        Statement statement = this.createStatement();
        switch (this.getPhase()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.dropColumn_triggersql_DERBY5044_And_DERBY5120(statement);
            }
            case 0: {
                this.preapreForDERBY5044_And_DERBY5120();
                this.triggersql_for_DERBY5044_And_DERBY5120(statement);
                this.dropColumn_triggersql_DERBY5044_And_DERBY5120(statement);
                this.preapreForDERBY5044_And_DERBY5120();
                this.triggersql_for_DERBY5044_And_DERBY5120(statement);
            }
        }
    }

    private void dropColumn_triggersql_DERBY5044_And_DERBY5120(Statement statement) throws Exception {
        switch (this.getPhase()) {
            case 0: 
            case 2: {
                ResultSet resultSet;
                statement.executeUpdate("alter table BKUP1_5044_5120 drop column c112");
                if (this.oldLessThan(10, 8, 2, 2)) {
                    BasicSetup.assertStatementError("42802", statement, " update TAB1_5044_5120 set c11=999");
                    resultSet = statement.executeQuery("select * from TAB1_5044_5120");
                    JDBC.assertFullResultSet(resultSet, new String[][]{{"99", "11"}});
                } else {
                    statement.execute("update TAB1_5044_5120 set c11=999");
                    resultSet = statement.executeQuery("select * from TAB1_5044_5120");
                    JDBC.assertFullResultSet(resultSet, new String[][]{{"999", "11"}});
                }
                resultSet = statement.executeQuery("select * from BKUP1_5044_5120");
                JDBC.assertEmpty(resultSet);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                statement.executeUpdate("alter table BKUP1_5044_5120 drop column c112");
                statement.executeUpdate("update TAB1_5044_5120 set c11=999");
                ResultSet resultSet = statement.executeQuery("select * from TAB1_5044_5120");
                JDBC.assertFullResultSet(resultSet, new String[][]{{"999", "11"}});
                resultSet = statement.executeQuery("select * from BKUP1_5044_5120");
                JDBC.assertEmpty(resultSet);
            }
        }
    }

    private void preapreForDERBY5044_And_DERBY5120() throws Exception {
        Statement statement = this.createStatement();
        boolean bl = this.oldAtLeast(10, 3);
        this.dropTable("TAB1_5044_5120");
        this.dropTable("BKUP1_5044_5120");
        statement.execute("create table TAB1_5044_5120(c11 int, c12 int)");
        statement.execute("insert into TAB1_5044_5120 values (1,11)");
        statement.execute("create table BKUP1_5044_5120(c111 int, c112 int)");
        statement.execute("create trigger TAB1_TRG1 after update of C11 on TAB1_5044_5120 REFERENCING old_table as old for each statement " + (bl ? "" : "MODE DB2SQL ") + "insert into BKUP1_5044_5120 select * from old");
        statement.execute("create trigger TAB1_TRG2 after update on TAB1_5044_5120 for each row " + (bl ? "" : "MODE DB2SQL ") + "values(1,2)");
    }

    private void triggersql_for_DERBY5044_And_DERBY5120(Statement statement) throws Exception {
        ResultSet resultSet = statement.executeQuery("select * from TAB1_5044_5120");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "11"}});
        resultSet = statement.executeQuery("select * from BKUP1_5044_5120");
        JDBC.assertEmpty(resultSet);
        statement.executeUpdate("update TAB1_5044_5120 set c11=99");
        resultSet = statement.executeQuery("select * from TAB1_5044_5120");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"99", "11"}});
        resultSet = statement.executeQuery("select * from BKUP1_5044_5120");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "11"}});
        statement.executeUpdate("delete from BKUP1_5044_5120");
    }

    public void testDERBY5044AlterTableDropColumn() throws Exception {
        if (!this.oldAtLeast(10, 3)) {
            return;
        }
        Statement statement = this.createStatement();
        switch (this.getPhase()) {
            case 0: 
            case 2: {
                this.preapreFortDERBY5044();
                ResultSet resultSet = statement.executeQuery("select * from ATDC_13_TAB1_BACKUP");
                JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "11"}});
                resultSet = statement.executeQuery("select * from ATDC_13_TAB2");
                JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "11"}});
                statement.executeUpdate("update ATDC_13_TAB1 set c12=999");
                resultSet = statement.executeQuery("select * from ATDC_13_TAB1_BACKUP");
                JDBC.assertEmpty(resultSet);
                resultSet = statement.executeQuery("select * from ATDC_13_TAB2");
                JDBC.assertEmpty(resultSet);
                statement.execute("insert into ATDC_13_TAB1_BACKUP values (1,11)");
                statement.execute("insert into ATDC_13_TAB2 values (1,11)");
                if (this.oldLessThan(10, 8, 2, 2)) {
                    statement.executeUpdate("alter table ATDC_13_TAB2 drop column c22 restrict");
                    BasicSetup.assertStatementError("42X04", statement, "update ATDC_13_TAB1 set c12=999");
                    resultSet = statement.executeQuery("select * from ATDC_13_TAB1_BACKUP");
                    JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "11"}});
                    resultSet = statement.executeQuery("select * from ATDC_13_TAB2");
                    JDBC.assertFullResultSet(resultSet, new String[][]{{"1"}});
                    break;
                }
                BasicSetup.assertStatementError("X0Y25", statement, "alter table ATDC_13_TAB2 drop column c22 restrict");
                statement.executeUpdate("update ATDC_13_TAB1 set c12=999");
                resultSet = statement.executeQuery("select * from ATDC_13_TAB1_BACKUP");
                JDBC.assertEmpty(resultSet);
                resultSet = statement.executeQuery("select * from ATDC_13_TAB2");
                JDBC.assertEmpty(resultSet);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                this.preapreFortDERBY5044();
                ResultSet resultSet = statement.executeQuery("select * from ATDC_13_TAB1_BACKUP");
                JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "11"}});
                resultSet = statement.executeQuery("select * from ATDC_13_TAB2");
                JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "11"}});
                statement.executeUpdate("update ATDC_13_TAB1 set c12=999");
                resultSet = statement.executeQuery("select * from ATDC_13_TAB1_BACKUP");
                JDBC.assertEmpty(resultSet);
                resultSet = statement.executeQuery("select * from ATDC_13_TAB2");
                JDBC.assertEmpty(resultSet);
                statement.execute("insert into ATDC_13_TAB1_BACKUP values (1,11)");
                statement.execute("insert into ATDC_13_TAB2 values (1,11)");
                BasicSetup.assertStatementError("X0Y25", statement, "alter table ATDC_13_TAB2 drop column c22 restrict");
                resultSet = statement.executeQuery("select * from ATDC_13_TAB1_BACKUP");
                JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "11"}});
                resultSet = statement.executeQuery("select * from ATDC_13_TAB2");
                JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "11"}});
                statement.executeUpdate("update ATDC_13_TAB1 set c12=999");
                resultSet = statement.executeQuery("select * from ATDC_13_TAB1_BACKUP");
                JDBC.assertEmpty(resultSet);
                resultSet = statement.executeQuery("select * from ATDC_13_TAB2");
                JDBC.assertEmpty(resultSet);
                statement.execute("insert into ATDC_13_TAB1_BACKUP values (1,11)");
                statement.execute("insert into ATDC_13_TAB2 values (1,11)");
                statement.executeUpdate("alter table ATDC_13_TAB2 drop column c22 ");
                statement.executeUpdate("update ATDC_13_TAB1 set c12=999");
                resultSet = statement.executeQuery("select * from ATDC_13_TAB1_BACKUP");
                JDBC.assertEmpty(resultSet);
                resultSet = statement.executeQuery("select * from ATDC_13_TAB2");
                JDBC.assertFullResultSet(resultSet, new String[][]{{"1"}});
            }
        }
    }

    public void preapreFortDERBY5044() throws Exception {
        Statement statement = this.createStatement();
        boolean bl = this.oldAtLeast(10, 3);
        this.dropTable("ATDC_13_TAB1");
        this.dropTable("ATDC_13_TAB1_BACKUP");
        this.dropTable("ATDC_13_TAB2");
        statement.execute("create table ATDC_13_TAB1(c11 int, c12 int)");
        statement.execute("insert into ATDC_13_TAB1 values (1,11)");
        statement.execute("create table ATDC_13_TAB1_BACKUP(c11 int, c12 int)");
        statement.execute("insert into ATDC_13_TAB1_BACKUP values (1,11)");
        statement.execute("create table ATDC_13_TAB2(c21 int, c22 int)");
        statement.execute("insert into ATDC_13_TAB2 values (1,11)");
        statement.executeUpdate(" create trigger ATDC_13_TAB1_trg1 after update on ATDC_13_TAB1 for each row " + (bl ? "" : "MODE DB2SQL ") + "DELETE FROM ATDC_13_TAB1_BACKUP WHERE C12>=1");
        statement.executeUpdate(" create trigger ATDC_13_TAB1_trg2 after update on ATDC_13_TAB1 for each row " + (bl ? "" : "MODE DB2SQL ") + "DELETE FROM ATDC_13_TAB2 WHERE C22 IN (values(11))");
    }

    public void testDERBY5121TriggerDataCorruption() throws Exception {
        Statement statement = this.createStatement();
        boolean bl = this.oldAtLeast(10, 3);
        switch (this.getPhase()) {
            case 0: {
                statement.execute("CREATE TABLE UPGRADE_tab1(id int, name varchar(20))");
                statement.execute("CREATE TABLE UPGRADE_tab2(name varchar(20) not null, description int not null, id int)");
                statement.execute("create trigger UPGRADE_Trg1 after UPDATE of name on UPGRADE_tab2 referencing new as nr for each ROW " + (bl ? "" : "MODE DB2SQL ") + "insert into UPGRADE_tab1 values ( nr.id, nr.name )");
                statement.execute("insert into UPGRADE_tab2(name,description) values ( 'Foo1 Name', 0 )");
                statement.execute("update UPGRADE_tab2 set name = 'Another name' , description = 1");
                ResultSet resultSet = statement.executeQuery("select * from UPGRADE_tab1");
                if (this.oldIs(10, 7, 1, 1)) {
                    JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "Another name"}});
                } else {
                    JDBC.assertFullResultSet(resultSet, new String[][]{{null, "Another name"}});
                }
                statement.execute("delete from UPGRADE_tab1");
                statement.execute("delete from UPGRADE_tab2");
                statement.execute("CREATE TABLE POSTSFT_UPGRD_tab1(id int, name varchar(20))");
                statement.execute("CREATE TABLE POSTSFT_UPGRD_tab2(name varchar(20) not null, description int not null, id int)");
                statement.execute("create trigger POSTSFT_UPGRD_Trg1 after UPDATE of name on POSTSFT_UPGRD_tab2 referencing new as nr for each ROW " + (bl ? "" : "MODE DB2SQL ") + "insert into POSTSFT_UPGRD_tab1 values ( nr.id, nr.name )");
                statement.execute("insert into POSTSFT_UPGRD_tab2(name,description) values ( 'Foo1 Name', 0 )");
                statement.execute("update POSTSFT_UPGRD_tab2 set name = 'Another name' , description = 1");
                resultSet = statement.executeQuery("select * from POSTSFT_UPGRD_tab1");
                if (this.oldIs(10, 7, 1, 1)) {
                    JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "Another name"}});
                } else {
                    JDBC.assertFullResultSet(resultSet, new String[][]{{null, "Another name"}});
                }
                statement.execute("delete from POSTSFT_UPGRD_tab1");
                statement.execute("delete from POSTSFT_UPGRD_tab2");
                statement.execute("CREATE TABLE HARD_UPGRADE_tab1(id int, name varchar(20))");
                statement.execute("CREATE TABLE HARD_UPGRADE_tab2(name varchar(20) not null, description int not null, id int)");
                statement.execute("create trigger HARD_UPGRADE_Trg1 after UPDATE of name on HARD_UPGRADE_tab2 referencing new as nr for each ROW " + (bl ? "" : "MODE DB2SQL ") + "insert into HARD_UPGRADE_tab1 values ( nr.id, nr.name )");
                statement.execute("insert into HARD_UPGRADE_tab2(name,description) values ( 'Foo1 Name', 0 )");
                statement.execute("update HARD_UPGRADE_tab2 set name = 'Another name' , description = 1");
                resultSet = statement.executeQuery("select * from HARD_UPGRADE_tab1");
                if (this.oldIs(10, 7, 1, 1)) {
                    JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "Another name"}});
                } else {
                    JDBC.assertFullResultSet(resultSet, new String[][]{{null, "Another name"}});
                }
                statement.execute("delete from HARD_UPGRADE_tab1");
                statement.execute("delete from HARD_UPGRADE_tab2");
                statement.execute("CREATE TABLE POSTHRD_UPGRD_tab1(id int, name varchar(20))");
                statement.execute("CREATE TABLE POSTHRD_UPGRD_tab2(name varchar(20) not null, description int not null, id int)");
                statement.execute("create trigger POSTHRD_UPGRD_Trg1 after UPDATE of name on POSTHRD_UPGRD_tab2 referencing new as nr for each ROW " + (bl ? "" : "MODE DB2SQL ") + "insert into POSTHRD_UPGRD_tab1 values ( nr.id, nr.name )");
                statement.execute("insert into POSTHRD_UPGRD_tab2(name,description) values ( 'Foo1 Name', 0 )");
                statement.execute("update POSTHRD_UPGRD_tab2 set name = 'Another name' , description = 1");
                resultSet = statement.executeQuery("select * from POSTHRD_UPGRD_tab1");
                if (this.oldIs(10, 7, 1, 1)) {
                    JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "Another name"}});
                } else {
                    JDBC.assertFullResultSet(resultSet, new String[][]{{null, "Another name"}});
                }
                statement.execute("delete from POSTHRD_UPGRD_tab1");
                statement.execute("delete from POSTHRD_UPGRD_tab2");
                break;
            }
            case 1: {
                statement.execute("insert into UPGRADE_tab2(name,description) values ( 'Foo1 Name', 0 )");
                statement.execute("update UPGRADE_tab2 set name = 'Another name' , description = 1");
                ResultSet resultSet = statement.executeQuery("select * from UPGRADE_tab1");
                JDBC.assertFullResultSet(resultSet, new String[][]{{null, "Another name"}});
                statement.execute("delete from UPGRADE_tab1");
                statement.execute("delete from UPGRADE_tab2");
                statement.execute("drop trigger UPGRADE_Trg1");
                statement.execute("create trigger UPGRADE_Trg1 after UPDATE of name on UPGRADE_tab2 referencing new as nr for each ROW " + (bl ? "" : "MODE DB2SQL ") + "insert into UPGRADE_tab1 values ( nr.id, nr.name )");
                statement.execute("insert into UPGRADE_tab2(name,description) values ( 'Foo1 Name', 0 )");
                statement.execute("update UPGRADE_tab2 set name = 'Another name' , description = 1");
                resultSet = statement.executeQuery("select * from UPGRADE_tab1");
                JDBC.assertFullResultSet(resultSet, new String[][]{{null, "Another name"}});
                statement.execute("delete from UPGRADE_tab1");
                statement.execute("delete from UPGRADE_tab2");
                break;
            }
            case 2: {
                statement.execute("insert into UPGRADE_tab2(name,description) values ( 'Foo1 Name', 0 )");
                statement.execute("update UPGRADE_tab2 set name = 'Another name' , description = 1");
                ResultSet resultSet = statement.executeQuery("select * from UPGRADE_tab1");
                JDBC.assertFullResultSet(resultSet, new String[][]{{null, "Another name"}});
                statement.execute("delete from UPGRADE_tab1");
                statement.execute("delete from UPGRADE_tab2");
                statement.execute("drop trigger UPGRADE_Trg1");
                statement.execute("create trigger UPGRADE_Trg1 after UPDATE of name on UPGRADE_tab2 referencing new as nr for each ROW " + (bl ? "" : "MODE DB2SQL ") + "insert into UPGRADE_tab1 values ( nr.id, nr.name )");
                statement.execute("insert into UPGRADE_tab2(name,description) values ( 'Foo1 Name', 0 )");
                statement.execute("update UPGRADE_tab2 set name = 'Another name' , description = 1");
                resultSet = statement.executeQuery("select * from UPGRADE_tab1");
                if (this.oldIs(10, 7, 1, 1)) {
                    JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "Another name"}});
                } else {
                    JDBC.assertFullResultSet(resultSet, new String[][]{{null, "Another name"}});
                }
                statement.execute("delete from UPGRADE_tab1");
                statement.execute("delete from UPGRADE_tab2");
                statement.execute("insert into POSTSFT_UPGRD_tab2(name,description) values ( 'Foo1 Name', 0 )");
                statement.execute("update POSTSFT_UPGRD_tab2 set name = 'Another name' , description = 1");
                resultSet = statement.executeQuery("select * from POSTSFT_UPGRD_tab1");
                if (this.oldIs(10, 7, 1, 1)) {
                    JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "Another name"}});
                } else {
                    JDBC.assertFullResultSet(resultSet, new String[][]{{null, "Another name"}});
                }
                statement.execute("delete from POSTSFT_UPGRD_tab1");
                statement.execute("delete from POSTSFT_UPGRD_tab2");
                statement.execute("insert into HARD_UPGRADE_tab2(name,description) values ( 'Foo1 Name', 0 )");
                statement.execute("update HARD_UPGRADE_tab2 set name = 'Another name' , description = 1");
                resultSet = statement.executeQuery("select * from HARD_UPGRADE_tab1");
                if (this.oldIs(10, 7, 1, 1)) {
                    JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "Another name"}});
                } else {
                    JDBC.assertFullResultSet(resultSet, new String[][]{{null, "Another name"}});
                }
                statement.execute("delete from HARD_UPGRADE_tab1");
                statement.execute("delete from HARD_UPGRADE_tab2");
                statement.execute("insert into POSTHRD_UPGRD_tab2(name,description) values ( 'Foo1 Name', 0 )");
                statement.execute("update POSTHRD_UPGRD_tab2 set name = 'Another name' , description = 1");
                resultSet = statement.executeQuery("select * from POSTHRD_UPGRD_tab1");
                if (this.oldIs(10, 7, 1, 1)) {
                    JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "Another name"}});
                } else {
                    JDBC.assertFullResultSet(resultSet, new String[][]{{null, "Another name"}});
                }
                statement.execute("delete from POSTHRD_UPGRD_tab1");
                statement.execute("delete from POSTHRD_UPGRD_tab2");
                break;
            }
            case 3: {
                statement.execute("insert into UPGRADE_tab2(name,description) values ( 'Foo1 Name', 0 )");
                statement.execute("update UPGRADE_tab2 set name = 'Another name' , description = 1");
                ResultSet resultSet = statement.executeQuery("select * from UPGRADE_tab1");
                JDBC.assertFullResultSet(resultSet, new String[][]{{null, "Another name"}});
                statement.execute("delete from UPGRADE_tab1");
                statement.execute("delete from UPGRADE_tab2");
                statement.execute("insert into HARD_UPGRADE_tab2(name,description) values ( 'Foo1 Name', 0 )");
                statement.execute("update HARD_UPGRADE_tab2 set name = 'Another name' , description = 1");
                resultSet = statement.executeQuery("select * from HARD_UPGRADE_tab1");
                JDBC.assertFullResultSet(resultSet, new String[][]{{null, "Another name"}});
                statement.execute("delete from HARD_UPGRADE_tab1");
                statement.execute("delete from HARD_UPGRADE_tab2");
                break;
            }
            case 4: {
                statement.execute("insert into UPGRADE_tab2(name,description) values ( 'Foo1 Name', 0 )");
                statement.execute("update UPGRADE_tab2 set name = 'Another name' , description = 1");
                ResultSet resultSet = statement.executeQuery("select * from UPGRADE_tab1");
                JDBC.assertFullResultSet(resultSet, new String[][]{{null, "Another name"}});
                statement.execute("delete from UPGRADE_tab1");
                statement.execute("delete from UPGRADE_tab2");
                statement.execute("insert into HARD_UPGRADE_tab2(name,description) values ( 'Foo1 Name', 0 )");
                statement.execute("update HARD_UPGRADE_tab2 set name = 'Another name' , description = 1");
                resultSet = statement.executeQuery("select * from HARD_UPGRADE_tab1");
                JDBC.assertFullResultSet(resultSet, new String[][]{{null, "Another name"}});
                statement.execute("delete from HARD_UPGRADE_tab1");
                statement.execute("delete from HARD_UPGRADE_tab2");
                statement.execute("insert into POSTHRD_UPGRD_tab2(name,description) values ( 'Foo1 Name', 0 )");
                statement.execute("update POSTHRD_UPGRD_tab2 set name = 'Another name' , description = 1");
                resultSet = statement.executeQuery("select * from POSTHRD_UPGRD_tab1");
                JDBC.assertFullResultSet(resultSet, new String[][]{{null, "Another name"}});
                statement.execute("delete from POSTHRD_UPGRD_tab1");
                statement.execute("delete from POSTHRD_UPGRD_tab2");
            }
        }
    }

    public void atestTriggersWithLOBcolumns() throws Exception {
        Statement statement = this.createStatement();
        boolean bl = this.oldAtLeast(10, 3);
        switch (this.getPhase()) {
            case 0: {
                statement.execute("create table table1LOBtest (id int, status smallint, bl blob(2G))");
                PreparedStatement preparedStatement = this.prepareStatement("insert into table1LOBtest values (?, 0, ?)");
                preparedStatement.setInt(1, 1);
                preparedStatement.setBinaryStream(2, (InputStream)new LoopingAlphabetStream(51200000L), 51200000);
                preparedStatement.executeUpdate();
                statement.execute("create table table2LOBtest (id int, updates int default 0)");
                preparedStatement = this.prepareStatement("insert into table2LOBtest (id) values (?)");
                preparedStatement.setInt(1, 1);
                preparedStatement.executeUpdate();
                statement.execute("create trigger trigger1 after update of status on table1LOBtest referencing new as n_row for each row " + (bl ? "" : "MODE DB2SQL ") + "update table2LOBtest set updates = updates + 1 where table2LOBtest.id = n_row.id");
                break;
            }
            case 3: {
                if (this.getConnection().getMetaData().getDatabaseMajorVersion() < 10 || this.getConnection().getMetaData().getDatabaseMinorVersion() < 9) break;
                PreparedStatement preparedStatement = this.prepareStatement("update table1LOBtest set status = 1 where id = 1");
                preparedStatement.executeUpdate();
            }
        }
    }

    public void testExhuastivePermutationOfTriggerColumns() throws Exception {
        int n = 3;
        int[][] nArray = this.constructPowerSet(n);
        int[][] nArray2 = this.permute(nArray);
        int[] nArray3 = new int[2];
        switch (this.getPhase()) {
            case 0: {
                for (int i = 0; i < nArray.length; ++i) {
                    for (int j = 0; j < nArray2.length; ++j) {
                        this.createT1(nArray[i], nArray2[j]);
                        this.createT2(n, nArray[i], nArray2[j]);
                        this.createTrigger(nArray[i], nArray2[j]);
                    }
                }
                break;
            }
            case 1: {
                for (int i = 0; i < nArray.length; ++i) {
                    for (int j = 0; j < nArray2.length; ++j) {
                        for (int k = 0; k < nArray2.length; ++k) {
                            this.runTrigger(nArray3, n, nArray[i], nArray2[j], nArray2[k]);
                        }
                    }
                }
                break;
            }
        }
        this.summarize(nArray3);
    }

    private int[][] constructPowerSet(int n) {
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        boolean[] blArray = new boolean[n];
        this.include(arrayList, 0, blArray);
        int[][] nArrayArray = new int[arrayList.size()][];
        arrayList.toArray((T[])nArrayArray);
        return nArrayArray;
    }

    private void include(ArrayList<int[]> arrayList, int n, boolean[] blArray) {
        if (n >= blArray.length) {
            int n2 = blArray.length;
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                if (!blArray[i]) continue;
                ++n3;
            }
            if (n3 > 0) {
                int[] nArray = new int[n3];
                int n4 = 0;
                for (int i = 0; i < n2; ++i) {
                    if (!blArray[i]) continue;
                    nArray[n4++] = i;
                }
                arrayList.add(nArray);
            }
            return;
        }
        this.include(arrayList, n, blArray, false);
        this.include(arrayList, n, blArray, true);
    }

    private void include(ArrayList<int[]> arrayList, int n, boolean[] blArray, boolean bl) {
        blArray[n++] = bl;
        this.include(arrayList, n, blArray);
    }

    private int[][] permute(int[][] nArray) {
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        for (int i = 0; i < nArray.length; ++i) {
            this.permute(arrayList, new int[0], nArray[i]);
        }
        int[][] nArrayArray = new int[arrayList.size()][];
        arrayList.toArray((T[])nArrayArray);
        return nArrayArray;
    }

    private void permute(ArrayList<int[]> arrayList, int[] nArray, int[] nArray2) {
        int n = nArray.length;
        int n2 = nArray2.length;
        for (int i = 0; i < nArray2.length; ++i) {
            int[] nArray3 = new int[n + 1];
            for (int j = 0; j < n; ++j) {
                nArray3[j] = nArray[j];
            }
            nArray3[n] = nArray2[i];
            if (n2 <= 1) {
                arrayList.add(nArray3);
                continue;
            }
            int[] nArray4 = new int[n2 - 1];
            int n3 = 0;
            for (int j = 0; j < n2; ++j) {
                if (j == i) continue;
                nArray4[n3++] = nArray2[j];
            }
            this.permute(arrayList, nArray3, nArray4);
        }
    }

    private String columnName(String string, int n) {
        return string + "_" + n;
    }

    private void createT1(int[] nArray, int[] nArray2) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("create table " + this.makeTableName("t1", nArray, nArray2) + "( ");
        for (int i = 0; i < nArray2.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.columnName("b", i));
            stringBuffer.append(" int");
        }
        stringBuffer.append(" )");
        Statement statement = this.createStatement();
        statement.execute(stringBuffer.toString());
    }

    private void createT2(int n, int[] nArray, int[] nArray2) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("create table " + this.makeTableName("t2", nArray, nArray2) + "( ");
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.columnName("a", i));
            stringBuffer.append(" int");
        }
        stringBuffer.append(" )");
        Statement statement = this.createStatement();
        statement.execute(stringBuffer.toString());
    }

    private String makeTableName(String string, int[] nArray, int[] nArray2) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        for (n = 0; n < nArray.length; ++n) {
            stringBuffer.append("_");
            stringBuffer.append(nArray[n]);
        }
        stringBuffer.append("__");
        for (n = 0; n < nArray2.length; ++n) {
            stringBuffer.append("_");
            stringBuffer.append(nArray2[n]);
        }
        return stringBuffer.toString();
    }

    private void createTrigger(int[] nArray, int[] nArray2) throws Exception {
        int n;
        boolean bl = this.oldAtLeast(10, 3);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("create trigger " + this.makeTriggerName("UTrg", nArray, nArray2) + " after update of ");
        for (n = 0; n < nArray.length; ++n) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.columnName("a", nArray[n]));
        }
        stringBuffer.append("\n\ton " + this.makeTableName("t2", nArray, nArray2) + " referencing new as nr for each row ");
        stringBuffer.append(bl ? "" : "\n\tMODE DB2SQL ");
        stringBuffer.append("\n\tinsert into " + this.makeTableName("t1", nArray, nArray2) + " values ( ");
        for (n = 0; n < nArray2.length; ++n) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("nr." + this.columnName("a", nArray2[n]));
        }
        stringBuffer.append(" )");
        Statement statement = this.createStatement();
        statement.execute(stringBuffer.toString());
    }

    private String makeTriggerName(String string, int[] nArray, int[] nArray2) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        for (n = 0; n < nArray.length; ++n) {
            stringBuffer.append("_");
            stringBuffer.append(nArray[n]);
        }
        stringBuffer.append("__");
        for (n = 0; n < nArray2.length; ++n) {
            stringBuffer.append("_");
            stringBuffer.append(nArray2[n]);
        }
        return stringBuffer.toString();
    }

    private int[] getResults(int n, String string) throws Exception {
        PreparedStatement preparedStatement = this.prepareStatement(string);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (!resultSet.next()) {
            return new int[0];
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = resultSet.getInt(i + 1);
        }
        resultSet.close();
        preparedStatement.close();
        return nArray;
    }

    private boolean overlap(int[] nArray, int[] nArray2) {
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                if (nArray[i] != nArray2[j]) continue;
                return true;
            }
        }
        return false;
    }

    private void vetData(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, String string) throws Exception {
        String string2 = this.makeTableName("t1", nArray2, nArray3);
        String string3 = this.makeTableName("t2", nArray2, nArray3);
        int n = nArray3.length;
        int[] nArray5 = this.getResults(n, "select * from " + string2);
        if (!this.overlap(nArray2, nArray4)) {
            if (nArray5.length != 0) {
                this.fail(nArray, nArray2, nArray3, nArray4, "No row should have been inserted into t1! updateStatement = '" + string + "' and t1Row = " + this.stringify(nArray5));
            }
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select ");
        for (int i = 0; i < nArray3.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.columnName("a", nArray3[i]));
        }
        stringBuffer.append(" from " + string3);
        int[] nArray6 = this.getResults(n, stringBuffer.toString());
        if (!this.stringify(nArray5).equals(this.stringify(nArray6))) {
            String string4 = "Wrong data inserted into t1! updateStatement = '" + string + "'. Expected " + this.stringify(nArray6) + " but found " + this.stringify(nArray5);
            this.fail(nArray, nArray2, nArray3, nArray4, string4);
        }
    }

    private void runTrigger(int[] nArray, int n, int[] nArray2, int[] nArray3, int[] nArray4) throws Exception {
        nArray[0] = nArray[0] + 1;
        this.loadData(n, nArray2, nArray3);
        String string = this.updateData(nArray, nArray2, nArray3, nArray4);
        this.vetData(nArray, nArray2, nArray3, nArray4, string);
    }

    private void loadData(int n, int[] nArray, int[] nArray2) throws Exception {
        String string = this.makeTableName("t1", nArray, nArray2);
        String string2 = this.makeTableName("t2", nArray, nArray2);
        Statement statement = this.createStatement();
        statement.execute("delete from " + string);
        statement.execute("delete from " + string2);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("insert into " + string2 + " values ( ");
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(i);
        }
        stringBuffer.append(" )");
        statement.execute(stringBuffer.toString());
    }

    private String updateData(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) throws Exception {
        String string = this.makeTableName("t2", nArray2, nArray3);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("update " + string + " set ");
        for (int i = 0; i < nArray4.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.columnName("a", nArray4[i]));
            stringBuffer.append(" = ");
            stringBuffer.append(100 + i);
        }
        String string2 = stringBuffer.toString();
        try {
            Statement statement = this.createStatement();
            statement.execute(string2);
        }
        catch (SQLException sQLException) {
            this.fail(nArray, nArray2, nArray3, nArray4, "Update statement failed! updateStatement = '" + string2);
        }
        return string2;
    }

    private void fail(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, String string) {
        nArray[1] = nArray[1] + 1;
        String string2 = "FAILED for triggerCols = " + this.stringify(nArray2) + " and permutation = " + this.stringify(nArray3) + " and updateColumns = " + this.stringify(nArray4) + ". " + string;
        System.out.println(string2);
    }

    private void summarize(int[] nArray) {
        int n = nArray[0];
        int n2 = nArray[1];
        if (n2 != 0) {
            System.out.println("FAILURE! " + n + " test cases run, of which " + n2 + " failed.");
        }
    }

    private String stringify(int[][] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append("\n\t");
            stringBuffer.append(this.stringify(nArray[i]));
        }
        stringBuffer.append("\n]\n");
        return stringBuffer.toString();
    }

    private String stringify(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(nArray[i]);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void xmlTestTriggerWithXMLOperators() throws SQLException {
        if (!this.oldAtLeast(10, 3)) {
            return;
        }
        Statement statement = this.createStatement();
        if (this.getPhase() == 0) {
            statement.execute("create table d3870_t1(i int, x varchar(100))");
            statement.execute("create table d3870_t2(i int)");
            try {
                statement.execute("create trigger d3870_tr after insert on d3870_t1 for each statement insert into d3870_t2 select i from d3870_t1 where xmlexists('//a' passing by ref xmlparse(document x preserve whitespace))");
            }
            catch (SQLException sQLException) {
                BasicSetup.assertSQLState("XML00", sQLException);
                return;
            }
        } else {
            statement.executeUpdate("delete from d3870_t1");
            statement.executeUpdate("delete from d3870_t2");
        }
        ResultSet resultSet = statement.executeQuery("select 1 from sys.systriggers where triggername = 'D3870_TR'");
        boolean bl = resultSet.next();
        resultSet.close();
        if (bl) {
            statement.execute("insert into d3870_t1 values (1, '<a/>'), (2, '<b/>'), (3, '<c/>')");
            JDBC.assertSingleValueResultSet(statement.executeQuery("select * from d3870_t2"), "1");
        }
    }

    public void testDERBY5289TriggerUpgradeFormat() throws SQLException {
        Statement statement = this.createStatement();
        switch (this.getPhase()) {
            case 0: {
                statement.executeUpdate("CREATE TABLE D5289TABLE1 (COL1 VARCHAR(5))");
                statement.executeUpdate("CREATE TABLE D5289TABLE2 (COL2 VARCHAR(5))");
                statement.executeUpdate("CREATE TABLE D5289TABLE3 (COL3 VARCHAR(5))");
                statement.executeUpdate("CREATE TRIGGER D5289T1_UPDATED AFTER UPDATE ON D5289TABLE1 REFERENCING OLD AS OLD NEW AS NEW FOR EACH ROW MODE DB2SQL UPDATE D5289TABLE2 SET COL2 = NEW.COL1 WHERE COL2 = OLD.COL1");
                statement.executeUpdate("CREATE TRIGGER D5289T2_UPDATED AFTER UPDATE ON D5289TABLE2 REFERENCING NEW AS NEW FOR EACH ROW MODE DB2SQL INSERT INTO D5289TABLE3(COL3) VALUES('ccc')");
                statement.executeUpdate("insert into D5289TABLE1(COL1) values ('aaa') ");
                statement.executeUpdate("insert into D5289TABLE2(COL2) values ('aaa') ");
                statement.executeUpdate("UPDATE D5289TABLE1 SET COL1 = 'bbb'");
                this.assertDERBY5289ResultsAndDelete();
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                statement.executeUpdate("insert into D5289TABLE1(COL1) values ('aaa')");
                statement.executeUpdate("insert into D5289TABLE2(COL2) values ('aaa') ");
                statement.executeUpdate("UPDATE D5289TABLE1 SET COL1 = 'bbb'");
                this.assertDERBY5289ResultsAndDelete();
            }
        }
    }

    private void assertDERBY5289ResultsAndDelete() throws SQLException {
        Statement statement = this.createStatement();
        JDBC.assertFullResultSet(statement.executeQuery("SELECT * FROM D5289TABLE1"), new String[][]{{"bbb"}});
        JDBC.assertFullResultSet(statement.executeQuery("SELECT * FROM D5289TABLE2"), new String[][]{{"bbb"}});
        JDBC.assertFullResultSet(statement.executeQuery("SELECT * FROM D5289TABLE3"), new String[][]{{"ccc"}});
        statement.executeUpdate("DELETE FROM D5289TABLE1");
        statement.executeUpdate("DELETE FROM D5289TABLE2");
        statement.executeUpdate("DELETE FROM D5289TABLE3");
        this.commit();
    }

    public void testDERBY6314() throws SQLException {
        JDBC.assertDrainResults(this.getConnection().getMetaData().getSchemas());
    }

    public void testDERBY4753() throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSourceLogical("DERBY-4753");
        if (this.getPhase() == 0) {
            JDBCDataSource.setBeanProperty(dataSource, "createDatabase", "create");
            Connection connection = dataSource.getConnection();
            Statement statement = connection.createStatement();
            statement.execute("call syscs_util.syscs_set_database_property('derby.language.stalePlanCheckInterval', '5')");
            statement.close();
            connection.close();
        } else if (this.getPhase() == 1) {
            int n;
            Connection connection = dataSource.getConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            JDBC.assertEmpty(databaseMetaData.getIndexInfo(null, null, "", true, true));
            Statement statement = connection.createStatement();
            for (n = 0; n < 10; ++n) {
                String string = "create table s" + n + ".t(col0 int";
                for (int i = 1; i < 1000; ++i) {
                    string = string + ", col" + i + " int";
                }
                string = string + ")";
                statement.execute(string);
            }
            statement.close();
            for (n = 0; n < 5; ++n) {
                JDBC.assertEmpty(databaseMetaData.getIndexInfo(null, null, "", true, true));
            }
            connection.close();
        }
    }
}

