/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.XML;

public class XMLConcurrencyTest
extends BaseJDBCTestCase {
    public XMLConcurrencyTest(String string) {
        super(string);
    }

    public static Test suite() {
        if (XML.classpathMeetsXMLReqs()) {
            return new CleanDatabaseTestSetup(TestConfiguration.embeddedSuite(XMLConcurrencyTest.class)){

                @Override
                protected void decorateSQL(Statement statement) throws SQLException {
                    XMLConcurrencyTest.createTestTable(statement);
                }
            };
        }
        return new BaseTestSuite("XMLConcurrencyTest - empty");
    }

    public void testConcurrency() throws Exception {
        int n;
        WorkerThread[] workerThreadArray = new WorkerThread[4];
        for (n = 0; n < workerThreadArray.length; ++n) {
            workerThreadArray[n] = new WorkerThread(this, this.openDefaultConnection(), 100);
            workerThreadArray[n].start();
        }
        for (n = 0; n < workerThreadArray.length; ++n) {
            workerThreadArray[n].join();
            Throwable throwable = workerThreadArray[n].throwable;
            if (throwable == null) continue;
            XMLConcurrencyTest.fail("Worker thread failed", throwable);
        }
    }

    private static void createTestTable(Statement statement) throws SQLException {
        statement.executeUpdate("create table t (id int primary key generated always as identity, vc varchar(100), x generated always as (xmlparse(document vc preserve whitespace)))");
        PreparedStatement preparedStatement = statement.getConnection().prepareStatement("insert into t(vc) values ?");
        String[] stringArray = new String[]{"<doc><a x='1'>abc</a><b x='2'>def</b></doc>", "<doc><a x='2'>abc</a><b x='3'>def</b></doc>", "<doc/>", "<a/>", null};
        for (int i = 0; i < stringArray.length; ++i) {
            preparedStatement.setString(1, stringArray[i]);
            preparedStatement.executeUpdate();
        }
        preparedStatement.close();
    }

    private static void runXMLTest(Connection connection, int n) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("select id, xmlserialize(xmlquery('count(//*[@x>1])' passing by ref x empty on empty) as varchar(100)) from t order by id");
        String[][] stringArray = new String[][]{{"1", "1"}, {"2", "2"}, {"3", "0"}, {"4", "0"}, {"5", null}};
        PreparedStatement preparedStatement2 = connection.prepareStatement("select id from t where xmlexists('/doc/a[@x=2]' passing by ref x) order by id");
        String string = "2";
        PreparedStatement preparedStatement3 = connection.prepareStatement("select count(*) from t where xmlserialize(xmlparse(document vc preserve whitespace) as varchar(100)) = xmlserialize(x as varchar(100))");
        String string2 = "4";
        for (int i = 0; i < n; ++i) {
            JDBC.assertFullResultSet(preparedStatement.executeQuery(), stringArray);
            JDBC.assertSingleValueResultSet(preparedStatement2.executeQuery(), string);
            JDBC.assertSingleValueResultSet(preparedStatement3.executeQuery(), string2);
        }
        preparedStatement.close();
        preparedStatement2.close();
        preparedStatement3.close();
        connection.close();
    }

    private class WorkerThread
    extends Thread {
        final Connection conn;
        final int iterations;
        Throwable throwable;

        WorkerThread(XMLConcurrencyTest xMLConcurrencyTest, Connection connection, int n) {
            this.conn = connection;
            this.iterations = n;
        }

        @Override
        public void run() {
            try {
                XMLConcurrencyTest.runXMLTest(this.conn, this.iterations);
            }
            catch (Throwable throwable) {
                this.throwable = throwable;
            }
        }
    }
}

