/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Arrays;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class RolesTest
extends BaseJDBCTestCase {
    private final int _authLevel;
    private final String _user;
    private final String _userPassword;
    private Connection _conn;
    private Statement _stm;
    private static final int NO_SQLAUTHORIZATION = 0;
    private static final int SQLAUTHORIZATION = 1;
    private static final String pwSuffix = "pwSuffix";
    private static final String sqlAuthorizationRequired = "42Z60";
    private static final String syntaxError = "42X01";
    private static final String roleDboOnly = "4251A";
    private static final String invalidRole = "0P000";
    private static final String tooLongId = "42622";
    private static final String revokeWarn = "01007";
    private static final String notIdle = "25001";
    private static final String invalidRoleName = "4293A";
    private static final String userException = "38000";
    private static final String objectAlreadyExists = "X0Y68";
    private static final String invalidPUBLIC = "4251B";
    private static final String loginFailed = "08004";
    private static final String roleGrantCircularity = "4251C";
    private static final String idParseError = "XCXA0";
    private int MAX_IDENTIFIER_LENGTH = 128;
    private static final String[] users = new String[]{"TEST_DBO", "DonaldDuck", "\"additional\"\"user\""};
    private static final int dboIndex = 0;
    private static final int nonDboIndex = 1;
    private static final int additionaluserIndex = 2;

    private boolean isDbo() {
        return users[0].equals(this._user);
    }

    public RolesTest(String string, int n, String string2, String string3) {
        super(string);
        this._authLevel = n;
        this._user = string2;
        this._userPassword = string3;
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("RolesTest");
        baseTestSuite.addTest(RolesTest.negativeSyntaxSuite("suite: negative syntax, embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(RolesTest.negativeSyntaxSuite("suite: negative syntax, client")));
        baseTestSuite.addTest(RolesTest.positiveSyntaxSuite("suite: positive syntax, embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(RolesTest.positiveSyntaxSuite("suite: positive syntax, client")));
        baseTestSuite.addTest(RolesTest.semanticSuite("suite: semantic, embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(RolesTest.semanticSuite("suite: semantic, client")));
        return baseTestSuite;
    }

    private static Test negativeSyntaxSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite("roles:" + string);
        BaseTestSuite baseTestSuite2 = new BaseTestSuite("suite: security level=noSqlAuthorization");
        baseTestSuite2.addTest((Test)new RolesTest("testNegativeSyntax", 0, null, null));
        baseTestSuite.addTest((Test)baseTestSuite2);
        baseTestSuite.addTest(RolesTest.wrapInAuthorization("testNegativeSyntax"));
        return baseTestSuite;
    }

    private static Test positiveSyntaxSuite(String string) {
        String string2 = users[0];
        String string3 = string2.concat(pwSuffix);
        Test test = TestConfiguration.changeUserDecorator((Test)new RolesTest("testPositiveSyntax", 1, string2, string3), string2, string3);
        return TestConfiguration.sqlAuthorizationDecorator(DatabasePropertyTestSetup.builtinAuthentication(test, users, pwSuffix));
    }

    public void testNegativeSyntax() throws SQLException {
        RolesTest.println("testNegativeSyntax: auth=" + this._authLevel + " user=" + this.getTestConfiguration().getUserName());
        this._conn = this.getConnection();
        this._stm = this._conn.createStatement();
        this.doStmt("create role none", syntaxError, syntaxError, syntaxError);
        this.doStmt("create role current_role", syntaxError, syntaxError, syntaxError);
        char[] cArray = new char[this.MAX_IDENTIFIER_LENGTH + 1];
        Arrays.fill(cArray, 'a');
        String string = new String(cArray);
        this.doStmt("create role " + string, tooLongId, tooLongId, tooLongId);
        this.doStmt("create role sysrole", sqlAuthorizationRequired, invalidRoleName, invalidRoleName);
        this.doStmt("create role \"SYSROLE\"", sqlAuthorizationRequired, invalidRoleName, invalidRoleName);
        this.doStmt("create role public", syntaxError, syntaxError, syntaxError);
        this.doStmt("create role \"PUBLIC\"", sqlAuthorizationRequired, invalidPUBLIC, roleDboOnly);
        this.doStmt("grant \"PUBLIC\" to " + users[1], sqlAuthorizationRequired, invalidPUBLIC, invalidPUBLIC);
        this.doStmt("revoke \"PUBLIC\" from " + users[1], sqlAuthorizationRequired, invalidPUBLIC, invalidPUBLIC);
        this._stm.close();
    }

    public void testPositiveSyntax() throws SQLException {
        RolesTest.println("testPositiveSyntax");
        String string = null;
        int n = -1;
        if (!this.isDbo()) {
            throw new SQLException("test error");
        }
        this._conn = this.getConnection();
        this._stm = this._conn.createStatement();
        this.doStmt("create role trigger", string, null, string);
        this.doStmt("create role role", string, null, string);
        String string2 = "r123456789012345678901234567890";
        this.doStmt("create role " + string2, string, null, string);
        this.assertSysRolesRowCount(n, 3, n);
        this.doStmt("grant trigger to foo", string, null, string);
        this.doStmt("grant role to foo", string, null, string);
        this.doStmt("revoke trigger from foo", string, null, string);
        this.doStmt("revoke role from foo", string, null, string);
        this.doStmt("set role " + string2, string, null, string);
        this.doStmt("create table mytab(i int)", string, null, string);
        this.doStmt("grant select on mytab to " + string2, string, null, string);
        this.doStmt("revoke select on mytab from " + string2, string, null, string);
        this.doStmt("drop table mytab", string, null, string);
        this.doStmt("drop role trigger", string, null, string);
        this.doStmt("drop role role", string, null, string);
        this.doStmt("drop role " + string2, string, null, string);
        this.assertSysRolesRowCount(n, 0, n);
        this._stm.close();
    }

    private static Test semanticSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite("suite: security level=noSqlAuthorization");
        baseTestSuite.addTest((Test)new RolesTest("testSemantics", 0, null, null));
        BaseTestSuite baseTestSuite2 = new BaseTestSuite("roles:" + string);
        baseTestSuite2.addTest((Test)baseTestSuite);
        baseTestSuite2.addTest(RolesTest.wrapInAuthorization("testSemantics"));
        return baseTestSuite2;
    }

    private static Test wrapInAuthorization(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite("suite: security level=sqlAuthorization");
        for (int i = 0; i <= users.length - 2; ++i) {
            baseTestSuite.addTest(TestConfiguration.changeUserDecorator((Test)new RolesTest(string, 1, users[i], users[i].concat(pwSuffix)), users[i], users[i].concat(pwSuffix)));
        }
        return TestConfiguration.sqlAuthorizationDecorator(DatabasePropertyTestSetup.builtinAuthentication((Test)baseTestSuite, users, pwSuffix));
    }

    public void testSemantics() throws SQLException {
        RolesTest.println("testSemantics: auth=" + this._authLevel + " user=" + this.getTestConfiguration().getUserName());
        this._conn = this.getConnection();
        this._stm = this._conn.createStatement();
        this.doStmt("create role foo", sqlAuthorizationRequired, null, roleDboOnly);
        this.doStmt("create role bar", sqlAuthorizationRequired, null, roleDboOnly);
        this.doStmt("create role notGranted", sqlAuthorizationRequired, null, roleDboOnly);
        this.doStmt("create role role", sqlAuthorizationRequired, null, roleDboOnly);
        this.doStmt("create role admin", sqlAuthorizationRequired, null, roleDboOnly);
        this.doStmt("create role \"NONE\"", sqlAuthorizationRequired, null, roleDboOnly);
        this.doStmt("create role foo", sqlAuthorizationRequired, objectAlreadyExists, roleDboOnly);
        this.doStmt("create role " + users[0], sqlAuthorizationRequired, objectAlreadyExists, roleDboOnly);
        this.doStmt("create role " + users[1], sqlAuthorizationRequired, objectAlreadyExists, roleDboOnly);
        this.doStmt("create role " + users[2], sqlAuthorizationRequired, objectAlreadyExists, roleDboOnly);
        this.doStmt("create role whoever", sqlAuthorizationRequired, objectAlreadyExists, roleDboOnly);
        this.doStmt("create role schemaowner", sqlAuthorizationRequired, objectAlreadyExists, roleDboOnly);
        this.testLoginWithUsernameWhichIsARole();
        this.doStmt("grant foo to authid", sqlAuthorizationRequired, null, roleDboOnly);
        this.doStmt("grant foo, role, bar to authid1, authid2, " + users[1], sqlAuthorizationRequired, null, roleDboOnly);
        this.doStmt("grant admin to authid", sqlAuthorizationRequired, null, invalidRole);
        this.doStmt("grant admin, foo to authid", sqlAuthorizationRequired, null, invalidRole);
        this.doStmt("grant admin, foo to public", sqlAuthorizationRequired, null, invalidRole);
        this.doStmt("grant admin to a,b,c", sqlAuthorizationRequired, null, invalidRole);
        this.doStmt("grant foo,bar to admin", sqlAuthorizationRequired, null, roleDboOnly);
        this.assertSysRolesRowCount(0, 24, 5);
        this.checkGrantCircularity();
        this.doStmt("set role foo", sqlAuthorizationRequired, null, null);
        this.doStmt("set role 'FOO'", sqlAuthorizationRequired, null, null);
        this.doStmt("set role none", sqlAuthorizationRequired, null, null);
        this.doDynamicSetRole(this._conn);
        this.doStmt("set role 'NONE'", sqlAuthorizationRequired, idParseError, idParseError);
        this.doStmt("set role 'none'", sqlAuthorizationRequired, idParseError, idParseError);
        this.doStmt("set role '\"NONE\"'", sqlAuthorizationRequired, null, invalidRole);
        this.doStmt("set role ' '", sqlAuthorizationRequired, idParseError, idParseError);
        this.doStmt("set role bar", sqlAuthorizationRequired, null, null);
        this.doStmt("set role notGranted", sqlAuthorizationRequired, null, invalidRole);
        this.doStmt("set role role", sqlAuthorizationRequired, null, invalidRole);
        this._conn.setAutoCommit(false);
        this.doStmt("select * from SYS.SYSROLES", null, null, null);
        this.doStmt("set role role", sqlAuthorizationRequired, notIdle, notIdle);
        this._conn.commit();
        this._conn.setAutoCommit(true);
        ResultSet resultSet = this.doQuery("values current_role", sqlAuthorizationRequired, null, null);
        this.assertRoleInRs(resultSet, "\"ROLE\"", "\"BAR\"");
        if (resultSet != null) {
            resultSet.close();
        }
        this.doStmt("revoke foo from authid", sqlAuthorizationRequired, null, roleDboOnly);
        this.doStmt("revoke foo, role, bar from authid1, authid2", sqlAuthorizationRequired, null, roleDboOnly);
        this.doStmt("revoke foo, role from " + users[1], sqlAuthorizationRequired, null, roleDboOnly);
        this.doStmt("revoke admin from authid", sqlAuthorizationRequired, null, invalidRole);
        this.doStmtWithWarnings("revoke admin from authid", new String[]{sqlAuthorizationRequired, null}, new String[]{null, revokeWarn}, new String[]{invalidRole, null}, false);
        this.doStmt("revoke admin, foo from authid", sqlAuthorizationRequired, null, invalidRole);
        this.doStmt("revoke admin from public", sqlAuthorizationRequired, null, invalidRole);
        this.doStmt("create table foo(str varchar(128) default current_role)", sqlAuthorizationRequired, null, null);
        this.doStmt("grant select, insert on foo to admin", sqlAuthorizationRequired, null, null);
        this.doStmt("grant select (str), update (str) on foo to admin", sqlAuthorizationRequired, null, null);
        this.doStmt("create function f1() returns int  language java parameter style java  external name 'org.apache.derbyTesting.functionTests.tests.lang.RolesTest.f1'  no sql called on null input", null, null, null);
        this.doStmt("grant execute on function f1 to admin", sqlAuthorizationRequired, null, null);
        this.assertSysTablePermsRowCount(0, 2, 1);
        this.assertSysColPermsRowCount(0, 2, 2);
        this.assertSysRoutinePermsRowCount(11, 12, 12);
        this.doStmt("drop role role", sqlAuthorizationRequired, null, roleDboOnly);
        this.doStmt("drop role admin", sqlAuthorizationRequired, null, roleDboOnly);
        this.assertSysTablePermsRowCount(0, 1, 1);
        this.assertSysColPermsRowCount(0, 0, 2);
        this.assertSysRoutinePermsRowCount(11, 11, 12);
        this.doStmt("drop role \"NONE\"", sqlAuthorizationRequired, null, roleDboOnly);
        this.doStmt("revoke select, insert on foo from admin", sqlAuthorizationRequired, null, null);
        this.doStmt("revoke select (str), update (str) on foo from admin", sqlAuthorizationRequired, null, null);
        this.doStmt("revoke execute on function f1 from admin restrict", sqlAuthorizationRequired, null, null);
        this.assertSysTablePermsRowCount(0, 1, 0);
        this.assertSysColPermsRowCount(0, 0, 0);
        this.assertSysRoutinePermsRowCount(11, 11, 11);
        this.assertSysRolesRowCount(0, 5, 5);
        this._stm.close();
        if (!JDBC.vmSupportsJSR169()) {
            this.testCurrentRoleIsReset();
        }
    }

    private void testLoginWithUsernameWhichIsARole() throws SQLException {
        if (this._authLevel == 1 && this.isDbo()) {
            this._stm.execute("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.user.soonarole', 'whatever')");
            this.openDefaultConnection("soonarole", "whatever").close();
            this._stm.execute("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.user.soonarole', NULL)");
            this._stm.execute("create role soonarole");
            this._stm.execute("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.user.soonarole', 'whatever')");
            try {
                this.openDefaultConnection("soonarole", "whatever").close();
                RolesTest.fail((String)"Exception expected connecting with user name equal to a role");
            }
            catch (SQLException sQLException) {
                RolesTest.assertSQLState(loginFailed, sQLException);
            }
            this._stm.execute("drop role soonarole");
            this._stm.execute("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.user.soonarole', NULL)");
        }
    }

    private void testCurrentRoleIsReset() throws SQLException {
        if (this._authLevel == 1 && this.isDbo()) {
            String string = "DonaldDuck".concat(pwSuffix);
            ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
            this.doTestCurrentRoleIsReset(connectionPoolDataSource.getPooledConnection("DonaldDuck", string), "DonaldDuck");
            if (RolesTest.usingDerbyNetClient()) {
                J2EEDataSource.setBeanProperty(connectionPoolDataSource, "maxStatements", 7);
                this.doTestCurrentRoleIsReset(connectionPoolDataSource.getPooledConnection("DonaldDuck", string), "DonaldDuck");
            }
        }
    }

    private void doTestCurrentRoleIsReset(PooledConnection pooledConnection, String string) throws SQLException {
        Connection connection = pooledConnection.getConnection();
        Statement statement = connection.createStatement();
        String string2 = null;
        JDBC.assertCurrentSchema(connection, string.toUpperCase());
        statement.execute("set role bar");
        ResultSet resultSet = statement.executeQuery("values current_role");
        this.assertRoleInRs(resultSet, "\"BAR\"", string2);
        resultSet.close();
        statement.close();
        connection.close();
        connection = pooledConnection.getConnection();
        statement = connection.createStatement();
        resultSet = statement.executeQuery("values current_role");
        this.assertRoleInRs(resultSet, null, string2);
        resultSet.close();
        statement.close();
        connection.close();
    }

    private void checkGrantCircularity() {
        if (this.isDbo()) {
            int n;
            String string = null;
            for (n = 1; n <= 8; ++n) {
                this.doStmt("create role s" + n, string, null, string);
            }
            this.doStmt("grant s1 to s2", string, null, string);
            this.doStmt("grant s3 to s1", string, null, string);
            this.doStmt("grant s1 to s4", string, null, string);
            this.doStmt("grant s4 to s2", string, null, string);
            this.doStmt("grant s4 to s6", string, null, string);
            this.doStmt("grant s4 to s5", string, null, string);
            this.doStmt("grant s6 to s7", string, null, string);
            this.doStmt("grant s8 to s4", string, null, string);
            this.doStmt("grant s1 to s1", string, roleGrantCircularity, string);
            this.doStmt("grant s2 to s3", string, roleGrantCircularity, string);
            this.doStmt("grant s2 to s8", string, roleGrantCircularity, string);
            this.doStmt("grant s7 to s1", string, roleGrantCircularity, string);
            this.doStmt("grant s7 to s4", string, roleGrantCircularity, string);
            this.doStmt("grant s7 to s6", string, roleGrantCircularity, string);
            this.doStmt("grant s7 to s3", string, roleGrantCircularity, string);
            this.doStmt("grant s2 to s1", string, roleGrantCircularity, string);
            this.doStmt("grant s2 to s8", string, roleGrantCircularity, string);
            this.doStmt("grant s2 to s4", string, roleGrantCircularity, string);
            this.doStmt("grant s6 to s1", string, roleGrantCircularity, string);
            this.doStmt("grant s6 to s8", string, roleGrantCircularity, string);
            this.doStmt("grant s6 to s3", string, roleGrantCircularity, string);
            this.doStmt("grant s6 to s4", string, roleGrantCircularity, string);
            this.doStmt("grant s5 to s1", string, roleGrantCircularity, string);
            this.doStmt("grant s5 to s3", string, roleGrantCircularity, string);
            this.doStmt("grant s5 to s4", string, roleGrantCircularity, string);
            this.doStmt("grant s5 to s8", string, roleGrantCircularity, string);
            for (n = 1; n <= 8; ++n) {
                this.doStmt("drop role s" + n, string, null, string);
            }
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        this._stm = this.createStatement();
        if (this._authLevel == 1 && this.isDbo()) {
            try {
                this._stm.executeUpdate("drop role foo");
                this._stm.executeUpdate("drop role bar");
                this._stm.executeUpdate("drop role notGranted");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        try {
            this._stm.executeUpdate("drop function f1");
            this._stm.executeUpdate("drop table foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (this._authLevel == 1 && this.isDbo()) {
            this._stm.executeUpdate("create table t1(i int)");
            this._stm.executeUpdate("grant select on t1 to whoever");
            this._stm.executeUpdate("create schema lingerSchema authorization schemaowner");
        }
        this._stm.close();
    }

    @Override
    protected void tearDown() throws Exception {
        if (this._authLevel == 1 && this.isDbo()) {
            this._stm = this.createStatement();
            try {
                this._stm.executeUpdate("revoke select on t1 from whoever");
                this._stm.executeUpdate("drop table t1");
                this._stm.executeUpdate("drop schema lingerSchema restrict");
            }
            catch (SQLException sQLException) {
                System.err.println("Test error + " + String.valueOf(sQLException));
            }
        }
        if (this._stm != null) {
            this._stm.close();
            this._stm = null;
        }
        if (this._conn != null) {
            this._conn = null;
        }
        super.tearDown();
    }

    private void doStmt(String string, String string2, String string3, String string4) {
        this.doStmt(string, string2, string3, string4, false);
    }

    private ResultSet doQuery(String string, String string2, String string3, String string4) {
        return this.doStmt(string, string2, string3, string4, true);
    }

    private ResultSet doStmt(String string, String string2, String string3, String string4, boolean bl) {
        return this.doStmtWithWarnings(string, new String[]{string2, null}, new String[]{string3, null}, new String[]{string4, null}, bl);
    }

    private ResultSet doStmtWithWarnings(String string, String[] stringArray, String[] stringArray2, String[] stringArray3, boolean bl) {
        ResultSet resultSet = null;
        try {
            if (bl) {
                resultSet = this._stm.executeQuery(string);
            } else {
                this._stm.execute(string);
            }
            if (this._authLevel == 0) {
                if (stringArray[0] != null) {
                    RolesTest.fail((String)("exception " + stringArray[0] + " expected: (" + string));
                }
                if (stringArray[1] != null) {
                    SQLWarning sQLWarning = this._stm.getWarnings();
                    RolesTest.assertNotNull((String)"Expected warning but found none", (Object)sQLWarning);
                    RolesTest.assertSQLState(stringArray[1], sQLWarning);
                }
            } else if (this.isDbo()) {
                if (stringArray2[0] != null) {
                    RolesTest.fail((String)("exception " + stringArray2[0] + " expected: (" + string));
                }
                if (stringArray2[1] != null) {
                    SQLWarning sQLWarning = this._stm.getWarnings();
                    RolesTest.assertNotNull((String)"Expected warning but found none", (Object)sQLWarning);
                    RolesTest.assertSQLState(stringArray2[1], sQLWarning);
                }
            } else {
                if (stringArray3[0] != null) {
                    RolesTest.fail((String)("exception " + stringArray3[0] + " expected: (" + string));
                }
                if (stringArray3[1] != null) {
                    SQLWarning sQLWarning = this._stm.getWarnings();
                    RolesTest.assertNotNull((String)"Expected warning but found none", (Object)sQLWarning);
                    RolesTest.assertSQLState(stringArray3[1], sQLWarning);
                }
            }
        }
        catch (SQLException sQLException) {
            if (this._authLevel == 0) {
                if (stringArray[0] == null) {
                    RolesTest.fail("stmt " + string + " failed with exception " + sQLException.getSQLState(), sQLException);
                } else {
                    RolesTest.assertSQLState("Stmt " + string, stringArray[0], sQLException);
                }
            }
            if (this.isDbo()) {
                if (stringArray2[0] == null) {
                    RolesTest.fail("stmt " + string + " failed with exception " + sQLException.getSQLState(), sQLException);
                } else {
                    RolesTest.assertSQLState("Stmt " + string, stringArray2[0], sQLException);
                }
            }
            if (stringArray3[0] == null) {
                RolesTest.fail("stmt " + string + " failed with exception " + sQLException.getSQLState(), sQLException);
            }
            RolesTest.assertSQLState("Stmt " + string, stringArray3[0], sQLException);
        }
        return resultSet;
    }

    private void doDynamicSetRole(Connection connection) {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("set role ?");
            if (this._authLevel == 0) {
                RolesTest.fail((String)"set role ? should have failed; no sqlAuthorization");
            }
        }
        catch (SQLException sQLException) {
            if (this._authLevel == 0) {
                RolesTest.assertSQLState(sqlAuthorizationRequired, sQLException);
                return;
            }
            RolesTest.fail("prepare of set role ? failed:" + String.valueOf(sQLException), sQLException);
        }
        try {
            preparedStatement.setString(1, "BAR");
            int n = preparedStatement.executeUpdate();
            RolesTest.assertEquals((String)"rowcount from set role ? not 0", (int)n, (int)0);
        }
        catch (SQLException sQLException) {
            RolesTest.fail("execute of set role ? failed: [foo]" + String.valueOf(sQLException), sQLException);
        }
        try {
            preparedStatement.setString(1, " BAR ");
            int n = preparedStatement.executeUpdate();
            RolesTest.assertEquals((String)"rowcount from set role ? not 0", (int)n, (int)0);
        }
        catch (SQLException sQLException) {
            RolesTest.fail("execute of set role ? failed: [foo]" + String.valueOf(sQLException), sQLException);
        }
        try {
            int n = connection.createStatement().executeUpdate("set role ' BAR '");
            RolesTest.assertEquals((String)"rowcount from set role ? not 0", (int)n, (int)0);
        }
        catch (SQLException sQLException) {
            RolesTest.fail("execute of set role ? failed: [foo]" + String.valueOf(sQLException), sQLException);
        }
        try {
            preparedStatement.setString(1, "");
            int n = preparedStatement.executeUpdate();
            RolesTest.fail((String)"Expected syntax error on identifier");
        }
        catch (SQLException sQLException) {
            RolesTest.assertSQLState(idParseError, sQLException);
        }
        try {
            preparedStatement.setString(1, " ");
            int n = preparedStatement.executeUpdate();
            RolesTest.fail((String)"Expected syntax error on identifier");
        }
        catch (SQLException sQLException) {
            RolesTest.assertSQLState(idParseError, sQLException);
        }
        try {
            preparedStatement.setString(1, null);
            int n = preparedStatement.executeUpdate();
            RolesTest.fail((String)"Expected syntax error on identifier");
        }
        catch (SQLException sQLException) {
            RolesTest.assertSQLState(idParseError, sQLException);
        }
        if (this.isDbo()) {
            int n;
            String string = null;
            try {
                preparedStatement.setString(1, "NONE");
                n = preparedStatement.executeUpdate();
                RolesTest.fail((String)"NONE should not be allowed as a dynamic parameter");
            }
            catch (SQLException sQLException) {
                RolesTest.assertSQLState(idParseError, sQLException);
            }
            try {
                preparedStatement.setString(1, "none");
                n = preparedStatement.executeUpdate();
                RolesTest.fail((String)"NONE should not be allowed as a dynamic parameter");
            }
            catch (SQLException sQLException) {
                RolesTest.assertSQLState(idParseError, sQLException);
            }
            try {
                preparedStatement.setString(1, "\"NONE\"");
                int n2 = preparedStatement.executeUpdate();
                RolesTest.assertEquals((String)"rowcount from set role ? not 0", (int)n2, (int)0);
                ResultSet resultSet = this.doQuery("values current_role", string, null, string);
                this.assertRoleInRs(resultSet, "\"NONE\"", string);
                resultSet.close();
            }
            catch (SQLException sQLException) {
                RolesTest.fail("execute of set role ? failed: [\"NONE\"] " + String.valueOf(sQLException), sQLException);
            }
        }
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void assertSystableRowCount(String string, int n, int n2, int n3) throws SQLException {
        ResultSet resultSet = this._stm.executeQuery("SELECT COUNT(*) FROM " + string);
        resultSet.next();
        RolesTest.assertEquals((String)(string + " (_authLevel == NO_SQLAUTHORIZATION) = " + (this._authLevel == 0) + ", isDbo() = " + this.isDbo() + ", row count:"), (int)(this._authLevel == 0 ? n : (this.isDbo() ? n2 : n3)), (int)resultSet.getInt(1));
        resultSet.close();
    }

    private void assertSysRolesRowCount(int n, int n2, int n3) throws SQLException {
        if (TestConfiguration.getCurrent().isVerbose()) {
            this.dumpSysRoles();
        }
        this.assertSystableRowCount("SYS.SYSROLES", n, n2, n3);
    }

    private void assertSysTablePermsRowCount(int n, int n2, int n3) throws SQLException {
        if (TestConfiguration.getCurrent().isVerbose()) {
            this.dumpSysTablePerms();
        }
        this.assertSystableRowCount("SYS.SYSTABLEPERMS", n, n2, n3);
    }

    private void assertSysColPermsRowCount(int n, int n2, int n3) throws SQLException {
        if (TestConfiguration.getCurrent().isVerbose()) {
            this.dumpSysColPerms();
        }
        this.assertSystableRowCount("SYS.SYSCOLPERMS", n, n2, n3);
    }

    private void assertSysRoutinePermsRowCount(int n, int n2, int n3) throws SQLException {
        if (TestConfiguration.getCurrent().isVerbose()) {
            this.dumpSysRoutinePerms();
        }
        this.assertSystableRowCount("SYS.SYSROUTINEPERMS", n, n2, n3);
    }

    private void dumpSysRoles() throws SQLException {
        ResultSet resultSet = this._stm.executeQuery("SELECT * FROM SYS.SYSROLES ORDER BY ROLEID");
        RolesTest.println("SYS.SYSROLES:");
        while (resultSet.next()) {
            RolesTest.println("uuid=" + resultSet.getString(1) + " r=" + resultSet.getString(2) + " -ee:" + resultSet.getString(3) + " -or:" + resultSet.getString(4) + " a:" + resultSet.getString(5) + " d:" + resultSet.getString(6));
        }
        resultSet.close();
    }

    private void dumpSysTablePerms() throws SQLException {
        ResultSet resultSet = this._stm.executeQuery("SELECT * FROM SYS.SYSTABLEPERMS");
        RolesTest.println("SYS.SYSTABLEPERMS:");
        while (resultSet.next()) {
            RolesTest.println("id: " + resultSet.getString(1) + " -ee:" + resultSet.getString(2) + " -or:" + resultSet.getString(3) + " tableid:" + resultSet.getString(4) + " S:" + resultSet.getString(5) + " D:" + resultSet.getString(6) + " I:" + resultSet.getString(7) + " U:" + resultSet.getString(8) + " R:" + resultSet.getString(9) + " T:" + resultSet.getString(10));
        }
        resultSet.close();
    }

    private void dumpSysColPerms() throws SQLException {
        ResultSet resultSet = this._stm.executeQuery("SELECT * FROM SYS.SYSCOLPERMS");
        RolesTest.println("SYS.SYSCOLPERMS:");
        while (resultSet.next()) {
            RolesTest.println("id: " + resultSet.getString(1) + " -ee:" + resultSet.getString(2) + " -or:" + resultSet.getString(3) + " tableid:" + resultSet.getString(4) + " type:" + resultSet.getString(5) + " col#:" + resultSet.getString(6));
        }
        resultSet.close();
    }

    private void dumpSysRoutinePerms() throws SQLException {
        ResultSet resultSet = this._stm.executeQuery("SELECT * FROM SYS.SYSROUTINEPERMS");
        RolesTest.println("SYS.SYSROUTINEPERMS:");
        while (resultSet.next()) {
            RolesTest.println("id: " + resultSet.getString(1) + " -ee:" + resultSet.getString(2) + " -or:" + resultSet.getString(3) + " alias:" + resultSet.getString(4) + " grantopt:" + resultSet.getString(5));
        }
        resultSet.close();
    }

    private void assertRoleInRs(ResultSet resultSet, String string, String string2) throws SQLException {
        if (this._authLevel == 0) {
            RolesTest.assertNull((Object)resultSet);
        } else if (this.isDbo()) {
            JDBC.assertSingleValueResultSet(resultSet, string);
        } else {
            JDBC.assertSingleValueResultSet(resultSet, string2);
        }
    }

    public static int f1() {
        return 1;
    }
}

