/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Locale;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.ProcedureTest;
import org.apache.derbyTesting.functionTests.util.TestUtil;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.LocaleTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class LangProcedureTest
extends BaseJDBCTestCase {
    private static final String LANG_STRING_TRUNCATION = "22001";
    private static final String LANG_INVALID_CALL_STATEMENT = "42X74";
    private final String thisClassName = ((Object)((Object)this)).getClass().getName();

    public LangProcedureTest(String string) {
        super(string);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public static Test suite() {
        if (JDBC.vmSupportsJSR169()) {
            return new BaseTestSuite("Empty LangProcedureTest. JSR169 does not support jdbc:default:connection");
        }
        return TestConfiguration.singleUseDatabaseDecorator((Test)new LocaleTestSetup(TestConfiguration.defaultSuite(LangProcedureTest.class), Locale.ENGLISH));
    }

    public void testCreateRoutineErrors() throws SQLException {
        Statement statement = this.createStatement();
        LangProcedureTest.assertStatementError("42Y04", statement, "create procedure asdf() language java external name 'asdfasdf' parameter style java");
        LangProcedureTest.assertStatementError("42Y04", statement, "create procedure asdf() language java external name 'asdfasdf.' parameter style java");
        LangProcedureTest.assertStatementError("42622", statement, "create procedure a23456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789() language java external name 'asdf.asdf' parameter style java");
        LangProcedureTest.assertStatementError("42X01", statement, "create procedure ASSEMBLY_PARTS (in ASSEMBLY_NUM integer, out NUM_PARTS integer, out COST DOUBLE) external name 'parts!assembly' dynamic result sets 1 language C parameter style GENERAL");
        LangProcedureTest.assertStatementError("42X62", statement, "create procedure sys.proc1() language java external name 'java.lang.System.gc' parameter style java");
        LangProcedureTest.assertStatementError("42613", statement, "create procedure noclass() language java external name 'asdf.asdf' parameter style java language java");
        LangProcedureTest.assertStatementError("42613", statement, "create procedure noclass() parameter style java language java external name 'asdf.asdf' parameter style java");
        LangProcedureTest.assertStatementError("42613", statement, "create procedure noclass() external name 'asdf.xxxx' language java external name 'asdf.asdf' parameter style java");
        LangProcedureTest.assertStatementError("42X01", statement, "create procedure noclass() parameter style java language java external name 'asdf.asdf' parameter style derby_rs_collection");
        LangProcedureTest.assertStatementError("42X01", statement, "create procedure missing01()");
        LangProcedureTest.assertStatementError("42X01", statement, "create procedure missing02() language java");
        LangProcedureTest.assertStatementError("42X01", statement, "create procedure missing03() language java parameter style java");
        LangProcedureTest.assertStatementError("42X01", statement, "create procedure missing04() language java external name 'foo.bar'");
        LangProcedureTest.assertStatementError("42X01", statement, "create procedure missing05() parameter style java");
        LangProcedureTest.assertStatementError("42X01", statement, "create procedure missing06() parameter style java external name 'foo.bar'");
        LangProcedureTest.assertStatementError("42X01", statement, "create procedure missing07() external name 'goo.bar'");
        LangProcedureTest.assertStatementError("42X01", statement, "create procedure missing08() dynamic result sets 1");
        LangProcedureTest.assertStatementError("0A000", statement, "create procedure missing09() specific name fred");
        LangProcedureTest.assertStatementError("42X01", statement, "create procedure nullinput2() returns null on null input language java parameter style java external name 'foo.bar'");
        LangProcedureTest.assertStatementError("42734", statement, "create procedure DUP_P1(in FRED int, out RON char(10), in FRED int) language java parameter style java external name 'no.dup1'");
        LangProcedureTest.assertStatementError("42734", statement, "create procedure D2.DUP_P2(in \"FreD\" int, out RON char(10), in \"FreD\" int) language java parameter style java external name 'no.dup2'");
        LangProcedureTest.assertStatementError("42734", statement, "create procedure D3.DUP_P3(in \"FRED\" int, out RON char(10), in fred int) language java parameter style java external name 'no.dup3'");
        statement.execute("create procedure DUP_POK(in \"FreD\" int, out RON char(10), in fred int) language java parameter style java external name 'no.dupok'");
        statement.execute("drop procedure DUP_POK");
        LangProcedureTest.assertStatementError("42Y03", statement, "call APP.NSP(?, ?)");
        LangProcedureTest.assertStatementError("42X15", statement, "call syscs_util.syscs_set_database_property(\"foo\", \"bar\")");
        this.assertCompileError(LANG_INVALID_CALL_STATEMENT, "call syscs_util.syscs_set_database_property('foo', (values 'bar'))");
        statement.close();
    }

    public void testMethodSignatureDerby258() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create procedure SIGNATURE_BUG_DERBY_258_A(in A int) language java parameter style java external name 'java.lang.System.load(java.lang.String)'");
        LangProcedureTest.assertStatementError("22005", statement, "call APP.SIGNATURE_BUG_DERBY_258_A(4)");
        statement.execute("drop PROCEDURE SIGNATURE_BUG_DERBY_258_A");
        statement.execute("create function SIGNATURE_BUG_DERBY_258_B(A int) RETURNS varchar(128) language java parameter style java external name 'java.lang.Integer.toString(int, int)'");
        LangProcedureTest.assertStatementError("46J02", statement, "values APP.SIGNATURE_BUG_DERBY_258_B(4)");
        statement.execute("drop FUNCTION SIGNATURE_BUG_DERBY_258_B");
        statement.execute("create procedure SIGNATURE_BUG_DERBY_258_C(in A int) language java parameter style java external name 'java.lang.System.gc()'");
        LangProcedureTest.assertStatementError("46J02", statement, "call APP.SIGNATURE_BUG_DERBY_258_C(4)");
        statement.execute("drop PROCEDURE SIGNATURE_BUG_DERBY_258_C");
        statement.execute("create procedure SIGNATURE_BUG_DERBY_258_F(in A int) language java parameter style java external name 'java.lang.System.gc('");
        LangProcedureTest.assertStatementError("46J01", statement, "call APP.SIGNATURE_BUG_DERBY_258_F(4)");
        statement.execute("drop PROCEDURE SIGNATURE_BUG_DERBY_258_F");
        statement.execute("create procedure SIGNATURE_BUG_DERBY_258_G(in A int) language java parameter style java external name 'java.lang.System.gc(,,)'");
        LangProcedureTest.assertStatementError("46J01", statement, "call APP.SIGNATURE_BUG_DERBY_258_G(4)");
        statement.execute("drop PROCEDURE SIGNATURE_BUG_DERBY_258_G");
        statement.execute("create procedure SIGNATURE_BUG_DERBY_258_H(in A int) language java parameter style java external name 'java.lang.System.gc(, ,)'");
        LangProcedureTest.assertStatementError("46J01", statement, "call APP.SIGNATURE_BUG_DERBY_258_H(4)");
        statement.execute("drop PROCEDURE SIGNATURE_BUG_DERBY_258_H");
        statement.execute("create procedure SIGNATURE_BUG_DERBY_258_I(in A int) language java parameter style java external name 'java.lang.System.gc(int ,)'");
        LangProcedureTest.assertStatementError("46J01", statement, "call APP.SIGNATURE_BUG_DERBY_258_I(4)");
        statement.execute("drop PROCEDURE SIGNATURE_BUG_DERBY_258_I");
        statement.execute("create procedure DERBY_3304()  dynamic result sets 1 language java parameter style java  external name '" + ((Object)((Object)this)).getClass().getName() + ".DERBY_3304' modifies sql data");
        String[][] stringArray = new String[][]{{"APP"}};
        ResultSet resultSet = statement.executeQuery("call APP.DERBY_3304()");
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.execute("drop PROCEDURE DERBY_3304");
        statement.close();
    }

    public static void DERBY_3304(ResultSet[] resultSetArray) throws SQLException {
        ResultSet resultSet;
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        Statement statement = connection.createStatement();
        connection.commit();
        resultSetArray[0] = resultSet = statement.executeQuery("values current_user");
    }

    public void testDelayedClassChecking() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create procedure noclass() language java external name 'asdf.asdf' parameter style java");
        statement.execute("create procedure nomethod() language java external name 'java.lang.Integer.asdf' parameter style java");
        statement.execute("create procedure notstatic() language java external name 'java.lang.Integer.equals' parameter style java");
        statement.execute("create procedure notvoid() language java external name 'java.lang.Runtime.getRuntime' parameter style java");
        this.assertCallError("42X51", "call noclass()");
        this.assertCallError("42X50", "call nomethod()");
        this.assertCallError("42X50", "call notstatic()");
        this.assertCallError("42X50", "call notvoid()");
        statement.execute("drop procedure noclass");
        statement.execute("drop procedure nomethod");
        statement.execute("drop procedure notstatic");
        statement.execute("drop procedure notvoid");
        statement.close();
    }

    public void testDuplicates() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = this.createStatement();
        statement.execute("create schema S1");
        statement.execute("create schema S2");
        statement.execute("create procedure    PROCDUP() language java external name 'okAPP.ok0' parameter style java");
        statement.execute("create procedure s1.PROCDUP() language java external name 'oks1.ok0' parameter style java");
        statement.execute("create procedure s2.PROCDUP() language java external name 'oks2.ok0' parameter style java");
        LangProcedureTest.assertStatementError("X0Y68", statement, "create procedure PROCDUP() language java external name 'failAPP.fail0' parameter style java");
        LangProcedureTest.assertStatementError("X0Y68", statement, "create procedure s1.PROCDUP() language java external name 'fails1.fail0' parameter style java");
        LangProcedureTest.assertStatementError("X0Y68", statement, "create procedure s2.PROCDUP() language java external name 'fails2.fail0' parameter style java");
        String[] stringArray = new String[]{"APP.PROCDUP AS okAPP.ok0() LANGUAGE JAVA PARAMETER STYLE JAVA MODIFIES SQL DATA", "S1.PROCDUP AS oks1.ok0() LANGUAGE JAVA PARAMETER STYLE JAVA MODIFIES SQL DATA", "S2.PROCDUP AS oks2.ok0() LANGUAGE JAVA PARAMETER STYLE JAVA MODIFIES SQL DATA"};
        String[] stringArray2 = new String[]{"APP.PROCDUP AS okAPP.ok0 type procedureNoResult", "S1.PROCDUP AS oks1.ok0 type procedureNoResult", "S2.PROCDUP AS oks2.ok0 type procedureNoResult"};
        LangProcedureTest.checkMatchingProcedures(connection, "PROCDUP", stringArray, stringArray2, null);
        LangProcedureTest.assertStatementError("0A000", statement, "create procedure S1.NOTYET() SPECIFIC fred language java external name 'failAPP.fail0' parameter style java");
        statement.execute("drop procedure PROCDUP");
        statement.execute("drop procedure s1.PROCDUP");
        statement.execute("drop procedure s2.PROCDUP");
        statement.execute("drop schema S1 RESTRICT");
        statement.execute("drop schema S2 RESTRICT");
        statement.close();
    }

    public void testAmbigiousMethods() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create procedure ambiguous01(p1 integer, p2 char(20)) dynamic result sets 1 language java parameter style java external name '" + this.thisClassName + ".ambiguous1'");
        this.assertCallError("42X73", "call AMBIGUOUS01(?, ?)");
        statement.execute("drop procedure AMBIGUOUS01");
        statement.execute("create procedure ambiguous02(p1 integer, p2 integer) dynamic result sets 1 language java parameter style java external name '" + this.thisClassName + ".ambiguous2'");
        this.assertCallError("42X50", "call AMBIGUOUS02(?, ?)");
        statement.execute("drop procedure AMBIGUOUS02");
        statement.execute("create procedure ambiguous03(p1 integer, p2 integer) dynamic result sets 1 language java parameter style java external name '" + this.thisClassName + ".ambiguous2(int,java.lang.Integer)'");
        this.assertCallError("42X73", "{call ambiguous03(1,NULL)}");
        statement.execute("drop procedure AMBIGUOUS03");
        statement.execute("create procedure ambiguous04(p1 integer, p2 integer) dynamic result sets 1 language java parameter style java external name '" + this.thisClassName + ".ambiguous2(java.lang.Integer,int)'");
        this.assertCallError("42X73", "{call ambiguous04(NULL, 1)}");
        statement.execute("drop procedure AMBIGUOUS04");
        statement.close();
    }

    private static void checkMatchingProcedures(Connection connection, String string, String[] stringArray, String[] stringArray2, String[] stringArray3) throws SQLException {
        boolean bl = connection.getAutoCommit();
        connection.setAutoCommit(false);
        PreparedStatement preparedStatement = connection.prepareStatement("select schemaname, alias,     cast (((javaclassname || '.' ) ||     cast (aliasinfo as varchar(1000))) as varchar(2000))        as signature from sys.sysaliases A, sys.sysschemas S where alias like ? and A.schemaid = S.schemaid order by 1,2,3");
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        int n = 0;
        while (resultSet.next()) {
            LangProcedureTest.assertEquals((String)stringArray[n++], (String)(resultSet.getString(1) + "." + resultSet.getString(2) + " AS " + resultSet.getString(3)));
        }
        resultSet.close();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        resultSet = databaseMetaData.getProcedures(null, null, string);
        n = 0;
        while (resultSet.next()) {
            String string2 = resultSet.getString(2);
            String string3 = resultSet.getString(3);
            LangProcedureTest.assertEquals((String)(string2 + "." + string3 + " AS " + resultSet.getString(7) + " type " + LangProcedureTest.TYPE(resultSet.getShort(8))), (String)stringArray2[n++]);
            ResultSet resultSet2 = databaseMetaData.getProcedureColumns(null, string2, string3, null);
            int n2 = 0;
            while (resultSet2.next()) {
                LangProcedureTest.assertEquals((String)(LangProcedureTest.PARAMTYPE(resultSet2.getShort(5)) + " " + resultSet2.getString(4) + " " + resultSet2.getString(7)), (String)stringArray3[n2++]);
            }
            resultSet2.close();
        }
        resultSet.close();
        connection.setAutoCommit(bl);
    }

    public void testZeroArgProcedures() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = this.createStatement();
        statement.execute("create procedure za() language java external name '" + this.thisClassName + ".zeroArg' parameter style java");
        statement.execute("call za()");
        this.assertUpdateCountForProcedureWithNoResults(statement);
        PreparedStatement preparedStatement = this.prepareStatement("call za()");
        preparedStatement.execute();
        this.assertUpdateCountForProcedureWithNoResults(preparedStatement);
        preparedStatement.close();
        preparedStatement = this.prepareStatement("{call za()}");
        preparedStatement.execute();
        this.assertUpdateCountForProcedureWithNoResults(preparedStatement);
        preparedStatement.close();
        try {
            this.prepareStatement("call za(?)");
            LangProcedureTest.fail((String)"FAIL - prepareStatement call za(?)");
        }
        catch (SQLException sQLException) {
            LangProcedureTest.assertSQLState("42Y03", sQLException);
        }
        CallableStatement callableStatement = this.prepareCall("call za()");
        callableStatement.execute();
        this.assertUpdateCountForProcedureWithNoResults(callableStatement);
        callableStatement.close();
        callableStatement = this.prepareCall("{call za()}");
        callableStatement.execute();
        this.assertUpdateCountForProcedureWithNoResults(callableStatement);
        callableStatement.close();
        String[] stringArray = new String[]{"APP.ZA AS " + this.thisClassName + ".zeroArg() LANGUAGE JAVA PARAMETER STYLE JAVA MODIFIES SQL DATA"};
        String[] stringArray2 = new String[]{"APP.ZA AS " + this.thisClassName + ".zeroArg type procedureNoResult"};
        LangProcedureTest.checkMatchingProcedures(connection, "ZA", stringArray, stringArray2, null);
        statement.execute("drop procedure za");
        LangProcedureTest.checkMatchingProcedures(connection, "ZA", null, null, null);
        statement.close();
    }

    public void testSqlProcedures() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = this.createStatement();
        statement.execute("create table t1(i int not null primary key, b char(15))");
        statement.execute("create procedure ir(p1 int) modifies sql data dynamic result sets 0 language java external name '" + this.thisClassName + ".insertRow' parameter style java");
        statement.execute("create procedure ir2(p1 int, p2 char(10))  modifies sql data language java external name '" + this.thisClassName + ".insertRow' parameter style java");
        String[] stringArray = new String[]{"APP.IR AS " + this.thisClassName + ".insertRow(IN \"P1\" INTEGER) LANGUAGE JAVA PARAMETER STYLE JAVA MODIFIES SQL DATA"};
        String[] stringArray2 = new String[]{"APP.IR AS " + this.thisClassName + ".insertRow type procedureNoResult"};
        String[] stringArray3 = new String[]{"procedureColumnIn P1 INTEGER"};
        LangProcedureTest.checkMatchingProcedures(connection, "IR", stringArray, stringArray2, stringArray3);
        stringArray = new String[]{"APP.IR2 AS " + this.thisClassName + ".insertRow(IN \"P1\" INTEGER,IN \"P2\" CHAR(10)) LANGUAGE JAVA PARAMETER STYLE JAVA MODIFIES SQL DATA"};
        stringArray2 = new String[]{"APP.IR2 AS " + this.thisClassName + ".insertRow type procedureNoResult"};
        stringArray3 = new String[]{"procedureColumnIn P1 INTEGER", "procedureColumnIn P2 CHAR"};
        LangProcedureTest.checkMatchingProcedures(connection, "IR2", stringArray, stringArray2, stringArray3);
        this.assertCallError("42Y03", "call IR()");
        CallableStatement callableStatement = this.prepareCall("call IR(?)");
        callableStatement.setInt(1, 1);
        callableStatement.execute();
        callableStatement.setInt(1, 2);
        callableStatement.execute();
        try {
            callableStatement.execute();
            LangProcedureTest.fail((String)"FAIL - duplicate key insertion through ir");
        }
        catch (SQLException sQLException) {
            LangProcedureTest.assertSQLState("23505", sQLException);
        }
        callableStatement.setString(1, "3");
        callableStatement.execute();
        callableStatement.close();
        callableStatement = connection.prepareCall("call APP.IR(?)");
        callableStatement.setInt(1, 7);
        callableStatement.execute();
        CallableStatement callableStatement2 = connection.prepareCall("call IR2(?, ?)");
        callableStatement2.setInt(1, 4);
        callableStatement2.setInt(2, 4);
        callableStatement2.execute();
        callableStatement2.setInt(1, 5);
        callableStatement2.setString(2, "ir2");
        callableStatement2.execute();
        callableStatement2.setInt(1, 6);
        callableStatement2.setString(2, "'012345678");
        callableStatement2.execute();
        callableStatement.close();
        callableStatement2.close();
        if (!connection.getAutoCommit()) {
            connection.commit();
        }
        String[][] stringArray4 = new String[][]{{"1", "int"}, {"2", "int"}, {"3", "int"}, {"7", "int"}, {"4", "4"}, {"5", "ir2"}, {"6", "'012345678"}};
        ResultSet resultSet = statement.executeQuery("select * from t1");
        JDBC.assertFullResultSet(resultSet, stringArray4);
        if (!connection.getAutoCommit()) {
            connection.commit();
        }
        this.assertCallError("38000", "call IR2(2, 'no way')");
        this.assertCallError("07000", "call IR2(?, 'no way')");
        this.assertCallError("07000", "call IR2(2, ?)");
        statement.execute("drop procedure IR");
        statement.execute("drop procedure IR2");
        statement.execute("drop table t1");
        this.commit();
    }

    public void testDynamicResultSets() throws SQLException {
        Connection connection = this.getConnection();
        Connection connection2 = this.openDefaultConnection();
        Statement statement = this.createStatement();
        LangProcedureTest.assertStatementError("42X01", statement, "create procedure DRS(p1 int) parameter style java reads sql data dynamic result sets -1 language java external name '" + this.thisClassName + ".selectRows'");
        statement.execute("create procedure DRS(p1 int) parameter style java reads sql data dynamic result sets 1 language java external name '" + this.thisClassName + ".selectRows'");
        statement.execute("create table t1(i int not null primary key, b char(15))");
        statement.execute("insert into t1 values (1, 'int'), (2, 'int'), (3, 'int'), (7, 'int'), (4, '4'), (5, 'ir2'), (6, '''012345678')");
        String[] stringArray = new String[]{"APP.DRS AS " + this.thisClassName + ".selectRows(IN \"P1\" INTEGER) LANGUAGE JAVA PARAMETER STYLE JAVA READS SQL DATA DYNAMIC RESULT SETS 1"};
        String[] stringArray2 = new String[]{"APP.DRS AS " + this.thisClassName + ".selectRows type procedureNoResult"};
        String[] stringArray3 = new String[]{"procedureColumnIn P1 INTEGER"};
        LangProcedureTest.checkMatchingProcedures(connection, "DRS", stringArray, stringArray2, stringArray3);
        this.assertCallError("42Y03", "call DRS()");
        this.assertCallError("42Y03", "call DRS(?,?)");
        CallableStatement callableStatement = this.prepareCall("call DRS(?)");
        callableStatement.setInt(1, 3);
        callableStatement.execute();
        ResultSet resultSet = callableStatement.getResultSet();
        String[][] stringArray4 = new String[][]{{"3", "int"}};
        JDBC.assertFullResultSet(resultSet, stringArray4);
        callableStatement.close();
        statement.execute("create procedure DRS2(p1 int, p2 int) parameter style java reads sql data dynamic result sets 2 language java external name '" + this.thisClassName + ".selectRows'");
        stringArray = new String[]{"APP.DRS2 AS " + this.thisClassName + ".selectRows(IN \"P1\" INTEGER,IN \"P2\" INTEGER) LANGUAGE JAVA PARAMETER STYLE JAVA READS SQL DATA DYNAMIC RESULT SETS 2"};
        stringArray2 = new String[]{"APP.DRS2 AS " + this.thisClassName + ".selectRows type procedureNoResult"};
        stringArray3 = new String[]{"procedureColumnIn P1 INTEGER", "procedureColumnIn P2 INTEGER"};
        LangProcedureTest.checkMatchingProcedures(connection, "DRS2", stringArray, stringArray2, stringArray3);
        CallableStatement callableStatement2 = connection.prepareCall("call DRS2(?, ?)");
        callableStatement2.setInt(1, 2);
        callableStatement2.setInt(2, 6);
        callableStatement2.execute();
        resultSet = callableStatement2.getResultSet();
        String[][] stringArray5 = new String[][]{{"2", "int"}};
        JDBC.assertFullResultSet(resultSet, stringArray5);
        LangProcedureTest.assertTrue((boolean)callableStatement2.getMoreResults());
        stringArray5 = new String[][]{{"6", "'012345678"}, {"7", "int"}};
        resultSet = callableStatement2.getResultSet();
        JDBC.assertFullResultSet(resultSet, stringArray5);
        callableStatement2.setInt(1, 2);
        callableStatement2.setInt(2, 99);
        LangProcedureTest.assertTrue((boolean)callableStatement2.execute());
        resultSet = callableStatement2.getResultSet();
        stringArray5 = new String[][]{{"2", "int"}};
        JDBC.assertFullResultSet(resultSet, stringArray5);
        LangProcedureTest.assertFalse((boolean)callableStatement2.getMoreResults());
        callableStatement2.setInt(1, 2);
        callableStatement2.setInt(2, 199);
        LangProcedureTest.assertFalse((boolean)callableStatement2.execute());
        LangProcedureTest.assertFalse((boolean)callableStatement2.getMoreResults());
        callableStatement2.setInt(1, 2);
        callableStatement2.setInt(2, 299);
        LangProcedureTest.assertTrue((boolean)callableStatement2.execute());
        stringArray5 = new String[][]{{"2", "int"}};
        resultSet = callableStatement2.getResultSet();
        JDBC.assertFullResultSet(resultSet, stringArray5);
        LangProcedureTest.assertTrue((boolean)callableStatement2.getMoreResults());
        resultSet = callableStatement2.getResultSet();
        JDBC.assertEmpty(resultSet);
        callableStatement2.setInt(1, 2);
        callableStatement2.setInt(2, 2);
        callableStatement2.execute();
        ResultSet resultSet2 = null;
        int n = 1;
        do {
            if (resultSet2 != null) {
                try {
                    resultSet2.next();
                    LangProcedureTest.fail((String)"FAILED - result set should be closed");
                }
                catch (SQLException sQLException) {
                    LangProcedureTest.assertSQLState("XCL16", sQLException);
                }
            }
            resultSet2 = callableStatement2.getResultSet();
            if (n == 1 || n == 2) {
                LangProcedureTest.assertNotNull((String)("expected resultset pass " + n), (Object)resultSet2);
            } else if (n == 3) {
                LangProcedureTest.assertNull((Object)resultSet2);
            }
            ++n;
        } while (callableStatement2.getMoreResults() || resultSet2 != null);
        LangProcedureTest.checkCommitWithMultipleResultSets(callableStatement2, connection2, "autocommit");
        LangProcedureTest.checkCommitWithMultipleResultSets(callableStatement2, connection2, "noautocommit");
        LangProcedureTest.checkCommitWithMultipleResultSets(callableStatement2, connection2, "statement");
        callableStatement2.close();
        callableStatement2 = connection.prepareCall("{call DRS2(?, ?)}");
        callableStatement2.setInt(1, 2);
        callableStatement2.setInt(2, 6);
        callableStatement2.execute();
        resultSet = callableStatement2.getResultSet();
        String[][] stringArray6 = new String[][]{{"2", "int"}};
        JDBC.assertFullResultSet(resultSet, stringArray6);
        callableStatement2.close();
        statement.execute("create procedure irdrs(p1 int) dynamic result sets 1 language java parameter style java external name '" + this.thisClassName + ".missingDynamicParameter'");
        this.assertCallError("42X50", "call IRDRS(?)");
        statement.execute("drop procedure irdrs");
        statement.execute("create procedure rsi(p1 int) dynamic result sets 1 language java parameter style java external name 'org.apache.derbyTesting.functionTests.util.ProcedureTest.badDynamicParameter'");
        this.assertCallError("42X50", "call rsi(?)");
        statement.execute("drop procedure rsi");
        statement.execute("create procedure zadrs() dynamic result sets 4 language java parameter style java external name '" + this.thisClassName + ".zeroArgDynamicResult'");
        CallableStatement callableStatement3 = connection.prepareCall("call ZADRS()");
        callableStatement3.execute();
        if (LangProcedureTest.usingEmbedded()) {
            LangProcedureTest.assertEquals((int)0, (int)callableStatement3.getUpdateCount());
        } else {
            LangProcedureTest.assertEquals((int)-1, (int)callableStatement3.getUpdateCount());
        }
        callableStatement3.close();
        statement.execute("drop procedure ZADRS");
        statement.execute("create procedure way.toomany(p1 int, p2 int) reads sql data dynamic result sets 1 language java parameter style java external name '" + this.thisClassName + ".selectRows'");
        CallableStatement callableStatement4 = connection.prepareCall("call way.toomany(?, ?)");
        callableStatement4.setInt(1, 2);
        callableStatement4.setInt(2, 6);
        callableStatement4.execute();
        SQLWarning sQLWarning = callableStatement4.getWarnings();
        if (LangProcedureTest.usingEmbedded()) {
            LangProcedureTest.assertNotNull((Object)sQLWarning);
            LangProcedureTest.assertEquals((String)"0100E", (String)sQLWarning.getSQLState());
        }
        resultSet = callableStatement4.getResultSet();
        JDBC.assertFullResultSet(resultSet, new String[][]{{"2", "int"}});
        JDBC.assertNoMoreResults(callableStatement4);
        callableStatement4.setInt(1, 2);
        callableStatement4.setInt(2, 99);
        callableStatement4.execute();
        resultSet = callableStatement4.getResultSet();
        JDBC.assertNoWarnings(callableStatement4.getWarnings());
        JDBC.assertFullResultSet(resultSet, new String[][]{{"2", "int"}});
        JDBC.assertNoMoreResults(callableStatement4);
        callableStatement4.close();
        statement.execute("drop procedure way.toomany");
        statement.execute("drop schema way restrict");
        if (LangProcedureTest.usingEmbedded()) {
            boolean bl = connection.getAutoCommit();
            statement.execute("create table dellater1(i int not null primary key,                        b char(15))");
            statement.executeUpdate("insert into dellater1     values(1,'a'),(2,'b'),(3,'c'),(4,'d')");
            statement.executeUpdate("create table dellater2(c11 int)");
            statement.executeUpdate("insert into dellater2 values(1),(2),(3),(4)");
            connection.setAutoCommit(false);
            ResultSet resultSet3 = statement.executeQuery("select * from dellater2");
            resultSet3.next();
            Statement statement2 = connection.createStatement(1003, 1007, 1);
            ResultSet resultSet4 = statement2.executeQuery("values (1, 2), (3, 4)");
            resultSet4.next();
            statement.execute("create procedure procWithRollback(p1 int) parameter style java reads sql data dynamic result sets 1 language java external name '" + this.thisClassName + ".rollbackInsideProc'");
            callableStatement = this.prepareCall("call procWithRollback(3)");
            callableStatement.execute();
            JDBC.assertNoMoreResults(callableStatement);
            JDBC.assertClosed(resultSet3);
            JDBC.assertClosed(resultSet4);
            statement.execute("create procedure procWithRollbackAnd2Resulsets(p1 int) parameter style java reads sql data dynamic result sets 2 language java external name '" + this.thisClassName + ".rollbackInsideProcWith2ResultSets'");
            callableStatement = this.prepareCall("call procWithRollbackAnd2Resulsets(3)");
            callableStatement.execute();
            resultSet = callableStatement.getResultSet();
            JDBC.assertDrainResults(resultSet);
            JDBC.assertNoMoreResults(callableStatement);
            statement.execute("create procedure insertCausingRollback(p1 int, p2 char(20))  modifies sql data dynamic result sets 1 language java external name '" + this.thisClassName + ".insertCausingRollback' parameter style java");
            statement.executeUpdate("create table DELLATER3(c31 int)");
            statement.executeUpdate("insert into DELLATER3 values(1),(2),(3),(4)");
            connection.commit();
            callableStatement = this.prepareCall("call insertCausingRollback(3,'3')");
            LangProcedureTest.assertStatementError("23505", callableStatement);
            JDBC.assertNoMoreResults(callableStatement);
            statement.execute("drop table DELLATER1");
            statement.execute("drop table DELLATER2");
            statement.execute("drop table DELLATER3");
            statement.execute("drop procedure insertCausingRollback");
            connection.setAutoCommit(bl);
        }
        statement.execute("drop procedure drs");
        statement.execute("drop procedure drs2");
        statement.execute("drop table t1");
        this.commit();
        connection2.close();
    }

    public void testResultSetsWithLobs() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = this.createStatement();
        statement.execute("create table lobCheckOne (c clob(30))");
        statement.execute("insert into lobCheckOne values (cast ('yayorsomething' as clob(30)))");
        statement.execute("insert into lobCheckOne values (cast ('yayorsomething2' as clob(30)))");
        statement.execute("create procedure clobproc () parameter style java language java dynamic result sets 3 reads sql data external name 'org.apache.derbyTesting.functionTests.util.ProcedureTest.clobselect'");
        statement.execute("create table lobCheckTwo (b blob(30))");
        statement.execute("insert into lobCheckTwo values (cast (" + TestUtil.stringToHexLiteral("101010001101") + " as blob(30)))");
        statement.execute("insert into lobCheckTwo values (cast (" + TestUtil.stringToHexLiteral("101010001101") + " as blob(30)))");
        statement.execute("create procedure blobproc () parameter style java language java external name 'org.apache.derbyTesting.functionTests.util.ProcedureTest.blobselect' dynamic result sets 1 reads sql data");
        CallableStatement callableStatement = connection.prepareCall("call clobproc()");
        callableStatement.execute();
        ResultSet resultSet = callableStatement.getResultSet();
        JDBC.assertFullResultSet(resultSet, new String[][]{{"yayorsomething"}, {"yayorsomething2"}});
        callableStatement.close();
        callableStatement = connection.prepareCall("call blobproc()");
        callableStatement.execute();
        resultSet = callableStatement.getResultSet();
        String[][] stringArray = new String[][]{{"003100300031003000310030003000300031003100300031"}, {"003100300031003000310030003000300031003100300031"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        callableStatement.close();
        statement.execute("drop table lobCheckOne");
        statement.execute("drop table lobCheckTwo");
        statement.execute("drop procedure clobproc");
        statement.execute("drop procedure blobproc");
        statement.close();
    }

    private static void checkCommitWithMultipleResultSets(CallableStatement callableStatement, Connection connection, String string) throws SQLException {
        Connection connection2 = callableStatement.getConnection();
        if (LangProcedureTest.usingDerbyNetClient()) {
            return;
        }
        try {
            connection2.setHoldability(2);
        }
        catch (Exception exception) {
            LangProcedureTest.fail((String)("shouldn't get that error " + exception.getMessage()));
        }
        int n = connection2.getTransactionIsolation();
        boolean bl = connection2.getAutoCommit();
        if (string.equals("noautocommit")) {
            connection2.setAutoCommit(false);
        } else {
            connection2.setAutoCommit(true);
        }
        connection2.setTransactionIsolation(8);
        if (string.equals("noautocommit")) {
            LangProcedureTest.assertFalse((boolean)connection2.getAutoCommit());
        } else {
            LangProcedureTest.assertTrue((boolean)connection2.getAutoCommit());
        }
        PreparedStatement preparedStatement = connection.prepareStatement("select count(*) from SYSCS_DIAG.LOCK_TABLE AS LT");
        ResultSet resultSet = preparedStatement.executeQuery();
        JDBC.assertFullResultSet(resultSet, new String[][]{{"0"}});
        callableStatement.execute();
        resultSet = preparedStatement.executeQuery();
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1"}});
        ResultSet resultSet2 = callableStatement.getResultSet();
        resultSet2.next();
        resultSet = preparedStatement.executeQuery();
        JDBC.assertFullResultSet(resultSet, new String[][]{{"2"}});
        boolean bl2 = false;
        if (string.equals("statement")) {
            connection2.createStatement().executeQuery("values 1").next();
            bl2 = true;
            resultSet = preparedStatement.executeQuery();
            JDBC.assertFullResultSet(resultSet, new String[][]{{"0"}});
            try {
                resultSet2.next();
                if (string.equals("autocommit")) {
                    LangProcedureTest.fail((String)"FAIL - result set open in auto commit mode after another statement execution");
                }
            }
            catch (SQLException sQLException) {
                LangProcedureTest.assertSQLState("XCL16", sQLException);
            }
        }
        boolean bl3 = callableStatement.getMoreResults();
        LangProcedureTest.assertTrue((String)"is there a second result", (boolean)bl3);
        resultSet = preparedStatement.executeQuery();
        if (string.equals("statement")) {
            JDBC.assertFullResultSet(resultSet, new String[][]{{"0"}});
        } else {
            JDBC.assertFullResultSet(resultSet, new String[][]{{"2"}});
        }
        if (bl3) {
            resultSet2 = callableStatement.getResultSet();
            try {
                resultSet2.next();
                if (bl2 && !LangProcedureTest.usingDerbyNetClient()) {
                    LangProcedureTest.fail((String)"FAIL - result set open in auto commit mode after another statement execution");
                }
            }
            catch (SQLException sQLException) {
                if (bl2) {
                    LangProcedureTest.assertSQLState("XCL16", sQLException);
                }
                throw sQLException;
            }
            resultSet = preparedStatement.executeQuery();
            if (string.equals("statement")) {
                JDBC.assertFullResultSet(resultSet, new String[][]{{"0"}});
            } else {
                JDBC.assertFullResultSet(resultSet, new String[][]{{"7"}});
            }
            boolean bl4 = callableStatement.getMoreResults();
            LangProcedureTest.assertFalse((String)"more results (should be false) ", (boolean)bl4);
            resultSet = preparedStatement.executeQuery();
            if (string.equals("autocommit") || string.equals("statement")) {
                JDBC.assertFullResultSet(resultSet, new String[][]{{"0"}});
            } else {
                JDBC.assertFullResultSet(resultSet, new String[][]{{"7"}});
            }
            connection2.setTransactionIsolation(n);
            connection2.setAutoCommit(bl);
        }
        preparedStatement.close();
    }

    private void assertUpdateCountForProcedureWithNoResults(Statement statement) throws SQLException {
        if (LangProcedureTest.usingEmbedded()) {
            LangProcedureTest.assertEquals((int)0, (int)statement.getUpdateCount());
        } else {
            LangProcedureTest.assertEquals((int)-1, (int)statement.getUpdateCount());
        }
    }

    static String TYPE(short s) {
        switch (s) {
            case 0: {
                return "procedureResultUnknown";
            }
            case 1: {
                return "procedureNoResult";
            }
            case 2: {
                return "procedureReturnsResult";
            }
        }
        return "??????";
    }

    static String PARAMTYPE(short s) {
        switch (s) {
            case 0: {
                return "procedureColumnUnknown";
            }
            case 1: {
                return "procedureColumnIn";
            }
            case 2: {
                return "procedureColumnInOut";
            }
            case 4: {
                return "procedureColumnOut";
            }
            case 5: {
                return "procedureColumnReturn";
            }
            case 3: {
                return "procedureColumnResult";
            }
        }
        return "???";
    }

    public static void ambiguous1(int n, String string, ResultSet[] resultSetArray, ResultSet[] resultSetArray2) {
    }

    public static void ambiguous1(int n, String string, ResultSet[] resultSetArray) {
    }

    public static void ambiguous2(int n, Integer n2) {
    }

    public static void ambiguous2(Integer n, int n2) {
    }

    public static void zeroArg() {
    }

    public static void insertRow(int n) throws SQLException {
        LangProcedureTest.insertRow(n, "int");
    }

    public static void insertRow(int n, String string) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into t1 values (?, ?)");
        preparedStatement.setInt(1, n);
        preparedStatement.setString(2, string);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        connection.close();
    }

    public static void selectRows(int n, ResultSet[] resultSetArray) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = connection.prepareStatement("select * from t1 where i = ?");
        preparedStatement.setInt(1, n);
        resultSetArray[0] = preparedStatement.executeQuery();
        connection.close();
    }

    public static void rollbackInsideProc(int n, ResultSet[] resultSetArray) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = connection.prepareStatement("select * from dellater1 where i = ?");
        preparedStatement.setInt(1, n);
        resultSetArray[0] = preparedStatement.executeQuery();
        connection.rollback();
        connection.close();
    }

    public static void rollbackInsideProcWith2ResultSets(int n, ResultSet[] resultSetArray, ResultSet[] resultSetArray2) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = connection.prepareStatement("select * from t1 where i = ?");
        preparedStatement.setInt(1, n);
        resultSetArray[0] = preparedStatement.executeQuery();
        connection.rollback();
        preparedStatement = connection.prepareStatement("select * from dellater1 where i = ?");
        preparedStatement.setInt(1, n);
        resultSetArray2[0] = preparedStatement.executeQuery();
        connection.close();
    }

    public static void insertCausingRollback(int n, String string, ResultSet[] resultSetArray) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = connection.prepareStatement("select * from dellater2 where c11 = ?");
        preparedStatement.setInt(1, n);
        resultSetArray[0] = preparedStatement.executeQuery();
        PreparedStatement preparedStatement2 = connection.prepareStatement("select * from dellater3 where c31 = ?");
        preparedStatement2.setInt(1, n);
        ResultSet resultSet = preparedStatement2.executeQuery();
        resultSet.close();
        PreparedStatement preparedStatement3 = connection.prepareStatement("insert into dellater1 values (?, ?)");
        preparedStatement3.setInt(1, n);
        preparedStatement3.setString(2, string);
        preparedStatement3.executeUpdate();
        preparedStatement3.close();
        connection.close();
    }

    public static void selectRows(int n, int n2, ResultSet[] resultSetArray, ResultSet[] resultSetArray2) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = connection.prepareStatement("select * from t1 where i = ?");
        preparedStatement.setInt(1, n);
        resultSetArray[0] = preparedStatement.executeQuery();
        preparedStatement = connection.prepareStatement("select * from t1 where i >= ?");
        preparedStatement.setInt(1, n2);
        resultSetArray2[0] = preparedStatement.executeQuery();
        if (n2 == 99) {
            resultSetArray2[0].close();
        }
        if (n2 == 199) {
            resultSetArray[0].close();
            resultSetArray[0] = null;
            resultSetArray2[0].close();
            resultSetArray2[0] = null;
        }
        if (n2 == 299) {
            ResultSet resultSet = resultSetArray[0];
            resultSetArray[0] = resultSetArray2[0];
            resultSetArray2[0] = resultSet;
        }
        connection.close();
    }

    public static void selectRows(String string, ResultSet[] resultSetArray) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        Statement statement = connection.createStatement();
        resultSetArray[0] = statement.executeQuery("select * FROM " + string);
        connection.close();
    }

    public void testParameterTypes() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = this.createStatement();
        statement.execute("create table PT1(A integer not null primary key,                  B char(10), C varchar(20))");
        statement.execute("create procedure PT1(in a int, in b char(10), c varchar(20)) parameter style java dynamic result sets 1 language java modifies sql data external name '" + this.thisClassName + ".parameter1'");
        String[] stringArray = new String[]{"APP.PT1 AS " + this.thisClassName + ".parameter1(IN \"A\" INTEGER,IN \"B\" CHAR(10),IN \"C\" VARCHAR(20)) LANGUAGE JAVA PARAMETER STYLE JAVA MODIFIES SQL DATA DYNAMIC RESULT SETS 1"};
        String[] stringArray2 = new String[]{"APP.PT1 AS " + this.thisClassName + ".parameter1 type procedureNoResult"};
        String[] stringArray3 = new String[]{"procedureColumnIn A INTEGER", "procedureColumnIn B CHAR", "procedureColumnIn C VARCHAR"};
        LangProcedureTest.checkMatchingProcedures(connection, "PT1", stringArray, stringArray2, stringArray3);
        CallableStatement callableStatement = connection.prepareCall("call PT1(?, ?, ?)");
        callableStatement.setInt(1, 20);
        callableStatement.setString(2, "abc");
        callableStatement.setString(3, "efgh");
        callableStatement.execute();
        JDBC.assertFullResultSet(callableStatement.getResultSet(), new String[][]{{"20", "abc", "10", "efgh", "4"}});
        callableStatement.setInt(1, 30);
        callableStatement.setString(2, "abc   ");
        callableStatement.setString(3, "efgh  ");
        callableStatement.execute();
        JDBC.assertFullResultSet(callableStatement.getResultSet(), new String[][]{{"30", "abc", "10", "efgh", "6"}});
        callableStatement.setInt(1, 40);
        char[] cArray = new char[75];
        Arrays.fill(cArray, ' ');
        char[] cArray2 = new char[77];
        Arrays.fill(cArray2, ' ');
        callableStatement.setString(2, "abc" + new String(cArray));
        callableStatement.setString(3, "efgh" + new String(cArray2));
        callableStatement.execute();
        JDBC.assertFullResultSet(callableStatement.getResultSet(), new String[][]{{"40", "abc", "10", "efgh", "20"}});
        callableStatement.setInt(1, 50);
        callableStatement.setString(2, "0123456789X");
        callableStatement.setString(3, "efgh  ");
        LangProcedureTest.assertPreparedStatementError(LANG_STRING_TRUNCATION, callableStatement);
        callableStatement.setInt(1, 50);
        callableStatement.setString(2, "0123456789");
        callableStatement.setString(3, "efgh  ");
        callableStatement.execute();
        JDBC.assertFullResultSet(callableStatement.getResultSet(), new String[][]{{"50", "0123456789", "10", "efgh", "6"}});
        callableStatement.close();
        statement.execute("drop procedure PT1");
        statement.execute("create procedure PT2(in a int, in b DECIMAL(4), c DECIMAL(7,3)) parameter style java dynamic result sets 1 language java modifies sql data external name '" + this.thisClassName + ".parameter2'");
        stringArray = new String[]{"APP.PT2 AS " + this.thisClassName + ".parameter2(IN \"A\" INTEGER,IN \"B\" DECIMAL(4,0),IN \"C\" DECIMAL(7,3)) LANGUAGE JAVA PARAMETER STYLE JAVA MODIFIES SQL DATA DYNAMIC RESULT SETS 1"};
        stringArray2 = new String[]{"APP.PT2 AS " + this.thisClassName + ".parameter2 type procedureNoResult"};
        stringArray3 = new String[]{"procedureColumnIn A INTEGER", "procedureColumnIn B DECIMAL", "procedureColumnIn C DECIMAL"};
        LangProcedureTest.checkMatchingProcedures(connection, "PT2", stringArray, stringArray2, stringArray3);
        CallableStatement callableStatement2 = connection.prepareCall("call PT2(?, ?, ?)");
        callableStatement2.setInt(1, 60);
        callableStatement2.setString(2, "34");
        callableStatement2.setString(3, "54.1");
        boolean bl = callableStatement2.execute();
        ResultSet resultSet = callableStatement2.getResultSet();
        JDBC.assertFullResultSet(resultSet, new String[][]{{"60", "34", "54.100"}});
        callableStatement2.setInt(1, 70);
        callableStatement2.setBigDecimal(2, new BigDecimal("831"));
        callableStatement2.setBigDecimal(3, new BigDecimal("45.7"));
        callableStatement2.execute();
        resultSet = callableStatement2.getResultSet();
        JDBC.assertFullResultSet(resultSet, new String[][]{{"70", "831", "45.700"}});
        callableStatement2.setInt(1, -1);
        callableStatement2.setBigDecimal(2, new BigDecimal("10243"));
        callableStatement2.setBigDecimal(3, null);
        try {
            callableStatement2.execute();
            LangProcedureTest.fail((String)"FAIL - too many digits in decimal value accepted");
        }
        catch (SQLException sQLException) {
            LangProcedureTest.assertSQLState("22003", sQLException);
        }
        callableStatement2.setInt(1, 80);
        callableStatement2.setBigDecimal(2, new BigDecimal("993"));
        callableStatement2.setBigDecimal(3, new BigDecimal("1234.5678"));
        callableStatement2.execute();
        resultSet = callableStatement2.getResultSet();
        JDBC.assertFullResultSet(resultSet, new String[][]{{"80", "993", "1234.567"}});
        callableStatement2.close();
        statement.execute("drop procedure PT2");
        statement.execute("create procedure PTSMALLINT2(    in    p_in    SMALLINT,     inout p_inout SMALLINT,     out   p_out   SMALLINT) parameter style java dynamic result sets 0 language java no sql external name '" + this.thisClassName + ".pSMALLINT'");
        stringArray = new String[]{"APP.PTSMALLINT2 AS " + this.thisClassName + ".pSMALLINT(IN \"P_IN\" SMALLINT,INOUT \"P_INOUT\" SMALLINT,OUT \"P_OUT\" SMALLINT) LANGUAGE JAVA PARAMETER STYLE JAVA NO SQL"};
        stringArray2 = new String[]{"APP.PTSMALLINT2 AS " + this.thisClassName + ".pSMALLINT type procedureNoResult"};
        stringArray3 = new String[]{"procedureColumnIn P_IN SMALLINT", "procedureColumnInOut P_INOUT SMALLINT", "procedureColumnOut P_OUT SMALLINT"};
        LangProcedureTest.checkMatchingProcedures(connection, "PT2", stringArray, stringArray2, stringArray3);
        CallableStatement callableStatement3 = connection.prepareCall("call PTSMALLINT2(?, ?, ?)");
        callableStatement3.registerOutParameter(2, 5);
        callableStatement3.registerOutParameter(3, 5);
        callableStatement3.setNull(1, 5);
        callableStatement3.setShort(2, (short)7);
        try {
            callableStatement3.execute();
            LangProcedureTest.fail((String)"FAIL NULL PASSED to  primitive");
        }
        catch (SQLException sQLException) {
            LangProcedureTest.assertSQLState("39004", sQLException);
        }
        callableStatement3.setShort(1, (short)4);
        callableStatement3.setNull(2, 5);
        try {
            callableStatement3.execute();
            LangProcedureTest.fail((String)"FAIL NULL PASSED to  primitive");
        }
        catch (SQLException sQLException) {
            LangProcedureTest.assertSQLState("39004", sQLException);
        }
        callableStatement3.setShort(1, (short)6);
        callableStatement3.setShort(2, (short)3);
        callableStatement3.execute();
        LangProcedureTest.assertEquals((String)"wrong value for p_inout", (String)"9", (String)callableStatement3.getObject(2).toString());
        LangProcedureTest.assertEquals((String)"wrong value for p_out", (String)"6", (String)callableStatement3.getObject(3).toString());
        callableStatement3.setShort(2, (short)3);
        callableStatement3.execute();
        LangProcedureTest.assertEquals((String)"wrong value for p_inout", (String)"9", (String)callableStatement3.getObject(2).toString());
        LangProcedureTest.assertEquals((String)"wrong value for p_out", (String)"6", (String)callableStatement3.getObject(3).toString());
        callableStatement3.setObject(1, (Object)6);
        callableStatement3.setObject(2, (Object)3);
        callableStatement3.execute();
        LangProcedureTest.assertEquals((String)"wrong value for p_inout", (String)"9", (String)callableStatement3.getObject(2).toString());
        LangProcedureTest.assertFalse((boolean)callableStatement3.wasNull());
        LangProcedureTest.assertEquals((String)"wrong value for p_out", (String)"6", (String)callableStatement3.getObject(3).toString());
        LangProcedureTest.assertFalse((boolean)callableStatement3.wasNull());
        callableStatement3.close();
        statement.execute("drop procedure PTSMALLINT2");
        statement.execute("drop table PT1");
        statement.close();
    }

    public void testOutparams() throws SQLException {
        String string;
        String string2;
        Connection connection = this.getConnection();
        Statement statement = this.createStatement();
        statement.execute("create procedure OP1(out a int, in b int) parameter style java language java external name '" + this.thisClassName + ".outparams1'");
        String[] stringArray = new String[]{"APP.OP1 AS " + this.thisClassName + ".outparams1(OUT \"A\" INTEGER,IN \"B\" INTEGER) LANGUAGE JAVA PARAMETER STYLE JAVA MODIFIES SQL DATA"};
        String[] stringArray2 = new String[]{"APP.OP1 AS " + this.thisClassName + ".outparams1 type procedureNoResult"};
        String[] stringArray3 = new String[]{"procedureColumnOut A INTEGER", "procedureColumnIn B INTEGER"};
        LangProcedureTest.checkMatchingProcedures(connection, "OP1", stringArray, stringArray2, stringArray3);
        try {
            statement.execute("call OP1(?, ?)");
            LangProcedureTest.fail((String)"FAIL execute succeeded on out param with Statement");
        }
        catch (SQLException sQLException) {
            string2 = "XJ009";
            if (LangProcedureTest.usingDerbyNetClient()) {
                string2 = "07004";
            }
            LangProcedureTest.assertSQLState(string2, sQLException);
        }
        if (LangProcedureTest.usingEmbedded()) {
            try {
                this.prepareStatement("call OP1(?, ?)");
                LangProcedureTest.fail((String)"FAIL prepare succeeded on out param with PreparedStatement");
            }
            catch (SQLException sQLException) {
                string2 = "XJ009";
                LangProcedureTest.assertSQLState(string2, sQLException);
            }
        }
        CallableStatement callableStatement = this.prepareCall("call OP1(?, ?)");
        callableStatement.registerOutParameter(1, 4);
        callableStatement.setInt(2, 7);
        callableStatement.execute();
        LangProcedureTest.assertEquals((int)14, (int)callableStatement.getInt(1));
        LangProcedureTest.assertFalse((boolean)callableStatement.wasNull());
        callableStatement.close();
        statement.execute("create procedure OP2(inout a int, in b int) parameter style java language java external name '" + this.thisClassName + ".inoutparams2'");
        stringArray = new String[]{"APP.OP2 AS " + this.thisClassName + ".inoutparams2(INOUT \"A\" INTEGER,IN \"B\" INTEGER) LANGUAGE JAVA PARAMETER STYLE JAVA MODIFIES SQL DATA"};
        stringArray2 = new String[]{"APP.OP2 AS " + this.thisClassName + ".inoutparams2 type procedureNoResult"};
        stringArray3 = new String[]{"procedureColumnInOut A INTEGER", "procedureColumnIn B INTEGER"};
        LangProcedureTest.checkMatchingProcedures(connection, "OP2", stringArray, stringArray2, stringArray3);
        try {
            statement.execute("call OP2(?,?)");
            LangProcedureTest.fail((String)"FAIL execute succeeded on inout param with Statement");
        }
        catch (SQLException sQLException) {
            string = "XJ009";
            if (LangProcedureTest.usingDerbyNetClient()) {
                string = "07004";
            }
            LangProcedureTest.assertSQLState(string, sQLException);
        }
        if (!LangProcedureTest.usingDerbyNetClient()) {
            try {
                this.prepareStatement("call OP2(?, ?)");
                LangProcedureTest.fail((String)"FAIL prepare succeeded on inout param with PreparedStatement");
            }
            catch (SQLException sQLException) {
                string = "XJ009";
                LangProcedureTest.assertSQLState(string, sQLException);
            }
        }
        callableStatement = this.prepareCall("call OP2(?, ?)");
        callableStatement.registerOutParameter(1, 4);
        callableStatement.setInt(1, 3);
        callableStatement.setInt(2, 7);
        callableStatement.execute();
        LangProcedureTest.assertEquals((int)17, (int)callableStatement.getInt(1));
        LangProcedureTest.assertFalse((boolean)callableStatement.wasNull());
        callableStatement.close();
        statement.execute("create procedure OP3(inout a char(10), in b int) parameter style java language java external name '" + this.thisClassName + ".inoutparams3'");
        callableStatement = this.prepareCall("call OP3(?, ?)");
        callableStatement.registerOutParameter(1, 1);
        callableStatement.setString(1, "dan");
        callableStatement.setInt(2, 8);
        callableStatement.execute();
        LangProcedureTest.assertEquals((String)"nad       ", (String)callableStatement.getString(1));
        LangProcedureTest.assertFalse((boolean)callableStatement.wasNull());
        callableStatement.close();
        statement.execute("create procedure OP4(out a DECIMAL(4,2), in b varchar(255)) parameter style java language java external name '" + this.thisClassName + ".inoutparams4'");
        stringArray = new String[]{"APP.OP4 AS " + this.thisClassName + ".inoutparams4(OUT \"A\" DECIMAL(4,2),IN \"B\" VARCHAR(255)) LANGUAGE JAVA PARAMETER STYLE JAVA MODIFIES SQL DATA"};
        stringArray2 = new String[]{"APP.OP4 AS " + this.thisClassName + ".inoutparams4 type procedureNoResult"};
        stringArray3 = new String[]{"procedureColumnOut A DECIMAL", "procedureColumnIn B VARCHAR"};
        LangProcedureTest.checkMatchingProcedures(connection, "OP4", stringArray, stringArray2, stringArray3);
        callableStatement = this.prepareCall("call OP4(?, ?)");
        callableStatement.registerOutParameter(1, 3);
        callableStatement.setString(2, null);
        callableStatement.execute();
        LangProcedureTest.assertNull((Object)callableStatement.getBigDecimal(1));
        LangProcedureTest.assertTrue((boolean)callableStatement.wasNull());
        callableStatement.setString(2, "14");
        callableStatement.execute();
        LangProcedureTest.assertEquals((String)"31.00", (String)callableStatement.getBigDecimal(1).toString());
        LangProcedureTest.assertFalse((boolean)callableStatement.wasNull());
        callableStatement.setString(2, "11.3");
        callableStatement.execute();
        LangProcedureTest.assertEquals((String)"28.30", (String)callableStatement.getBigDecimal(1).toString());
        LangProcedureTest.assertFalse((boolean)callableStatement.wasNull());
        callableStatement.setString(2, "39.345");
        callableStatement.execute();
        LangProcedureTest.assertEquals((String)"56.34", (String)callableStatement.getBigDecimal(1).toString());
        LangProcedureTest.assertFalse((boolean)callableStatement.wasNull());
        callableStatement.setString(2, "83");
        try {
            callableStatement.execute();
            LangProcedureTest.fail((String)"FAIL - execution ok on out of range out parameter");
        }
        catch (SQLException sQLException) {
            LangProcedureTest.assertSQLState("22003", sQLException);
        }
        callableStatement.clearParameters();
        try {
            callableStatement.execute();
            LangProcedureTest.fail((String)"FAIL - b not set");
        }
        catch (SQLException sQLException) {
            LangProcedureTest.assertSQLState("07000", sQLException);
        }
        if (LangProcedureTest.usingEmbedded()) {
            try {
                callableStatement.setBigDecimal(1, new BigDecimal("22.32"));
                LangProcedureTest.fail((String)"FAIL - set out param to value");
            }
            catch (SQLException sQLException) {
                LangProcedureTest.assertSQLState("XCL27", sQLException);
            }
            try {
                callableStatement.setBigDecimal(1, null);
                LangProcedureTest.fail((String)"FAIL - set out param to null");
            }
            catch (SQLException sQLException) {
                LangProcedureTest.assertSQLState("XCL27", sQLException);
            }
            try {
                callableStatement.setNull(1, 3);
                LangProcedureTest.fail((String)"FAIL - set out param to null");
            }
            catch (SQLException sQLException) {
                LangProcedureTest.assertSQLState("XCL27", sQLException);
            }
        }
        callableStatement.setString(2, "49.345");
        callableStatement.execute();
        LangProcedureTest.assertEquals((String)"66.34", (String)callableStatement.getBigDecimal(1).toString());
        LangProcedureTest.assertFalse((boolean)callableStatement.wasNull());
        try {
            callableStatement.getString(2);
            LangProcedureTest.fail((String)("FAIL OP4 GET 49.345 >" + callableStatement.getString(2) + "< null ? " + callableStatement.wasNull()));
        }
        catch (SQLException sQLException) {
            if (LangProcedureTest.usingDerbyNetClient()) {
                LangProcedureTest.assertSQLState("XJ091", sQLException);
            }
            LangProcedureTest.assertSQLState("XCL26", sQLException);
        }
        callableStatement.close();
        callableStatement = connection.prepareCall("call OP4(?, ?)");
        callableStatement.setString(2, "14");
        try {
            callableStatement.execute();
            LangProcedureTest.fail((String)"FAIL - execute succeeded without registration of out parameter");
        }
        catch (SQLException sQLException) {
            if (LangProcedureTest.usingEmbedded()) {
                LangProcedureTest.assertSQLState("07004", sQLException);
            }
            LangProcedureTest.assertSQLState("07000", sQLException);
        }
        callableStatement.close();
        statement.execute("create procedure OP4INOUT(    inout a DECIMAL(4,2), in b varchar(255)) parameter style java language java external name '" + this.thisClassName + ".inoutparams4'");
        callableStatement = connection.prepareCall("call OP4INOUT(?, ?)");
        callableStatement.registerOutParameter(1, 3);
        callableStatement.setString(2, null);
        callableStatement.setBigDecimal(1, null);
        callableStatement.execute();
        LangProcedureTest.assertNull((Object)callableStatement.getBigDecimal(1));
        LangProcedureTest.assertTrue((boolean)callableStatement.wasNull());
        callableStatement.setBigDecimal(1, new BigDecimal("99"));
        callableStatement.execute();
        LangProcedureTest.assertNull((Object)callableStatement.getBigDecimal(1));
        LangProcedureTest.assertTrue((boolean)callableStatement.wasNull());
        callableStatement.setString(2, "23.5");
        callableStatement.setBigDecimal(1, new BigDecimal("14"));
        callableStatement.execute();
        LangProcedureTest.assertEquals((String)"37.50", (String)callableStatement.getBigDecimal(1).toString());
        callableStatement.setString(2, "23.505");
        callableStatement.setBigDecimal(1, new BigDecimal("9"));
        callableStatement.execute();
        LangProcedureTest.assertEquals((String)"32.50", (String)callableStatement.getBigDecimal(1).toString());
        callableStatement.execute();
        LangProcedureTest.assertEquals((String)"56.00", (String)callableStatement.getBigDecimal(1).toString());
        LangProcedureTest.assertFalse((boolean)callableStatement.wasNull());
        callableStatement.setString(2, "67.99");
        callableStatement.setBigDecimal(1, new BigDecimal("32.01"));
        try {
            callableStatement.execute();
            LangProcedureTest.fail((String)("FAIL OP4INOUT 32.01+67.99 >" + String.valueOf(callableStatement.getBigDecimal(1)) + "< null ? " + callableStatement.wasNull()));
        }
        catch (SQLException sQLException) {
            LangProcedureTest.assertSQLState("22003", sQLException);
        }
        callableStatement.setString(2, "1");
        callableStatement.setBigDecimal(1, new BigDecimal("102.33"));
        try {
            callableStatement.execute();
            LangProcedureTest.fail((String)("FAIL OP4INOUT 1+102.33 >" + String.valueOf(callableStatement.getBigDecimal(1)) + "< null ? " + callableStatement.wasNull()));
        }
        catch (SQLException sQLException) {
            LangProcedureTest.assertSQLState("22003", sQLException);
        }
        callableStatement.clearParameters();
        try {
            callableStatement.execute();
            LangProcedureTest.fail((String)"FAIL - a,b not set");
        }
        catch (SQLException sQLException) {
            LangProcedureTest.assertSQLState("07000", sQLException);
        }
        callableStatement.clearParameters();
        callableStatement.setString(2, "2");
        try {
            callableStatement.execute();
            LangProcedureTest.fail((String)"FAIL - a  not set");
        }
        catch (SQLException sQLException) {
            LangProcedureTest.assertSQLState("07000", sQLException);
        }
        callableStatement.clearParameters();
        callableStatement.setBigDecimal(1, new BigDecimal("33"));
        try {
            callableStatement.execute();
            LangProcedureTest.fail((String)"FAIL - b  not set");
        }
        catch (SQLException sQLException) {
            LangProcedureTest.assertSQLState("07000", sQLException);
        }
        callableStatement.close();
        callableStatement = connection.prepareCall("call OP4INOUT(?, ?)");
        callableStatement.setString(2, "14");
        try {
            callableStatement.execute();
            LangProcedureTest.fail((String)"FAIL - execute succeeded without registration of inout parameter");
        }
        catch (SQLException sQLException) {
            if (LangProcedureTest.usingDerbyNetClient()) {
                LangProcedureTest.assertSQLState("07000", sQLException);
            }
            LangProcedureTest.assertSQLState("07004", sQLException);
        }
        callableStatement.close();
        statement.execute("drop PROCEDURE OP1");
        statement.execute("drop PROCEDURE OP2");
        statement.execute("drop PROCEDURE OP3");
        statement.execute("drop PROCEDURE OP4");
        statement.execute("drop PROCEDURE OP4INOUT");
        statement.close();
    }

    public void testSQLControl() throws SQLException {
        int n;
        String[][] stringArrayArray;
        String[][] stringArrayArray2;
        String[][] stringArrayArray3;
        Connection connection = this.getConnection();
        Statement statement = this.createStatement();
        statement.execute("create schema SQLC");
        statement.execute("create table SQLC.SQLCONTROL_DML(I int)");
        statement.execute("insert into SQLC.SQLCONTROL_DML values 4");
        String[] stringArray = new String[]{"", "no sql", "contains sql", "reads sql data", "modifies sql data"};
        for (int i = 0; i < stringArray.length; ++i) {
            stringArrayArray3 = new StringBuilder(256);
            stringArrayArray3.append("create procedure sqlc.sqlcontrol1_");
            stringArrayArray3.append(i);
            stringArrayArray3.append("(out e1 varchar(128),  out e2 varchar(128),  out e3 varchar(128),  out e4 varchar(128),  out e5 varchar(128),  out e6 varchar(128),  out e7 varchar(128)) ");
            stringArrayArray3.append(stringArray[i]);
            stringArrayArray3.append(" parameter style java language java ");
            stringArrayArray3.append("external name '");
            stringArrayArray3.append(this.thisClassName);
            stringArrayArray3.append(".sqlControl'");
            stringArrayArray2 = stringArrayArray3.toString();
            statement.execute((String)stringArrayArray2);
            stringArrayArray3.setLength(0);
            stringArrayArray3.append("create procedure sqlc.sqlcontrol2_");
            stringArrayArray3.append(i);
            stringArrayArray3.append("(out e1 varchar(128), out e2 varchar(128), out e3 varchar(128), out e4 varchar(128), out e5 varchar(128), out e6 varchar(128), out e7 varchar(128)) ");
            stringArrayArray3.append(stringArray[i]);
            stringArrayArray3.append(" parameter style java language java ");
            stringArrayArray3.append("external name '");
            stringArrayArray3.append(this.thisClassName);
            stringArrayArray3.append(".sqlControl2'");
            stringArrayArray2 = stringArrayArray3.toString();
            statement.execute((String)stringArrayArray2);
            stringArrayArray3.setLength(0);
            stringArrayArray3.append("create procedure sqlc.sqlcontrol3_");
            stringArrayArray3.append(i);
            stringArrayArray3.append("(out e1 varchar(128), out e2 varchar(128), out e3 varchar(128), out e4 varchar(128), out e5 varchar(128), out e6 varchar(128), out e7 varchar(128)) ");
            stringArrayArray3.append(stringArray[i]);
            stringArrayArray3.append(" parameter style java language java ");
            stringArrayArray3.append("external name '");
            stringArrayArray3.append(this.thisClassName);
            stringArrayArray3.append(".sqlControl3'");
            stringArrayArray2 = stringArrayArray3.toString();
            statement.execute((String)stringArrayArray2);
            stringArrayArray3.setLength(0);
            stringArrayArray3.append("create procedure sqlc.sqlcontrol4_");
            stringArrayArray3.append(i);
            stringArrayArray3.append("(in sqlc integer, out e1 varchar(128), out e2 varchar(128), out e3 varchar(128), out e4 varchar(128), out e5 varchar(128), out e6 varchar(128), out e7 varchar(128), out e8 varchar(128)) ");
            stringArrayArray3.append(stringArray[i]);
            stringArrayArray3.append(" parameter style java language java ");
            stringArrayArray3.append("external name '");
            stringArrayArray3.append(this.thisClassName);
            stringArrayArray3.append(".sqlControl4'");
            stringArrayArray2 = stringArrayArray3.toString();
            statement.execute((String)stringArrayArray2);
        }
        if (!connection.getAutoCommit()) {
            connection.commit();
        }
        String[][] stringArrayArray4 = new String[][]{{"CREATE TABLE SQ-UPDATE 0-EXECUTE OK", "ALTER TABLE SQL-UPDATE 0-EXECUTE OK", "INSERT INTO SQL-UPDATE 1-EXECUTE OK", "UPDATE SQLC.SQL-UPDATE 2-EXECUTE OK", "SELECT * FROM S- ROW(15)- ROW(12)-EXECUTE OK", "DELETE FROM SQL-UPDATE 2-EXECUTE OK", "DROP TABLE SQLC-UPDATE 0-EXECUTE OK"}, {"CREATE VIEW SQL-42X05", "DROP VIEW SQLCO-X0X05", "LOCK TABLE SQLC-42X05", "VALUES 1,2,3- ROW(1)- ROW(2)- ROW(3)-EXECUTE OK", "SET SCHEMA SQLC-UPDATE 0-EXECUTE OK", "CREATE SCHEMA S-UPDATE 0-EXECUTE OK", "DROP SCHEMA SQL-UPDATE 0-EXECUTE OK"}, {"DERBY FEATURE", "DERBY FEATURE", "SET ISOLATION C-UPDATE 0-EXECUTE OK", "SET RUNTIMESTAT-42X01", "SET STATISTICS -42X01", "VALUES 1- ROW(1)-EXECUTE OK", "VALUES 1- ROW(1)-EXECUTE OK"}};
        stringArrayArray3 = new String[][]{{"CREATE TABLE SQ-38001", "ALTER TABLE SQL-42Y55", "INSERT INTO SQL-42X05", "UPDATE SQLC.SQL-42X05", "SELECT * FROM S-42X05", "DELETE FROM SQL-42X05", "DROP TABLE SQLC-42Y55"}, {"CREATE VIEW SQL-42X05", "DROP VIEW SQLCO-38001", "LOCK TABLE SQLC-42X05", "VALUES 1,2,3-38001", "SET SCHEMA SQLC-38001", "CREATE SCHEMA S-38001", "DROP SCHEMA SQL-38001"}, {"DERBY FEATURE", "DERBY FEATURE", "SET ISOLATION C-38001", "SET RUNTIMESTAT-42X01", "SET STATISTICS -42X01", "VALUES 1-38001", "VALUES 1-38001"}};
        stringArrayArray2 = new String[][]{{"CREATE TABLE SQ-38002", "ALTER TABLE SQL-42Y55", "INSERT INTO SQL-42X05", "UPDATE SQLC.SQL-42X05", "SELECT * FROM S-42X05", "DELETE FROM SQL-42X05", "DROP TABLE SQLC-42Y55"}, {"CREATE VIEW SQL-42X05", "DROP VIEW SQLCO-38002", "LOCK TABLE SQLC-42X05", "VALUES 1,2,3-38004", "SET SCHEMA SQLC-UPDATE 0-EXECUTE OK", "CREATE SCHEMA S-38002", "DROP SCHEMA SQL-38002"}, {"DERBY FEATURE", "DERBY FEATURE", "SET ISOLATION C-UPDATE 0-EXECUTE OK", "SET RUNTIMESTAT-42X01", "SET STATISTICS -42X01", "VALUES 1-38004", "VALUES 1-38004"}};
        String[][] stringArrayArray5 = new String[][]{{"CREATE TABLE SQ-38002", "ALTER TABLE SQL-42Y55", "INSERT INTO SQL-42X05", "UPDATE SQLC.SQL-42X05", "SELECT * FROM S-42X05", "DELETE FROM SQL-42X05", "DROP TABLE SQLC-42Y55"}, {"CREATE VIEW SQL-42X05", "DROP VIEW SQLCO-38002", "LOCK TABLE SQLC-42X05", "VALUES 1,2,3- ROW(1)- ROW(2)- ROW(3)-EXECUTE OK", "SET SCHEMA SQLC-UPDATE 0-EXECUTE OK", "CREATE SCHEMA S-38002", "DROP SCHEMA SQL-38002"}, {"DERBY FEATURE", "DERBY FEATURE", "SET ISOLATION C-UPDATE 0-EXECUTE OK", "SET RUNTIMESTAT-42X01", "SET STATISTICS -42X01", "VALUES 1- ROW(1)-EXECUTE OK", "VALUES 1- ROW(1)-EXECUTE OK"}};
        String[][] stringArrayArray6 = new String[][]{{"CREATE TABLE SQ-UPDATE 0-EXECUTE OK", "ALTER TABLE SQL-42Y55", "INSERT INTO SQL-42X05", "UPDATE SQLC.SQL-42X05", "SELECT * FROM S-42X05", "DELETE FROM SQL-42X05", "DROP TABLE SQLC-42Y55"}, {"CREATE VIEW SQL-42X05", "DROP VIEW SQLCO-X0X05", "LOCK TABLE SQLC-42X05", "VALUES 1,2,3- ROW(1)- ROW(2)- ROW(3)-EXECUTE OK", "SET SCHEMA SQLC-UPDATE 0-EXECUTE OK", "CREATE SCHEMA S-UPDATE 0-EXECUTE OK", "DROP SCHEMA SQL-UPDATE 0-EXECUTE OK"}, {"DERBY FEATURE", "DERBY FEATURE", "SET ISOLATION C-UPDATE 0-EXECUTE OK", "SET RUNTIMESTAT-42X01", "SET STATISTICS -42X01", "VALUES 1- ROW(1)-EXECUTE OK", "VALUES 1- ROW(1)-EXECUTE OK"}};
        String[][][] stringArrayArray7 = new String[][][]{stringArrayArray4, stringArrayArray3, stringArrayArray2, stringArrayArray5, stringArrayArray6};
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 1; j <= 3; ++j) {
                int n2;
                stringArrayArray = connection.prepareCall("call SQLC.SQLCONTROL" + j + "_" + i + " (?, ?, ?, ?, ?, ?, ?)");
                for (n2 = 1; n2 <= 7; ++n2) {
                    stringArrayArray.registerOutParameter(n2, 12);
                }
                stringArrayArray.execute();
                for (n2 = 1; n2 <= 7; ++n2) {
                    LangProcedureTest.assertEquals((String)stringArrayArray7[i][j - 1][n2 - 1], (String)stringArrayArray.getString(n2));
                }
                stringArrayArray.close();
            }
            if (stringArray[i].length() != 0) continue;
            statement.execute("drop table SQLCONTROL_DDL");
        }
        String[][] stringArrayArray8 = new String[][]{{"call SQLC.SQLCONTROL2_0 (?, ?, ?, ?, ?, ?, ?) ", "CREATE VIEW SQL-UPDATE 0-EXECUTE OK", "DROP VIEW SQLCO-UPDATE 0-EXECUTE OK", "LOCK TABLE SQLC-UPDATE 0-EXECUTE OK", "VALUES 1,2,3- ROW(1)- ROW(2)- ROW(3)-EXECUTE OK", "SET SCHEMA SQLC-UPDATE 0-EXECUTE OK", "CREATE SCHEMA S-UPDATE 0-EXECUTE OK", "DROP SCHEMA SQL-UPDATE 0-EXECUTE OK"}, {"call SQLC.SQLCONTROL2_1 (?, ?, ?, ?, ?, ?, ?) ", "CREATE VIEW SQL-38001", "DROP VIEW SQLCO-38001", "LOCK TABLE SQLC-38001", "VALUES 1,2,3-38001", "SET SCHEMA SQLC-38001", "CREATE SCHEMA S-38001", "DROP SCHEMA SQL-38001"}, {"call SQLC.SQLCONTROL2_2 (?, ?, ?, ?, ?, ?, ?) ", "CREATE VIEW SQL-38002", "DROP VIEW SQLCO-38002", "LOCK TABLE SQLC-UPDATE 0-EXECUTE OK", "VALUES 1,2,3-38004", "SET SCHEMA SQLC-UPDATE 0-EXECUTE OK", "CREATE SCHEMA S-38002", "DROP SCHEMA SQL-38002"}, {"call SQLC.SQLCONTROL2_3 (?, ?, ?, ?, ?, ?, ?) ", "CREATE VIEW SQL-38002", "DROP VIEW SQLCO-38002", "LOCK TABLE SQLC-UPDATE 0-EXECUTE OK", "VALUES 1,2,3- ROW(1)- ROW(2)- ROW(3)-EXECUTE OK", "SET SCHEMA SQLC-UPDATE 0-EXECUTE OK", "CREATE SCHEMA S-38002", "DROP SCHEMA SQL-38002"}, {"call SQLC.SQLCONTROL2_4 (?, ?, ?, ?, ?, ?, ?) ", "CREATE VIEW SQL-UPDATE 0-EXECUTE OK", "DROP VIEW SQLCO-UPDATE 0-EXECUTE OK", "LOCK TABLE SQLC-UPDATE 0-EXECUTE OK", "VALUES 1,2,3- ROW(1)- ROW(2)- ROW(3)-EXECUTE OK", "SET SCHEMA SQLC-UPDATE 0-EXECUTE OK", "CREATE SCHEMA S-UPDATE 0-EXECUTE OK", "DROP SCHEMA SQL-UPDATE 0-EXECUTE OK"}};
        String[][] stringArrayArray9 = new String[][]{{"call SQLC.SQLCONTROL2_0 (?, ?, ?, ?, ?, ?, ?) ", "STATE-38001", "null", "null", "null", "null", "null", "null"}, {"call SQLC.SQLCONTROL2_1 (?, ?, ?, ?, ?, ?, ?) ", "STATE-38001", "null", "null", "null", "null", "null", "null"}, {"call SQLC.SQLCONTROL2_2 (?, ?, ?, ?, ?, ?, ?) ", "STATE-38001", "null", "null", "null", "null", "null", "null"}, {"call SQLC.SQLCONTROL2_3 (?, ?, ?, ?, ?, ?, ?) ", "STATE-38001", "null", "null", "null", "null", "null", "null"}, {"call SQLC.SQLCONTROL2_4 (?, ?, ?, ?, ?, ?, ?) ", "STATE-38001", "null", "null", "null", "null", "null", "null"}};
        stringArrayArray = new String[][]{{"call SQLC.SQLCONTROL2_0 (?, ?, ?, ?, ?, ?, ?) ", "STATE-38002", "null", "null", "null", "null", "null", "null"}, {"call SQLC.SQLCONTROL2_1 (?, ?, ?, ?, ?, ?, ?) ", "CREATE VIEW SQL-38001", "DROP VIEW SQLCO-38001", "LOCK TABLE SQLC-38001", "VALUES 1,2,3-38001", "SET SCHEMA SQLC-38001", "CREATE SCHEMA S-38001", "DROP SCHEMA SQL-38001"}, {"call SQLC.SQLCONTROL2_2 (?, ?, ?, ?, ?, ?, ?) ", "CREATE VIEW SQL-38002", "DROP VIEW SQLCO-38002", "LOCK TABLE SQLC-UPDATE 0-EXECUTE OK", "VALUES 1,2,3-38004", "SET SCHEMA SQLC-UPDATE 0-EXECUTE OK", "CREATE SCHEMA S-38002", "DROP SCHEMA SQL-38002"}, {"call SQLC.SQLCONTROL2_3 (?, ?, ?, ?, ?, ?, ?) ", "STATE-38004", "null", "null", "null", "null", "null", "null"}, {"call SQLC.SQLCONTROL2_4 (?, ?, ?, ?, ?, ?, ?) ", "STATE-38002", "null", "null", "null", "null", "null", "null"}};
        String[][] stringArrayArray10 = new String[][]{{"call SQLC.SQLCONTROL2_0 (?, ?, ?, ?, ?, ?, ?) ", "STATE-38002", "null", "null", "null", "null", "null", "null"}, {"call SQLC.SQLCONTROL2_1 (?, ?, ?, ?, ?, ?, ?) ", "CREATE VIEW SQL-38001", "DROP VIEW SQLCO-38001", "LOCK TABLE SQLC-38001", "VALUES 1,2,3-38001", "SET SCHEMA SQLC-38001", "CREATE SCHEMA S-38001", "DROP SCHEMA SQL-38001"}, {"call SQLC.SQLCONTROL2_2 (?, ?, ?, ?, ?, ?, ?) ", "CREATE VIEW SQL-38002", "DROP VIEW SQLCO-38002", "LOCK TABLE SQLC-UPDATE 0-EXECUTE OK", "VALUES 1,2,3-38004", "SET SCHEMA SQLC-UPDATE 0-EXECUTE OK", "CREATE SCHEMA S-38002", "DROP SCHEMA SQL-38002"}, {"call SQLC.SQLCONTROL2_3 (?, ?, ?, ?, ?, ?, ?) ", "CREATE VIEW SQL-38002", "DROP VIEW SQLCO-38002", "LOCK TABLE SQLC-UPDATE 0-EXECUTE OK", "VALUES 1,2,3- ROW(1)- ROW(2)- ROW(3)-EXECUTE OK", "SET SCHEMA SQLC-UPDATE 0-EXECUTE OK", "CREATE SCHEMA S-38002", "DROP SCHEMA SQL-38002"}, {"call SQLC.SQLCONTROL2_4 (?, ?, ?, ?, ?, ?, ?) ", "STATE-38002", "null", "null", "null", "null", "null", "null"}};
        String[][] stringArrayArray11 = new String[][]{{"call SQLC.SQLCONTROL2_0 (?, ?, ?, ?, ?, ?, ?) ", "CREATE VIEW SQL-UPDATE 0-EXECUTE OK", "DROP VIEW SQLCO-UPDATE 0-EXECUTE OK", "LOCK TABLE SQLC-UPDATE 0-EXECUTE OK", "VALUES 1,2,3- ROW(1)- ROW(2)- ROW(3)-EXECUTE OK", "SET SCHEMA SQLC-UPDATE 0-EXECUTE OK", "CREATE SCHEMA S-UPDATE 0-EXECUTE OK", "DROP SCHEMA SQL-UPDATE 0-EXECUTE OK"}, {"call SQLC.SQLCONTROL2_1 (?, ?, ?, ?, ?, ?, ?) ", "CREATE VIEW SQL-38001", "DROP VIEW SQLCO-38001", "LOCK TABLE SQLC-38001", "VALUES 1,2,3-38001", "SET SCHEMA SQLC-38001", "CREATE SCHEMA S-38001", "DROP SCHEMA SQL-38001"}, {"call SQLC.SQLCONTROL2_2 (?, ?, ?, ?, ?, ?, ?) ", "CREATE VIEW SQL-38002", "DROP VIEW SQLCO-38002", "LOCK TABLE SQLC-UPDATE 0-EXECUTE OK", "VALUES 1,2,3-38004", "SET SCHEMA SQLC-UPDATE 0-EXECUTE OK", "CREATE SCHEMA S-38002", "DROP SCHEMA SQL-38002"}, {"call SQLC.SQLCONTROL2_3 (?, ?, ?, ?, ?, ?, ?) ", "CREATE VIEW SQL-38002", "DROP VIEW SQLCO-38002", "LOCK TABLE SQLC-UPDATE 0-EXECUTE OK", "VALUES 1,2,3- ROW(1)- ROW(2)- ROW(3)-EXECUTE OK", "SET SCHEMA SQLC-UPDATE 0-EXECUTE OK", "CREATE SCHEMA S-38002", "DROP SCHEMA SQL-38002"}, {"call SQLC.SQLCONTROL2_4 (?, ?, ?, ?, ?, ?, ?) ", "CREATE VIEW SQL-UPDATE 0-EXECUTE OK", "DROP VIEW SQLCO-UPDATE 0-EXECUTE OK", "LOCK TABLE SQLC-UPDATE 0-EXECUTE OK", "VALUES 1,2,3- ROW(1)- ROW(2)- ROW(3)-EXECUTE OK", "SET SCHEMA SQLC-UPDATE 0-EXECUTE OK", "CREATE SCHEMA S-UPDATE 0-EXECUTE OK", "DROP SCHEMA SQL-UPDATE 0-EXECUTE OK"}};
        String[][][] stringArrayArray12 = new String[][][]{stringArrayArray8, stringArrayArray9, stringArrayArray, stringArrayArray10, stringArrayArray11};
        statement.execute("create table SQLC.SQLCONTROL_DML(I int)");
        statement.execute("insert into SQLC.SQLCONTROL_DML values 4");
        for (n = 0; n < stringArray.length; ++n) {
            for (int i = 0; i < stringArray.length; ++i) {
                int n3;
                CallableStatement callableStatement = connection.prepareCall("call SQLC.SQLCONTROL4_" + n + " (?, ?, ?, ?, ?, ?, ?, ?, ?)");
                callableStatement.setInt(1, i);
                for (n3 = 2; n3 <= 9; ++n3) {
                    callableStatement.registerOutParameter(n3, 12);
                }
                callableStatement.execute();
                for (n3 = 2; n3 <= 9; ++n3) {
                    String string = callableStatement.getString(n3);
                    if (string == null) continue;
                    LangProcedureTest.assertEquals((String)stringArrayArray12[n][i][n3 - 2], (String)string);
                }
                callableStatement.close();
            }
        }
        this.assertCallError(LangProcedureTest.usingEmbedded() ? "07004" : "07000", "call SQLC.SQLCONTROL3_0 (?, ?, ?, ?, ?, ?, ?)");
        statement.execute("drop table SQLC.SQLCONTROL_DML");
        for (n = 0; n < stringArray.length; ++n) {
            statement.execute("drop PROCEDURE SQLC.SQLCONTROL1_" + n);
            statement.execute("drop PROCEDURE SQLC.SQLCONTROL2_" + n);
            statement.execute("drop PROCEDURE SQLC.SQLCONTROL3_" + n);
            statement.execute("drop PROCEDURE SQLC.SQLCONTROL4_" + n);
        }
        statement.execute("drop table SQLCONTROL_DDL");
        statement.execute("set schema APP");
        statement.execute("drop schema SQLC RESTRICT");
        statement.close();
    }

    public void testDerby5945() throws SQLException {
        AutoCloseable autoCloseable;
        this.setAutoCommit(false);
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        statement.executeUpdate("create procedure PROC( inout ret int ) parameter style java    modifies sql data language java external name '" + this.thisClassName + ".PROC'");
        statement.executeUpdate("create function FUNC (i int) returns int parameter style java    reads sql data language java external name '" + this.thisClassName + ".FUNC'");
        try {
            autoCloseable = connection.prepareCall("{?=call PROC(?)}");
            LangProcedureTest.fail();
        }
        catch (SQLException sQLException) {
            LangProcedureTest.assertEquals((String)"'PROC' is a procedure but it is being used as a function.", (String)sQLException.getMessage());
            LangProcedureTest.assertSQLState("42Y03", sQLException);
        }
        autoCloseable = statement.executeQuery("values func(3)");
        autoCloseable.next();
        LangProcedureTest.assertEquals((int)9, (int)autoCloseable.getInt(1));
        try {
            statement.executeUpdate("call func(3)");
            LangProcedureTest.fail();
        }
        catch (SQLException sQLException) {
            LangProcedureTest.assertEquals((String)"'FUNC' is a function but it is being called as a procedure.", (String)sQLException.getMessage());
            LangProcedureTest.assertSQLState("42Y03", sQLException);
        }
        this.rollback();
    }

    public static void PROC(int[] nArray) {
    }

    public static int FUNC(int n) {
        return n * n;
    }

    public static void pSMALLINT(short s, short[] sArray, short[] sArray2) throws SQLException {
        sArray2[0] = s;
        sArray[0] = (short)(sArray[0] + s);
    }

    public static void parameter1(int n, String string, String string2, ResultSet[] resultSetArray) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into PT1 values (?, ?, ?)");
        preparedStatement.setInt(1, n);
        preparedStatement.setString(2, string);
        preparedStatement.setString(3, string2);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        preparedStatement = connection.prepareStatement("select a,b, length(b), c, length(c) from PT1 where a = ?");
        preparedStatement.setInt(1, n);
        resultSetArray[0] = preparedStatement.executeQuery();
        connection.close();
    }

    public static void parameter2(int n, BigDecimal bigDecimal, BigDecimal bigDecimal2, ResultSet[] resultSetArray) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into PT1 values (?, ?, ?)");
        preparedStatement.setInt(1, n);
        preparedStatement.setString(2, bigDecimal.toString());
        preparedStatement.setString(3, bigDecimal2.toString());
        preparedStatement.executeUpdate();
        preparedStatement.close();
        preparedStatement = connection.prepareStatement("select a,b,c from PT1 where a = ?");
        preparedStatement.setInt(1, n);
        resultSetArray[0] = preparedStatement.executeQuery();
        connection.close();
    }

    public static void outparams1(int[] nArray, int n) {
        nArray[0] = n * 2;
    }

    public static void inoutparams2(int[] nArray, int n) {
        nArray[0] = nArray[0] + n * 2;
    }

    public static void inoutparams3(String[] stringArray, int n) {
        if (n == 8) {
            stringArray[0] = "nad";
        } else if (n == 9) {
            stringArray[0] = null;
        } else if (n == 10) {
            stringArray[0] = "abcdefghijklmnopqrstuvwzyz";
        }
    }

    public static void inoutparams4(BigDecimal[] bigDecimalArray, String string) {
        bigDecimalArray[0] = string == null ? null : (bigDecimalArray[0] == null ? new BigDecimal(string).add(new BigDecimal("17")) : new BigDecimal(string).add(bigDecimalArray[0]));
    }

    public static void sqlControl(String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5, String[] stringArray6, String[] stringArray7) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        Statement statement = connection.createStatement();
        LangProcedureTest.executeStatement(statement, "CREATE TABLE SQLCONTROL_DDL (I INT)", stringArray);
        LangProcedureTest.executeStatement(statement, "ALTER TABLE SQLC.SQLCONTROL_DML ADD COLUMN B INT DEFAULT NULL", stringArray2);
        LangProcedureTest.executeStatement(statement, "INSERT INTO SQLC.SQLCONTROL_DML(I) VALUES (1)", stringArray3);
        LangProcedureTest.executeStatement(statement, "UPDATE SQLC.SQLCONTROL_DML SET I = I + 11", stringArray4);
        LangProcedureTest.executeStatement(statement, "SELECT * FROM SQLC.SQLCONTROL_DML", stringArray5);
        LangProcedureTest.executeStatement(statement, "DELETE FROM SQLC.SQLCONTROL_DML", stringArray6);
        LangProcedureTest.executeStatement(statement, "DROP TABLE SQLC.SQLCONTROL_DML", stringArray7);
        connection.close();
    }

    public static void sqlControl2(String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5, String[] stringArray6, String[] stringArray7) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        Statement statement = connection.createStatement();
        LangProcedureTest.executeStatement(statement, "CREATE VIEW SQLCONTROL_VIEW AS SELECT * FROM SQLC.SQLCONTROL_DML", stringArray);
        LangProcedureTest.executeStatement(statement, "DROP VIEW SQLCONTROL_VIEW", stringArray2);
        LangProcedureTest.executeStatement(statement, "LOCK TABLE SQLC.SQLCONTROL_DML IN EXCLUSIVE MODE", stringArray3);
        LangProcedureTest.executeStatement(statement, "VALUES 1,2,3", stringArray4);
        LangProcedureTest.executeStatement(statement, "SET SCHEMA SQLC", stringArray5);
        LangProcedureTest.executeStatement(statement, "CREATE SCHEMA SQLC_M", stringArray6);
        LangProcedureTest.executeStatement(statement, "DROP SCHEMA SQLC_M RESTRICT", stringArray7);
        connection.close();
    }

    public static void sqlControl3(String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5, String[] stringArray6, String[] stringArray7) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        Statement statement = connection.createStatement();
        stringArray[0] = "DERBY FEATURE";
        stringArray2[0] = "DERBY FEATURE";
        LangProcedureTest.executeStatement(statement, "SET ISOLATION CS", stringArray3);
        LangProcedureTest.executeStatement(statement, "SET RUNTIMESTATISTICS OFF", stringArray4);
        LangProcedureTest.executeStatement(statement, "SET STATISTICS TIMING OFF", stringArray5);
        LangProcedureTest.executeStatement(statement, "VALUES 1", stringArray6);
        LangProcedureTest.executeStatement(statement, "VALUES 1", stringArray7);
        connection.close();
    }

    public static void sqlControl4(int n, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5, String[] stringArray6, String[] stringArray7, String[] stringArray8) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        String string = "call SQLC.SQLCONTROL2_" + n + " (?, ?, ?, ?, ?, ?, ?) ";
        stringArray[0] = string;
        CallableStatement callableStatement = connection.prepareCall(string);
        try {
            for (int i = 1; i <= 7; ++i) {
                callableStatement.registerOutParameter(i, 12);
            }
            callableStatement.execute();
            stringArray2[0] = callableStatement.getString(1);
            stringArray3[0] = callableStatement.getString(2);
            stringArray4[0] = callableStatement.getString(3);
            stringArray5[0] = callableStatement.getString(4);
            stringArray6[0] = callableStatement.getString(5);
            stringArray7[0] = callableStatement.getString(6);
            stringArray8[0] = callableStatement.getString(7);
        }
        catch (SQLException sQLException) {
            SQLException sQLException2;
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append("STATE");
            do {
                stringBuilder.append("-");
                String string2 = sQLException2.getSQLState();
                if (string2 == null) {
                    string2 = "?????";
                }
                stringBuilder.append(string2);
            } while ((sQLException2 = sQLException2.getNextException()) != null);
            stringArray2[0] = stringBuilder.toString();
        }
        callableStatement.close();
        connection.close();
    }

    private static void executeStatement(Statement statement, String string, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder(128);
        int n = string.length();
        if (n > 15) {
            n = 15;
        }
        stringBuilder.append(string.substring(0, n));
        try {
            if (statement.execute(string)) {
                ResultSet resultSet = statement.getResultSet();
                while (resultSet.next()) {
                    stringBuilder.append("- ROW(");
                    stringBuilder.append(resultSet.getString(1));
                    stringBuilder.append(")");
                }
                resultSet.close();
            } else {
                stringBuilder.append("-UPDATE ");
                stringBuilder.append(statement.getUpdateCount());
            }
            stringBuilder.append("-EXECUTE OK");
        }
        catch (SQLException sQLException) {
            SQLException sQLException2;
            do {
                stringBuilder.append("-");
                String string2 = sQLException2.getSQLState();
                if (string2 == null) {
                    string2 = "?????";
                }
                stringBuilder.append(string2);
            } while ((sQLException2 = sQLException2.getNextException()) != null);
        }
        stringArray[0] = stringBuilder.toString();
    }

    public static void missingDynamicParameter(int n) {
    }

    public static void missingDynamicParameter(int n, Object object) {
    }

    public static void badDynamicParameter(int n, ProcedureTest[] procedureTestArray) {
    }

    public static void zeroArgDynamicResult(ResultSet[] resultSetArray, ResultSet[] resultSetArray2, ResultSet[] resultSetArray3, ResultSet[] resultSetArray4) {
    }
}

