/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.hll;

import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.pig.hll.DataToSketch;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DataToSketchTest {
    private static final TupleFactory tupleFactory = TupleFactory.getInstance();
    private static final BagFactory bagFactory = BagFactory.getInstance();

    @Test
    public void execNullInputTuple() throws Exception {
        DataToSketch func = new DataToSketch();
        DataByteArray result = (DataByteArray)func.exec(null);
        HllSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void execEmptyInputTuple() throws Exception {
        DataToSketch func = new DataToSketch("10");
        DataByteArray result = (DataByteArray)func.exec(tupleFactory.newTuple());
        HllSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertEquals((int)sketch.getLgConfigK(), (int)10);
    }

    @Test
    public void execEmptyBag() throws Exception {
        DataToSketch func = new DataToSketch("10", "HLL_6");
        DataByteArray result = (DataByteArray)func.exec(tupleFactory.newTuple((Object)bagFactory.newDefaultBag()));
        HllSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertEquals((int)sketch.getLgConfigK(), (int)10);
        Assert.assertEquals((Object)sketch.getTgtHllType(), (Object)TgtHllType.HLL_6);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void execUnsupportedType() throws Exception {
        DataToSketch func = new DataToSketch();
        DataBag bag = bagFactory.newDefaultBag();
        bag.add(tupleFactory.newTuple(new Object()));
        func.exec(tupleFactory.newTuple((Object)bag));
    }

    @Test
    public void execVariousTypesOfInput() throws Exception {
        DataToSketch func = new DataToSketch();
        DataBag bag = bagFactory.newDefaultBag();
        Tuple tupleWithNull = tupleFactory.newTuple(1);
        tupleWithNull.set(0, null);
        bag.add(tupleWithNull);
        bag.add(tupleFactory.newTuple((Object)1));
        bag.add(tupleFactory.newTuple((Object)2));
        bag.add(tupleFactory.newTuple((Object)3L));
        bag.add(tupleFactory.newTuple((Object)Float.valueOf(1.0f)));
        bag.add(tupleFactory.newTuple((Object)2.0));
        bag.add(tupleFactory.newTuple((Object)new DataByteArray(new byte[]{1})));
        bag.add(tupleFactory.newTuple((Object)"a"));
        DataByteArray result = (DataByteArray)func.exec(tupleFactory.newTuple((Object)bag));
        HllSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((double)sketch.getEstimate(), (double)7.0, (double)0.01);
    }

    @Test
    public void accumulator() throws Exception {
        DataToSketch func = new DataToSketch();
        DataByteArray result = (DataByteArray)func.getValue();
        HllSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
        func.accumulate(null);
        result = (DataByteArray)func.getValue();
        sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
        func.accumulate(tupleFactory.newTuple());
        result = (DataByteArray)func.getValue();
        sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
        func.accumulate(tupleFactory.newTuple((Object)bagFactory.newDefaultBag()));
        result = (DataByteArray)func.getValue();
        sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
        DataBag bag = bagFactory.newDefaultBag();
        bag.add(tupleFactory.newTuple((Object)"a"));
        bag.add(tupleFactory.newTuple((Object)"b"));
        func.accumulate(tupleFactory.newTuple((Object)bag));
        result = (DataByteArray)func.getValue();
        sketch = DataToSketchTest.getSketch(result);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((double)sketch.getEstimate(), (double)2.0, (double)0.01);
        func.cleanup();
        result = (DataByteArray)func.getValue();
        sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void algebraicInitial() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new DataToSketch().getInitial()).newInstance();
        Tuple input = tupleFactory.newTuple();
        Tuple result = (Tuple)func.exec(input);
        Assert.assertEquals((Iterable)result, (Iterable)input);
    }

    @Test
    public void algebraicInitialWithLgK() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new DataToSketch().getInitial()).getConstructor(String.class).newInstance("10");
        Tuple input = tupleFactory.newTuple();
        Tuple result = (Tuple)func.exec(input);
        Assert.assertEquals((Iterable)result, (Iterable)input);
    }

    @Test
    public void algebraicInitialWithLgKAndTgtHllType() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new DataToSketch().getInitial()).getConstructor(String.class, String.class).newInstance("10", "HLL_6");
        Tuple input = tupleFactory.newTuple();
        Tuple result = (Tuple)func.exec(input);
        Assert.assertEquals((Iterable)result, (Iterable)input);
    }

    @Test
    public void algebraicIntermediateNullInputTuple() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new DataToSketch().getIntermed()).newInstance();
        Tuple result = (Tuple)func.exec(null);
        HllSketch sketch = DataToSketchTest.getSketch((DataByteArray)result.get(0));
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void algebraicIntermediateEmptyInputTuple() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new DataToSketch().getIntermed()).getConstructor(String.class).newInstance("10");
        Tuple result = (Tuple)func.exec(tupleFactory.newTuple());
        HllSketch sketch = DataToSketchTest.getSketch((DataByteArray)result.get(0));
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertEquals((int)sketch.getLgConfigK(), (int)10);
    }

    @Test
    public void algebraicIntermediateEmptyBag() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new DataToSketch().getIntermed()).getConstructor(String.class, String.class).newInstance("10", "HLL_6");
        Tuple result = (Tuple)func.exec(tupleFactory.newTuple((Object)bagFactory.newDefaultBag()));
        HllSketch sketch = DataToSketchTest.getSketch((DataByteArray)result.get(0));
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertEquals((int)sketch.getLgConfigK(), (int)10);
        Assert.assertEquals((Object)sketch.getTgtHllType(), (Object)TgtHllType.HLL_6);
    }

    @Test
    public void algebraicIntermediateFromInitial() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new DataToSketch().getIntermed()).newInstance();
        DataBag outerBag = bagFactory.newDefaultBag();
        DataBag innerBag = bagFactory.newDefaultBag();
        innerBag.add(tupleFactory.newTuple((Object)"a"));
        innerBag.add(tupleFactory.newTuple((Object)"b"));
        innerBag.add(tupleFactory.newTuple((Object)"c"));
        outerBag.add(tupleFactory.newTuple((Object)innerBag));
        Tuple result = (Tuple)func.exec(tupleFactory.newTuple((Object)outerBag));
        HllSketch sketch = DataToSketchTest.getSketch((DataByteArray)result.get(0));
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((double)sketch.getEstimate(), (double)3.0, (double)0.01);
    }

    @Test
    public void algebraicIntermediateFromIntermediate() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new DataToSketch().getIntermed()).newInstance();
        HllSketch inputSketch = new HllSketch(12);
        inputSketch.update("a");
        inputSketch.update("b");
        DataBag bag = bagFactory.newDefaultBag();
        bag.add(tupleFactory.newTuple((Object)new DataByteArray(inputSketch.toCompactByteArray())));
        Tuple result = (Tuple)func.exec(tupleFactory.newTuple((Object)bag));
        HllSketch sketch = DataToSketchTest.getSketch((DataByteArray)result.get(0));
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((double)sketch.getEstimate(), (double)2.0, (double)0.01);
    }

    @Test
    public void algebraicFinalNullInputTuple() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new DataToSketch().getFinal()).newInstance();
        DataByteArray result = (DataByteArray)func.exec(null);
        HllSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void algebraicFinalEmptyInputTuple() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new DataToSketch().getFinal()).getConstructor(String.class).newInstance("10");
        DataByteArray result = (DataByteArray)func.exec(tupleFactory.newTuple());
        HllSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertEquals((int)sketch.getLgConfigK(), (int)10);
    }

    @Test
    public void algebraicFinalEmptyBag() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new DataToSketch().getFinal()).getConstructor(String.class, String.class).newInstance("10", "HLL_6");
        DataByteArray result = (DataByteArray)func.exec(tupleFactory.newTuple((Object)bagFactory.newDefaultBag()));
        HllSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertEquals((int)sketch.getLgConfigK(), (int)10);
        Assert.assertEquals((Object)sketch.getTgtHllType(), (Object)TgtHllType.HLL_6);
    }

    @Test
    public void algebraicFinalFromInitial() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new DataToSketch().getFinal()).newInstance();
        DataBag outerBag = bagFactory.newDefaultBag();
        DataBag innerBag = bagFactory.newDefaultBag();
        innerBag.add(tupleFactory.newTuple((Object)"a"));
        innerBag.add(tupleFactory.newTuple((Object)"b"));
        innerBag.add(tupleFactory.newTuple((Object)"c"));
        outerBag.add(tupleFactory.newTuple((Object)innerBag));
        DataByteArray result = (DataByteArray)func.exec(tupleFactory.newTuple((Object)outerBag));
        HllSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((double)sketch.getEstimate(), (double)3.0, (double)0.01);
    }

    @Test
    public void algebraicFinalFromIntermediate() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new DataToSketch().getFinal()).newInstance();
        HllSketch inputSketch = new HllSketch(12);
        inputSketch.update("a");
        inputSketch.update("b");
        DataBag bag = bagFactory.newDefaultBag();
        bag.add(tupleFactory.newTuple((Object)new DataByteArray(inputSketch.toCompactByteArray())));
        DataByteArray result = (DataByteArray)func.exec(tupleFactory.newTuple((Object)bag));
        HllSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((double)sketch.getEstimate(), (double)2.0, (double)0.01);
    }

    static HllSketch getSketch(DataByteArray dba) throws Exception {
        Assert.assertNotNull((Object)dba);
        Assert.assertTrue((dba.size() > 0 ? 1 : 0) != 0);
        return HllSketch.heapify((byte[])dba.get());
    }
}

