/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs.multipart;

import javax.ws.rs.core.MediaType;
import org.apache.cxf.jaxrs.ext.multipart.MultipartInputFilter;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.multipart.AttachmentUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.jose.jaxrs.multipart.JwsMultipartSignatureInFilter;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;

public abstract class AbstractJwsMultipartVerificationFilter {
    private JwsSignatureVerifier sigVerifier;
    private boolean useJwsJsonSignatureFormat;
    private boolean bufferPayload;

    public void setSigVerifier(JwsSignatureVerifier sigVerifier) {
        this.sigVerifier = sigVerifier;
    }

    protected void addMultipartFilterIfNeeded(MediaType contentType) {
        if (contentType != null && "multipart".equals(contentType.getType())) {
            Message m = JAXRSUtils.getCurrentMessage();
            JwsMultipartSignatureInFilter jwsFilter = new JwsMultipartSignatureInFilter(m, this.sigVerifier, this.bufferPayload, this.useJwsJsonSignatureFormat);
            AttachmentUtils.addMultipartInFilter((MultipartInputFilter)jwsFilter);
        }
    }

    public void setUseJwsJsonSignatureFormat(boolean useJwsJsonSignatureFormat) {
        this.useJwsJsonSignatureFormat = useJwsJsonSignatureFormat;
    }

    public void setBufferPayload(boolean bufferPayload) {
        this.bufferPayload = bufferPayload;
    }
}

