/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.webdav4.test;

import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.vfs2.AbstractProviderTestCase;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.provider.GenericURLFileName;
import org.apache.commons.vfs2.provider.webdav4.Webdav4FileSystemConfigBuilder;
import org.apache.jackrabbit.webdav.version.DeltaVConstants;
import org.apache.jackrabbit.webdav.version.VersionControlledResource;
import org.junit.Test;

public class Webdav4VersioningTests
extends AbstractProviderTestCase {
    protected FileObject createScratchFolder() throws Exception {
        FileObject scratchFolder = this.getWriteFolder();
        scratchFolder.delete(Selectors.EXCLUDE_SELF);
        scratchFolder.createFolder();
        return scratchFolder;
    }

    @Test
    public void testVersioning() throws Exception {
        FileObject scratchFolder = this.createScratchFolder();
        FileSystemOptions opts = scratchFolder.getFileSystem().getFileSystemOptions();
        Webdav4FileSystemConfigBuilder builder = (Webdav4FileSystemConfigBuilder)this.getManager().getFileSystemConfigBuilder("webdav");
        builder.setVersioning(opts, true);
        FileObject file = this.getManager().resolveFile(scratchFolder, "file1.txt", opts);
        FileSystemOptions newOpts = file.getFileSystem().getFileSystemOptions();
        Webdav4VersioningTests.assertSame((Object)opts, (Object)newOpts);
        Webdav4VersioningTests.assertTrue((boolean)builder.isVersioning(newOpts));
        Webdav4VersioningTests.assertFalse((boolean)file.exists());
        file.createFile();
        Webdav4VersioningTests.assertTrue((boolean)file.exists());
        Webdav4VersioningTests.assertSame((Object)FileType.FILE, (Object)file.getType());
        Webdav4VersioningTests.assertTrue((boolean)file.isFile());
        Webdav4VersioningTests.assertEquals((long)0L, (long)file.getContent().getSize());
        Webdav4VersioningTests.assertTrue((boolean)file.getContent().isEmpty());
        Webdav4VersioningTests.assertFalse((boolean)file.isExecutable());
        Webdav4VersioningTests.assertFalse((boolean)file.isHidden());
        Webdav4VersioningTests.assertTrue((boolean)file.isReadable());
        Webdav4VersioningTests.assertTrue((boolean)file.isWriteable());
        Map map = file.getContent().getAttributes();
        String name = ((GenericURLFileName)file.getName()).getUserName();
        Webdav4VersioningTests.assertTrue((boolean)map.containsKey(DeltaVConstants.CREATOR_DISPLAYNAME.toString()));
        if (name != null) {
            Webdav4VersioningTests.assertEquals((Object)name, map.get(DeltaVConstants.CREATOR_DISPLAYNAME.toString()));
        }
        Webdav4VersioningTests.assertTrue((boolean)map.containsKey(VersionControlledResource.CHECKED_IN.toString()));
        String content = "Here is some sample content for the file.  Blah Blah Blah.";
        try (OutputStream os = file.getContent().getOutputStream();){
            os.write("Here is some sample content for the file.  Blah Blah Blah.".getBytes(StandardCharsets.UTF_8));
        }
        this.assertSameContent("Here is some sample content for the file.  Blah Blah Blah.", file);
        map = file.getContent().getAttributes();
        Webdav4VersioningTests.assertTrue((boolean)map.containsKey(DeltaVConstants.CREATOR_DISPLAYNAME.toString()));
        if (name != null) {
            Webdav4VersioningTests.assertEquals((Object)name, map.get(DeltaVConstants.CREATOR_DISPLAYNAME.toString()));
        }
        Webdav4VersioningTests.assertTrue((boolean)map.containsKey(VersionControlledResource.CHECKED_IN.toString()));
        builder.setVersioning(opts, false);
    }

    @Test
    public void testVersioningWithCreator() throws Exception {
        FileObject scratchFolder = this.createScratchFolder();
        FileSystemOptions opts = scratchFolder.getFileSystem().getFileSystemOptions();
        Webdav4FileSystemConfigBuilder builder = (Webdav4FileSystemConfigBuilder)this.getManager().getFileSystemConfigBuilder("webdav");
        builder.setVersioning(opts, true);
        builder.setCreatorName(opts, "testUser");
        FileObject file = this.getManager().resolveFile(scratchFolder, "file1.txt", opts);
        FileSystemOptions newOpts = file.getFileSystem().getFileSystemOptions();
        Webdav4VersioningTests.assertSame((Object)opts, (Object)newOpts);
        Webdav4VersioningTests.assertTrue((boolean)builder.isVersioning(newOpts));
        Webdav4VersioningTests.assertFalse((boolean)file.exists());
        file.createFile();
        Webdav4VersioningTests.assertTrue((boolean)file.exists());
        Webdav4VersioningTests.assertSame((Object)FileType.FILE, (Object)file.getType());
        Webdav4VersioningTests.assertTrue((boolean)file.isFile());
        Webdav4VersioningTests.assertEquals((long)0L, (long)file.getContent().getSize());
        Webdav4VersioningTests.assertTrue((boolean)file.getContent().isEmpty());
        Webdav4VersioningTests.assertFalse((boolean)file.isExecutable());
        Webdav4VersioningTests.assertFalse((boolean)file.isHidden());
        Webdav4VersioningTests.assertTrue((boolean)file.isReadable());
        Webdav4VersioningTests.assertTrue((boolean)file.isWriteable());
        Map map = file.getContent().getAttributes();
        String name = ((GenericURLFileName)file.getName()).getUserName();
        Webdav4VersioningTests.assertTrue((boolean)map.containsKey(DeltaVConstants.CREATOR_DISPLAYNAME.toString()));
        Webdav4VersioningTests.assertEquals((Object)"testUser", map.get(DeltaVConstants.CREATOR_DISPLAYNAME.toString()));
        if (name != null) {
            Webdav4VersioningTests.assertTrue((boolean)map.containsKey(DeltaVConstants.COMMENT.toString()));
            Webdav4VersioningTests.assertEquals((Object)("Modified by user " + name), map.get(DeltaVConstants.COMMENT.toString()));
        }
        Webdav4VersioningTests.assertTrue((boolean)map.containsKey(VersionControlledResource.CHECKED_IN.toString()));
        String content = "Here is some sample content for the file.  Blah Blah Blah.";
        try (OutputStream os = file.getContent().getOutputStream();){
            os.write("Here is some sample content for the file.  Blah Blah Blah.".getBytes(StandardCharsets.UTF_8));
        }
        this.assertSameContent("Here is some sample content for the file.  Blah Blah Blah.", file);
        map = file.getContent().getAttributes();
        Webdav4VersioningTests.assertTrue((boolean)map.containsKey(DeltaVConstants.CREATOR_DISPLAYNAME.toString()));
        Webdav4VersioningTests.assertEquals((Object)"testUser", map.get(DeltaVConstants.CREATOR_DISPLAYNAME.toString()));
        if (name != null) {
            Webdav4VersioningTests.assertTrue((boolean)map.containsKey(DeltaVConstants.COMMENT.toString()));
            Webdav4VersioningTests.assertEquals((Object)("Modified by user " + name), map.get(DeltaVConstants.COMMENT.toString()));
        }
        Webdav4VersioningTests.assertTrue((boolean)map.containsKey(VersionControlledResource.CHECKED_IN.toString()));
        builder.setVersioning(opts, false);
        builder.setCreatorName(opts, null);
    }
}

