/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder.combined;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration2.beanutils.BeanHelper;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedBuilderParametersImpl;
import org.apache.commons.configuration2.builder.combined.MultiFileBuilderParametersImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestMultiFileBuilderParametersImpl {
    private MultiFileBuilderParametersImpl params;

    @BeforeEach
    public void setUp() throws Exception {
        this.params = new MultiFileBuilderParametersImpl();
    }

    @Test
    public void testBeanProperties() throws Exception {
        BuilderParameters bp = (BuilderParameters)Mockito.mock(BuilderParameters.class);
        String pattern = "testPattern";
        BeanHelper.setProperty((Object)this.params, (String)"filePattern", (Object)"testPattern");
        BeanHelper.setProperty((Object)this.params, (String)"managedBuilderParameters", (Object)bp);
        BeanHelper.setProperty((Object)this.params, (String)"throwExceptionOnMissing", (Object)Boolean.TRUE);
        Map map = this.params.getParameters();
        Assertions.assertEquals((Object)Boolean.TRUE, map.get("throwExceptionOnMissing"));
        Assertions.assertSame((Object)this.params, (Object)MultiFileBuilderParametersImpl.fromParameters((Map)map));
        Assertions.assertEquals((Object)"testPattern", (Object)this.params.getFilePattern());
        Assertions.assertSame((Object)bp, (Object)this.params.getManagedBuilderParameters());
    }

    @Test
    public void testClone() {
        FileBasedBuilderParametersImpl managedParams = new FileBasedBuilderParametersImpl();
        managedParams.setFileName("test.xml");
        this.params.setManagedBuilderParameters((BuilderParameters)managedParams);
        this.params.setFilePattern("somePattern");
        MultiFileBuilderParametersImpl clone = this.params.clone();
        Assertions.assertEquals((Object)this.params.getFilePattern(), (Object)clone.getFilePattern());
        Assertions.assertNotSame((Object)this.params.getManagedBuilderParameters(), (Object)clone.getManagedBuilderParameters());
        Assertions.assertEquals((Object)managedParams.getFileHandler().getFileName(), (Object)((FileBasedBuilderParametersImpl)clone.getManagedBuilderParameters()).getFileHandler().getFileName());
    }

    @Test
    public void testFromParametersFound() {
        Map map = this.params.getParameters();
        Assertions.assertSame((Object)this.params, (Object)MultiFileBuilderParametersImpl.fromParameters((Map)map, (boolean)true));
    }

    @Test
    public void testFromParametersNewInstance() {
        this.params = MultiFileBuilderParametersImpl.fromParameters(new HashMap(), (boolean)true);
        Assertions.assertNotNull((Object)this.params);
    }

    @Test
    public void testFromParatersNotFound() {
        Assertions.assertNull((Object)MultiFileBuilderParametersImpl.fromParameters(new HashMap()));
    }

    @Test
    public void testSetFilePattern() {
        String pattern = "somePattern";
        Assertions.assertSame((Object)this.params, (Object)this.params.setFilePattern("somePattern"));
        Assertions.assertEquals((Object)"somePattern", (Object)this.params.getFilePattern());
    }

    @Test
    public void testSetManagedBuilderParameters() {
        BuilderParameters bp = (BuilderParameters)Mockito.mock(BuilderParameters.class);
        Assertions.assertSame((Object)this.params, (Object)this.params.setManagedBuilderParameters(bp));
        Assertions.assertSame((Object)bp, (Object)this.params.getManagedBuilderParameters());
    }
}

