/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bag;

import org.apache.commons.collections4.Bag;
import org.apache.commons.collections4.SortedBag;
import org.apache.commons.collections4.bag.AbstractSortedBagTest;
import org.apache.commons.collections4.bag.TreeBag;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TreeBagTest<T>
extends AbstractSortedBagTest<T> {
    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public SortedBag<T> makeObject() {
        return new TreeBag();
    }

    public SortedBag<T> setupBag() {
        SortedBag<T> bag = this.makeObject();
        bag.add((Object)"C");
        bag.add((Object)"A");
        bag.add((Object)"B");
        bag.add((Object)"D");
        return bag;
    }

    @Test
    public void testCollections265() {
        TreeBag bag = new TreeBag();
        Assertions.assertThrows(IllegalArgumentException.class, () -> TreeBagTest.lambda$testCollections265$0((Bag)bag));
    }

    @Test
    public void testCollections555() {
        TreeBag bag = new TreeBag();
        Assertions.assertThrows(NullPointerException.class, () -> TreeBagTest.lambda$testCollections555$1((Bag)bag));
        TreeBag bag2 = new TreeBag(String::compareTo);
        bag2.add((Object)"a");
        Assertions.assertThrows(NullPointerException.class, () -> TreeBagTest.lambda$testCollections555$2((Bag)bag2));
    }

    @Test
    public void testOrdering() {
        SortedBag<T> bag = this.setupBag();
        Assertions.assertEquals((Object)"A", (Object)bag.toArray()[0], (String)"Should get elements in correct order");
        Assertions.assertEquals((Object)"B", (Object)bag.toArray()[1], (String)"Should get elements in correct order");
        Assertions.assertEquals((Object)"C", (Object)bag.toArray()[2], (String)"Should get elements in correct order");
        Assertions.assertEquals((Object)"A", (Object)bag.first(), (String)"Should get first key");
        Assertions.assertEquals((Object)"D", (Object)bag.last(), (String)"Should get last key");
    }

    private static /* synthetic */ void lambda$testCollections555$2(Bag bag2) throws Throwable {
        bag2.add(null);
    }

    private static /* synthetic */ void lambda$testCollections555$1(Bag bag) throws Throwable {
        bag.add(null);
    }

    private static /* synthetic */ void lambda$testCollections265$0(Bag bag) throws Throwable {
        bag.add(new Object());
    }
}

