/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

abstract class ReferenceMap<K, V, R extends Reference<V>>
extends AbstractMap<K, V>
implements Serializable {
    private static final long serialVersionUID = -3365744592038165092L;
    protected transient HashMap<K, R> map;
    protected transient ReferenceQueue<V> referenceQueue;
    protected transient Set<Map.Entry<K, V>> entrySet;

    public ReferenceMap() {
        this.map = new HashMap();
        this.referenceQueue = new ReferenceQueue();
    }

    public ReferenceMap(int initialCapacity) {
        this.map = new HashMap(initialCapacity);
        this.referenceQueue = new ReferenceQueue();
    }

    public ReferenceMap(Map<? extends K, ? extends V> m) {
        this(m.size());
        this.putAll(m);
    }

    @Override
    public int size() {
        this.checkReferenceQueue();
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        this.checkReferenceQueue();
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        this.checkReferenceQueue();
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.checkReferenceQueue();
        for (Reference ref : this.map.values()) {
            if (ref == null) {
                throw new IllegalStateException();
            }
            Object v = ref.get();
            if (v == null || !v.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        this.checkReferenceQueue();
        Reference ref = (Reference)this.map.get(key);
        if (ref == null) {
            return null;
        }
        return (V)ref.get();
    }

    @Override
    public V put(K key, V value) {
        if (value == null) {
            throw new NullPointerException("ReferenceMap can't contain null values");
        }
        this.checkReferenceQueue();
        R refValue = this.newReference(value);
        Reference oldValue = (Reference)this.map.put(key, refValue);
        if (oldValue == null) {
            return null;
        }
        return (V)oldValue.get();
    }

    @Override
    public V remove(Object key) {
        this.checkReferenceQueue();
        Reference oldValue = (Reference)this.map.remove(key);
        if (oldValue == null) {
            return null;
        }
        return (V)oldValue.get();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.checkReferenceQueue();
        for (Map.Entry<K, V> entry : m.entrySet()) {
            if (entry.getValue() == null) {
                throw new NullPointerException("ReferenceMap can't contain null values");
            }
            R value = this.newReference(entry.getValue());
            this.map.put(entry.getKey(), value);
        }
    }

    @Override
    public void clear() {
        this.map.clear();
        this.resetReferenceQueue();
    }

    @Override
    public Set<K> keySet() {
        this.checkReferenceQueue();
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        this.checkReferenceQueue();
        Collection<R> referenceValues = this.map.values();
        ArrayList values = new ArrayList(referenceValues.size());
        for (Reference v : referenceValues) {
            Object value;
            if (v == null || (value = v.get()) == null) continue;
            values.add(value);
        }
        return values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.checkReferenceQueue();
        ReferenceEntrySet es = this.entrySet;
        if (es == null) {
            this.entrySet = es = new ReferenceEntrySet();
        }
        return es;
    }

    protected void checkReferenceQueue() {
        Reference<V> reference;
        HashSet<Reference<V>> valuesToRemove = null;
        while ((reference = this.referenceQueue.poll()) != null) {
            if (valuesToRemove == null) {
                valuesToRemove = new HashSet<Reference<V>>();
            }
            valuesToRemove.add(reference);
        }
        if (valuesToRemove == null) {
            return;
        }
        ArrayList<K> keysToRemove = new ArrayList<K>(valuesToRemove.size());
        for (Map.Entry<K, R> entry : this.map.entrySet()) {
            if (!valuesToRemove.contains(entry.getValue())) continue;
            keysToRemove.add(entry.getKey());
        }
        for (Map.Entry<K, Object> keyToRemove : keysToRemove) {
            this.map.remove(keyToRemove);
        }
    }

    private void resetReferenceQueue() {
        while (this.referenceQueue.poll() != null) {
        }
    }

    abstract R newReference(V var1);

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.checkReferenceQueue();
        HashMap replacementMap = new HashMap(this.map.size());
        for (Map.Entry<K, R> entry : this.map.entrySet()) {
            Object value;
            if (entry.getValue() == null || (value = ((Reference)entry.getValue()).get()) == null) continue;
            replacementMap.put(entry.getKey(), value);
        }
        out.writeObject(replacementMap);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Map replacement = (Map)in.readObject();
        this.map = new HashMap(replacement.size());
        this.referenceQueue = new ReferenceQueue();
        this.putAll(replacement);
    }

    class ReferenceEntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        ReferenceEntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new ReferenceEntryIterator();
        }

        @Override
        public int size() {
            return ReferenceMap.this.map.size();
        }
    }

    class ReferenceEntry
    extends AbstractMap.SimpleEntry<K, V> {
        private static final long serialVersionUID = -1795136249842496011L;
        Map.Entry<K, R> refEntry;

        public ReferenceEntry(Map.Entry<K, R> refEntry, V value) {
            super(refEntry.getKey(), value);
            this.refEntry = refEntry;
        }

        @Override
        public V setValue(V value) {
            Object newRef = ReferenceMap.this.newReference(value);
            Reference oldRef = (Reference)this.refEntry.setValue(newRef);
            super.setValue(value);
            if (oldRef != null) {
                return oldRef.get();
            }
            return null;
        }
    }

    class ReferenceEntryIterator
    implements Iterator<Map.Entry<K, V>> {
        Iterator<Map.Entry<K, R>> internalIterator;
        Map.Entry<K, V> next;

        ReferenceEntryIterator() {
            this.internalIterator = ReferenceMap.this.map.entrySet().iterator();
            this.tryAdvance();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Map.Entry result = this.next;
            this.tryAdvance();
            return result;
        }

        private void tryAdvance() {
            this.next = null;
            while (this.internalIterator.hasNext()) {
                Map.Entry nextRefEntry = this.internalIterator.next();
                if (nextRefEntry.getValue() == null) {
                    throw new IllegalStateException();
                }
                Object value = ((Reference)nextRefEntry.getValue()).get();
                if (value == null) continue;
                this.next = new ReferenceEntry(nextRefEntry, value);
                break;
            }
        }
    }
}

