/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.QueryResult;
import org.apache.cayenne.QueryResultItem;

public class GenericQueryResult<T>
implements QueryResult<T> {
    protected Class<T> resultClass;
    protected List<QueryResultItem> resultItems;

    public GenericQueryResult(List<QueryResultItem> resultItems) {
        this.resultItems = resultItems;
    }

    public GenericQueryResult(List<QueryResultItem> resultItems, Class<T> resultClass) {
        this(resultItems);
        this.resultClass = resultClass;
    }

    @Override
    public int size() {
        return this.resultItems.size();
    }

    @Override
    public boolean isList() {
        for (QueryResultItem item : this.resultItems) {
            if (!item.isSelectResult()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<T> firstList() {
        for (QueryResultItem item : this.resultItems) {
            if (!item.isSelectResult()) continue;
            return item.getSelectResult();
        }
        throw new CayenneRuntimeException("Result is not a select result.", new Object[0]);
    }

    @Override
    public int[] firstBatchUpdateCount() {
        for (QueryResultItem item : this.resultItems) {
            if (item.isSelectResult()) continue;
            return item.getBatchUpdateCounts();
        }
        throw new CayenneRuntimeException("Result is not a batch update count.", new Object[0]);
    }

    @Override
    public int firstUpdateCount() {
        for (QueryResultItem item : this.resultItems) {
            if (item.isSelectResult()) continue;
            return item.getUpdateCount();
        }
        throw new CayenneRuntimeException("Result is not an update count.", new Object[0]);
    }

    @Override
    public Iterator<QueryResultItem> iterator() {
        return this.resultItems.iterator();
    }
}

