/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect.generic;

import org.apache.cayenne.Persistent;
import org.apache.cayenne.reflect.Accessor;
import org.apache.cayenne.reflect.PropertyException;

class PersistentObjectAccessor
implements Accessor {
    protected String propertyName;

    PersistentObjectAccessor(String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException("Null propertyName");
        }
        this.propertyName = propertyName;
    }

    @Override
    public String getName() {
        return this.propertyName;
    }

    @Override
    public Object getValue(Object object) throws PropertyException {
        try {
            Persistent persistent = (Persistent)object;
            return persistent.readPropertyDirectly(this.propertyName);
        }
        catch (ClassCastException e) {
            throw new PropertyException("Object is not a Persistent: '" + object.getClass().getName() + "'", (Accessor)this, object, (Throwable)e, new Object[0]);
        }
        catch (Throwable th) {
            throw new PropertyException("Error reading Persistent property: " + this.propertyName, (Accessor)this, object, th, new Object[0]);
        }
    }

    @Override
    public void setValue(Object object, Object newValue) throws PropertyException {
        try {
            ((Persistent)object).writePropertyDirectly(this.propertyName, newValue);
        }
        catch (ClassCastException e) {
            throw new PropertyException("Object is not a Persistent: '" + object.getClass().getName() + "'", (Accessor)this, object, (Throwable)e, new Object[0]);
        }
        catch (Throwable th) {
            throw new PropertyException("Error reading Persistent property: " + this.propertyName, (Accessor)this, object, th, new Object[0]);
        }
    }
}

