/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cayenne.LifecycleListener;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.annotation.PostAdd;
import org.apache.cayenne.annotation.PostLoad;
import org.apache.cayenne.annotation.PostPersist;
import org.apache.cayenne.annotation.PostRemove;
import org.apache.cayenne.annotation.PostUpdate;
import org.apache.cayenne.annotation.PrePersist;
import org.apache.cayenne.annotation.PreRemove;
import org.apache.cayenne.annotation.PreUpdate;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.LifecycleEvent;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.reflect.LifecycleCallbackEventHandler;

public class LifecycleCallbackRegistry {
    private EntityResolver entityResolver;
    private LifecycleCallbackEventHandler[] eventCallbacks;
    private Map<String, AnnotationReader> annotationsMap;
    private Map<String, Collection<Class<?>>> entitiesByAnnotation;

    public LifecycleCallbackRegistry(EntityResolver resolver) {
        this.entityResolver = resolver;
        this.eventCallbacks = new LifecycleCallbackEventHandler[LifecycleEvent.values().length];
        for (int i = 0; i < this.eventCallbacks.length; ++i) {
            this.eventCallbacks[i] = new LifecycleCallbackEventHandler();
        }
        this.entitiesByAnnotation = new ConcurrentHashMap();
    }

    public void clear() {
        for (LifecycleCallbackEventHandler eventCallback : this.eventCallbacks) {
            eventCallback.clear();
        }
    }

    public void clear(int type) {
        this.eventCallbacks[type].clear();
    }

    public boolean isEmpty(LifecycleEvent type) {
        return this.eventCallbacks[type.ordinal()].isEmpty();
    }

    public void addDefaultListener(LifecycleListener listener) {
        this.addDefaultListener(LifecycleEvent.POST_ADD, listener, "postAdd");
        this.addDefaultListener(LifecycleEvent.PRE_PERSIST, listener, "prePersist");
        this.addDefaultListener(LifecycleEvent.POST_PERSIST, listener, "postPersist");
        this.addDefaultListener(LifecycleEvent.PRE_REMOVE, listener, "preRemove");
        this.addDefaultListener(LifecycleEvent.POST_REMOVE, listener, "postRemove");
        this.addDefaultListener(LifecycleEvent.PRE_UPDATE, listener, "preUpdate");
        this.addDefaultListener(LifecycleEvent.POST_UPDATE, listener, "postUpdate");
        this.addDefaultListener(LifecycleEvent.POST_LOAD, listener, "postLoad");
    }

    public void addDefaultListener(LifecycleEvent type, Object listener, String methodName) {
        this.eventCallbacks[type.ordinal()].addDefaultListener(listener, methodName);
    }

    public void addListener(Class<?> entityClass, LifecycleListener listener) {
        this.addListener(LifecycleEvent.POST_ADD, entityClass, listener, "postAdd");
        this.addListener(LifecycleEvent.PRE_PERSIST, entityClass, listener, "prePersist");
        this.addListener(LifecycleEvent.POST_PERSIST, entityClass, listener, "postPersist");
        this.addListener(LifecycleEvent.PRE_REMOVE, entityClass, listener, "preRemove");
        this.addListener(LifecycleEvent.POST_REMOVE, entityClass, listener, "postRemove");
        this.addListener(LifecycleEvent.PRE_UPDATE, entityClass, listener, "preUpdate");
        this.addListener(LifecycleEvent.POST_UPDATE, entityClass, listener, "postUpdate");
        this.addListener(LifecycleEvent.POST_LOAD, entityClass, listener, "postLoad");
    }

    public void addListener(LifecycleEvent type, Class<?> entityClass, Object listener, String methodName) {
        this.eventCallbacks[type.ordinal()].addListener(entityClass, listener, methodName);
    }

    public void addCallback(LifecycleEvent type, Class<?> entityClass, String methodName) {
        this.eventCallbacks[type.ordinal()].addListener(entityClass, methodName);
    }

    public void addCallback(LifecycleEvent type, Class<?> entityClass, Method method) {
        this.eventCallbacks[type.ordinal()].addListener(entityClass, method);
    }

    public void addListener(Object listener) {
        if (listener == null) {
            throw new NullPointerException("Null listener");
        }
        Class<?> listenerType = listener.getClass();
        do {
            for (Method m : listenerType.getDeclaredMethods()) {
                for (Annotation a : m.getAnnotations()) {
                    AnnotationReader reader = this.getAnnotationsMap().get(a.annotationType().getName());
                    if (reader == null) continue;
                    HashSet types = new HashSet();
                    Class<?>[] entities = reader.entities(a);
                    Class<? extends Annotation>[] entityAnnotations = reader.entityAnnotations(a);
                    Collections.addAll(types, entities);
                    for (Class<? extends Annotation> type : entityAnnotations) {
                        types.addAll(this.getAnnotatedEntities(type));
                    }
                    for (Class clazz : types) {
                        this.eventCallbacks[reader.eventType().ordinal()].addListener(clazz, listener, m);
                    }
                    if (entities.length != 0 || entityAnnotations.length != 0) continue;
                    this.eventCallbacks[reader.eventType().ordinal()].addDefaultListener(listener, m.getName());
                }
            }
        } while ((listenerType = listenerType.getSuperclass()) != null && !listenerType.equals(Object.class));
    }

    public void performCallbacks(LifecycleEvent type, Persistent object) {
        this.eventCallbacks[type.ordinal()].performCallbacks(object);
    }

    public void performCallbacks(LifecycleEvent type, Collection<?> objects) {
        this.eventCallbacks[type.ordinal()].performCallbacks(objects);
    }

    LifecycleCallbackEventHandler getHandler(LifecycleEvent type) {
        return this.eventCallbacks[type.ordinal()];
    }

    private Map<String, AnnotationReader> getAnnotationsMap() {
        if (this.annotationsMap == null) {
            HashMap<String, AnnotationReader> annotationsMap = new HashMap<String, AnnotationReader>();
            annotationsMap.put(PostAdd.class.getName(), new AnnotationReader(){

                @Override
                LifecycleEvent eventType() {
                    return LifecycleEvent.POST_ADD;
                }

                @Override
                Class<? extends Annotation>[] entityAnnotations(Annotation a) {
                    return ((PostAdd)a).entityAnnotations();
                }

                @Override
                Class<?>[] entities(Annotation a) {
                    return ((PostAdd)a).value();
                }
            });
            annotationsMap.put(PrePersist.class.getName(), new AnnotationReader(){

                @Override
                LifecycleEvent eventType() {
                    return LifecycleEvent.PRE_PERSIST;
                }

                @Override
                Class<? extends Annotation>[] entityAnnotations(Annotation a) {
                    return ((PrePersist)a).entityAnnotations();
                }

                @Override
                Class<?>[] entities(Annotation a) {
                    return ((PrePersist)a).value();
                }
            });
            annotationsMap.put(PreRemove.class.getName(), new AnnotationReader(){

                @Override
                LifecycleEvent eventType() {
                    return LifecycleEvent.PRE_REMOVE;
                }

                @Override
                Class<? extends Annotation>[] entityAnnotations(Annotation a) {
                    return ((PreRemove)a).entityAnnotations();
                }

                @Override
                Class<?>[] entities(Annotation a) {
                    return ((PreRemove)a).value();
                }
            });
            annotationsMap.put(PreUpdate.class.getName(), new AnnotationReader(){

                @Override
                LifecycleEvent eventType() {
                    return LifecycleEvent.PRE_UPDATE;
                }

                @Override
                Class<? extends Annotation>[] entityAnnotations(Annotation a) {
                    return ((PreUpdate)a).entityAnnotations();
                }

                @Override
                Class<?>[] entities(Annotation a) {
                    return ((PreUpdate)a).value();
                }
            });
            annotationsMap.put(PostLoad.class.getName(), new AnnotationReader(){

                @Override
                LifecycleEvent eventType() {
                    return LifecycleEvent.POST_LOAD;
                }

                @Override
                Class<? extends Annotation>[] entityAnnotations(Annotation a) {
                    return ((PostLoad)a).entityAnnotations();
                }

                @Override
                Class<?>[] entities(Annotation a) {
                    return ((PostLoad)a).value();
                }
            });
            annotationsMap.put(PostPersist.class.getName(), new AnnotationReader(){

                @Override
                LifecycleEvent eventType() {
                    return LifecycleEvent.POST_PERSIST;
                }

                @Override
                Class<? extends Annotation>[] entityAnnotations(Annotation a) {
                    return ((PostPersist)a).entityAnnotations();
                }

                @Override
                Class<?>[] entities(Annotation a) {
                    return ((PostPersist)a).value();
                }
            });
            annotationsMap.put(PostUpdate.class.getName(), new AnnotationReader(){

                @Override
                LifecycleEvent eventType() {
                    return LifecycleEvent.POST_UPDATE;
                }

                @Override
                Class<? extends Annotation>[] entityAnnotations(Annotation a) {
                    return ((PostUpdate)a).entityAnnotations();
                }

                @Override
                Class<?>[] entities(Annotation a) {
                    return ((PostUpdate)a).value();
                }
            });
            annotationsMap.put(PostRemove.class.getName(), new AnnotationReader(){

                @Override
                LifecycleEvent eventType() {
                    return LifecycleEvent.POST_REMOVE;
                }

                @Override
                Class<? extends Annotation>[] entityAnnotations(Annotation a) {
                    return ((PostRemove)a).entityAnnotations();
                }

                @Override
                Class<?>[] entities(Annotation a) {
                    return ((PostRemove)a).value();
                }
            });
            this.annotationsMap = annotationsMap;
        }
        return this.annotationsMap;
    }

    private Collection<Class<?>> getAnnotatedEntities(Class<? extends Annotation> annotationType) {
        Collection<Class<?>> entities = this.entitiesByAnnotation.get(annotationType.getName());
        if (entities == null) {
            entities = new HashSet();
            block0: for (ObjEntity entity : this.entityResolver.getObjEntities()) {
                Class entityType = this.entityResolver.getObjectFactory().getJavaClass(entity.getJavaClassName());
                while (entityType != null && entityType.isAnnotationPresent(annotationType)) {
                    Class superType = entityType.getSuperclass();
                    if (superType == null || !superType.isAnnotationPresent(annotationType)) {
                        entities.add(entityType);
                        continue block0;
                    }
                    entityType = superType;
                }
            }
            this.entitiesByAnnotation.put(annotationType.getName(), entities);
        }
        return entities;
    }

    abstract class AnnotationReader {
        AnnotationReader() {
        }

        abstract LifecycleEvent eventType();

        abstract Class<?>[] entities(Annotation var1);

        abstract Class<? extends Annotation>[] entityAnnotations(Annotation var1);
    }
}

