/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.sqlite;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.cayenne.access.types.ByteArrayType;
import org.apache.cayenne.access.types.ExtendedType;

class SQLiteByteArrayType
implements ExtendedType<byte[]> {
    SQLiteByteArrayType() {
    }

    @Override
    public String getClassName() {
        return "byte[]";
    }

    @Override
    public void setJdbcObject(PreparedStatement st, byte[] val, int pos, int type, int scale) throws Exception {
        if (val != null) {
            st.setBytes(pos, val);
        } else if (scale != -1) {
            st.setObject(pos, (Object)val, type, scale);
        } else {
            st.setObject(pos, (Object)val, type);
        }
    }

    @Override
    public byte[] materializeObject(ResultSet rs, int index, int type) throws Exception {
        return rs.getBytes(index);
    }

    @Override
    public byte[] materializeObject(CallableStatement rs, int index, int type) throws Exception {
        return rs.getBytes(index);
    }

    @Override
    public String toString(byte[] value) {
        if (value == null) {
            return "NULL";
        }
        StringBuilder buffer = new StringBuilder();
        ByteArrayType.logBytes(buffer, value);
        return buffer.toString();
    }
}

