/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import org.apache.cayenne.access.translator.select.BaseColumnExtractor;
import org.apache.cayenne.access.translator.select.TranslatorContext;
import org.apache.cayenne.exp.path.CayennePath;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityResult;
import org.apache.cayenne.map.ObjEntity;

class IdColumnExtractor
extends BaseColumnExtractor {
    private final DbEntity dbEntity;
    private EntityResult result;

    IdColumnExtractor(TranslatorContext context, DbEntity dbEntity) {
        super(context);
        this.dbEntity = dbEntity;
    }

    IdColumnExtractor(TranslatorContext context, ObjEntity objEntity) {
        this(context, objEntity.getDbEntity());
        if (context.getQuery().needsResultSetMapping()) {
            this.result = new EntityResult(objEntity.getName());
        }
    }

    @Override
    public void extract(CayennePath prefix) {
        for (DbAttribute dba : this.dbEntity.getPrimaryKeys()) {
            this.addDbAttribute(prefix, prefix, dba);
            if (this.result == null) continue;
            this.result.addDbField(dba.getName(), prefix + dba.getName());
        }
        if (this.result != null) {
            this.context.getSqlResult().addEntityResult(this.result);
        }
    }
}

