/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.naming;

import org.apache.cayenne.configuration.ConfigurationNodeVisitor;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.dbsync.naming.NameUtil;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.map.QueryDescriptor;

class NormalizationVisitor
implements ConfigurationNodeVisitor<String> {
    private String baseName;

    public NormalizationVisitor(String baseName) {
        this.baseName = baseName;
    }

    public String visitDataChannelDescriptor(DataChannelDescriptor channelDescriptor) {
        return this.baseName;
    }

    public String visitDataNodeDescriptor(DataNodeDescriptor nodeDescriptor) {
        return this.baseName;
    }

    public String visitDataMap(DataMap dataMap) {
        return this.baseName;
    }

    public String visitObjEntity(ObjEntity entity) {
        return NameUtil.capitalize(this.baseName);
    }

    public String visitDbEntity(DbEntity entity) {
        return this.baseName;
    }

    public String visitEmbeddable(Embeddable embeddable) {
        return NameUtil.capitalize(this.baseName);
    }

    public String visitEmbeddableAttribute(EmbeddableAttribute attribute) {
        return NameUtil.uncapitalize(this.baseName);
    }

    public String visitObjAttribute(ObjAttribute attribute) {
        return NameUtil.uncapitalize(this.baseName);
    }

    public String visitDbAttribute(DbAttribute attribute) {
        return this.baseName;
    }

    public String visitObjRelationship(ObjRelationship relationship) {
        return NameUtil.uncapitalize(this.baseName);
    }

    public String visitDbRelationship(DbRelationship relationship) {
        return NameUtil.uncapitalize(this.baseName);
    }

    public String visitProcedure(Procedure procedure) {
        return this.baseName;
    }

    public String visitProcedureParameter(ProcedureParameter parameter) {
        return this.baseName;
    }

    public String visitQuery(QueryDescriptor query) {
        return this.baseName;
    }
}

