/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.osgi;

import java.sql.Driver;
import org.apache.cayenne.configuration.osgi.OsgiModule;
import org.apache.cayenne.di.Module;

public class OsgiModuleBuilder {
    private OsgiModule module = new OsgiModule();

    public static OsgiModuleBuilder forProject(Class<?> typeFromProjectBundle) {
        if (typeFromProjectBundle == null) {
            throw new NullPointerException("Null 'typeFromProjectBundle'");
        }
        return new OsgiModuleBuilder(typeFromProjectBundle);
    }

    private OsgiModuleBuilder(Class<?> typeFromProjectBundle) {
        this.module.setTypeFromProjectBundle(typeFromProjectBundle);
    }

    public OsgiModuleBuilder withDriver(Class<? extends Driver> driverType) {
        return this.withType(driverType);
    }

    public OsgiModuleBuilder withType(Class<?> type) {
        this.module.putClassLoader(type.getName(), type.getClassLoader());
        return this;
    }

    public OsgiModuleBuilder withTypes(Class<?> ... types) {
        if (types != null) {
            for (Class<?> type : types) {
                this.module.putClassLoader(type.getName(), type.getClassLoader());
            }
        }
        return this;
    }

    public Module module() {
        return this.module;
    }
}

