/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.inflector.rule;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jvnet.inflector.Rule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRegexReplacementRule
implements Rule {
    private final Pattern pattern;

    public AbstractRegexReplacementRule(String regex) {
        this.pattern = Pattern.compile(regex);
    }

    @Override
    public boolean applies(String word) {
        return this.pattern.matcher(word).matches();
    }

    @Override
    public String apply(String word) {
        Matcher matcher = this.pattern.matcher(word);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Word '" + word + "' does not match regex: " + this.pattern.pattern());
        }
        return this.replace(matcher);
    }

    public abstract String replace(Matcher var1);

    public static String disjunction(String[] patterns) {
        String regex = "";
        for (int i = 0; i < patterns.length; ++i) {
            regex = regex + patterns[i];
            if (i >= patterns.length - 1) continue;
            regex = regex + "|";
        }
        return "(?:" + regex + ")";
    }

    public static String disjunction(Set<String> patterns) {
        return AbstractRegexReplacementRule.disjunction(patterns.toArray(new String[0]));
    }
}

