/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.swing.components.tree;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.apache.cayenne.swing.components.tree.CheckBoxNodeData;
import org.apache.cayenne.swing.components.tree.CheckBoxTreeCellEditor;
import org.apache.cayenne.swing.components.tree.CheckBoxTreeCellRenderer;
import org.apache.cayenne.swing.components.tree.LabelTreeCellRenderer;

public class CheckBoxTree
extends JPanel {
    private static final String TOGGLE_ROW_ACTION_KEY = "toggleRow";
    private static final String SELECTION_BACKGROUND_COLOR_KEY = "Tree.selectionBackground";
    protected final JTree labelTree;
    protected final JTree checkBoxTree;

    public CheckBoxTree(TreeModel model) {
        this.labelTree = new JTree(model);
        this.checkBoxTree = new JTree(model);
        this.init();
    }

    public TreeModel getModel() {
        return this.labelTree.getModel();
    }

    public TreeSelectionModel getSelectionModel() {
        return this.labelTree.getSelectionModel();
    }

    private void init() {
        this.initRender();
        this.initListeners();
    }

    private void initRender() {
        this.labelTree.setRootVisible(false);
        this.labelTree.setShowsRootHandles(true);
        this.labelTree.setUI(new FullWidthPaintTreeUI());
        this.labelTree.setCellRenderer(new LabelTreeCellRenderer());
        this.checkBoxTree.setRootVisible(false);
        this.checkBoxTree.setEditable(true);
        this.checkBoxTree.setUI(new FullWidthPaintTreeUI(){

            @Override
            protected int getRowX(int row, int depth) {
                return 0;
            }
        });
        this.checkBoxTree.setCellRenderer(new CheckBoxTreeCellRenderer());
        this.checkBoxTree.setCellEditor(new CheckBoxTreeCellEditor(this.checkBoxTree));
        this.setLayout(new BorderLayout());
        this.add((Component)this.labelTree, "Center");
        this.add((Component)this.checkBoxTree, "East");
    }

    private void initListeners() {
        this.labelTree.getModel().addTreeModelListener(new CheckBoxTreeModelEventHandler());
        this.checkBoxTree.setModel(this.labelTree.getModel());
        this.labelTree.getSelectionModel().setSelectionMode(1);
        this.labelTree.addMouseListener(new TreeFullWidthMouseClickHandler(this.labelTree));
        this.checkBoxTree.setSelectionModel(this.labelTree.getSelectionModel());
        this.labelTree.getInputMap().put(KeyStroke.getKeyStroke(32, 0), TOGGLE_ROW_ACTION_KEY);
        this.checkBoxTree.getInputMap().put(KeyStroke.getKeyStroke(32, 0), TOGGLE_ROW_ACTION_KEY);
        this.labelTree.getActionMap().put(TOGGLE_ROW_ACTION_KEY, new ToggleRowAction());
        this.checkBoxTree.getActionMap().put(TOGGLE_ROW_ACTION_KEY, new ToggleRowAction());
        this.labelTree.addTreeWillExpandListener(new ShareExpandListener(this.checkBoxTree));
    }

    private static class FullWidthPaintTreeUI
    extends BasicTreeUI {
        private FullWidthPaintTreeUI() {
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            if (this.tree.getSelectionCount() > 0) {
                g.setColor(UIManager.getColor(CheckBoxTree.SELECTION_BACKGROUND_COLOR_KEY));
                int[] rows = this.tree.getSelectionRows();
                if (rows != null) {
                    for (int i : rows) {
                        Rectangle r = this.tree.getRowBounds(i);
                        g.fillRect(0, r.y, this.tree.getWidth(), r.height);
                    }
                }
            }
            super.paint(g, c);
        }
    }

    private static class CheckBoxTreeModelEventHandler
    implements TreeModelListener {
        private boolean listening = true;

        private CheckBoxTreeModelEventHandler() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            if (this.listening) {
                this.handleEvent(e);
            }
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            if (this.listening) {
                this.handleEvent(e);
            }
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            if (this.listening) {
                this.handleEvent(e);
            }
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            if (this.listening) {
                this.handleEvent(e);
            }
        }

        private void handleEvent(TreeModelEvent e) {
            Object parentComponent = e.getTreePath().getLastPathComponent();
            if (!(e.getSource() instanceof TreeModel) || !(parentComponent instanceof DefaultMutableTreeNode)) {
                return;
            }
            TreeModel model = (TreeModel)e.getSource();
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)parentComponent;
            this.validateParentCheckBoxState(model, e.getTreePath(), parentNode);
            this.listening = false;
            for (Object child : e.getChildren()) {
                this.propagateCheckBoxState(model, e.getTreePath().pathByAddingChild(child), null);
            }
            this.listening = true;
        }

        private void validateParentCheckBoxState(TreeModel model, TreePath parentPath, DefaultMutableTreeNode parentNode) {
            if (!(parentNode.getUserObject() instanceof CheckBoxNodeData)) {
                return;
            }
            CheckBoxNodeData parentData = (CheckBoxNodeData)parentNode.getUserObject();
            int childCount = model.getChildCount(parentNode);
            int checkCount = CheckBoxTreeModelEventHandler.countCheckedChildren(model, parentNode);
            CheckBoxNodeData parentDataChanged = checkCount == childCount ? parentData.withState(CheckBoxNodeData.State.SELECTED) : (checkCount == 0 ? parentData.withState(CheckBoxNodeData.State.DESELECTED) : parentData.withState(CheckBoxNodeData.State.INDETERMINATE));
            model.valueForPathChanged(parentPath, parentDataChanged);
        }

        private static int countCheckedChildren(TreeModel model, DefaultMutableTreeNode parentNode) {
            int childCount = model.getChildCount(parentNode);
            int checkCount = 0;
            for (int i = 0; i < childCount; ++i) {
                DefaultMutableTreeNode childNode;
                Object childComponent = model.getChild(parentNode, i);
                if (!(childComponent instanceof DefaultMutableTreeNode) || !((childNode = (DefaultMutableTreeNode)childComponent).getUserObject() instanceof CheckBoxNodeData)) continue;
                CheckBoxNodeData childData = (CheckBoxNodeData)childNode.getUserObject();
                checkCount += childData.isSelected() ? 1 : 0;
            }
            return checkCount;
        }

        private void propagateCheckBoxState(TreeModel model, TreePath childPath, CheckBoxNodeData.State parentState) {
            if (parentState == CheckBoxNodeData.State.INDETERMINATE) {
                return;
            }
            Object component = childPath.getLastPathComponent();
            if (!(component instanceof DefaultMutableTreeNode)) {
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)component;
            if (!(node.getUserObject() instanceof CheckBoxNodeData)) {
                return;
            }
            CheckBoxNodeData data = (CheckBoxNodeData)node.getUserObject();
            if (parentState != null) {
                data = data.withState(parentState);
                model.valueForPathChanged(childPath, data);
            }
            CheckBoxNodeData finalData = data;
            node.children().asIterator().forEachRemaining(child -> this.propagateCheckBoxState(model, childPath.pathByAddingChild(child), finalData.getState()));
        }
    }

    private static class TreeFullWidthMouseClickHandler
    extends MouseAdapter {
        private final JTree tree;

        public TreeFullWidthMouseClickHandler(JTree tree) {
            this.tree = tree;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            this.selectFullWidth(e);
            if (e.getClickCount() < 2) {
                return;
            }
            this.toggleTargetRow(e);
        }

        private void selectFullWidth(MouseEvent e) {
            int closestRow = this.tree.getClosestRowForLocation(e.getX(), e.getY());
            Rectangle closestRowBounds = this.tree.getRowBounds(closestRow);
            if ((double)e.getY() >= closestRowBounds.getY() && (double)e.getY() < closestRowBounds.getY() + closestRowBounds.getHeight() && !this.tree.isRowSelected(closestRow)) {
                this.tree.setSelectionRow(closestRow);
            }
        }

        private void toggleTargetRow(MouseEvent e) {
            int closestRow = this.tree.getClosestRowForLocation(e.getX(), e.getY());
            if (this.tree.isExpanded(closestRow)) {
                this.tree.collapseRow(closestRow);
            } else {
                this.tree.expandRow(closestRow);
            }
        }
    }

    private static class ToggleRowAction
    extends AbstractAction {
        private ToggleRowAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!(e.getSource() instanceof JTree)) {
                return;
            }
            JTree tree = (JTree)e.getSource();
            if (tree.getSelectionPath() == null) {
                return;
            }
            Object component = tree.getSelectionPath().getLastPathComponent();
            if (tree.getSelectionPath() == null || !(component instanceof DefaultMutableTreeNode)) {
                return;
            }
            Object value = ((DefaultMutableTreeNode)component).getUserObject();
            if (!(value instanceof CheckBoxNodeData)) {
                return;
            }
            CheckBoxNodeData data = (CheckBoxNodeData)value;
            tree.getModel().valueForPathChanged(tree.getSelectionPath(), data.toggleState());
        }
    }

    private static class ShareExpandListener
    implements TreeWillExpandListener {
        private final JTree otherTree;

        private ShareExpandListener(JTree otherTree) {
            this.otherTree = otherTree;
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent event) {
            this.otherTree.expandPath(event.getPath());
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent event) {
            this.otherTree.collapsePath(event.getPath());
        }
    }
}

