/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.swing.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class TopBorder
extends AbstractBorder {
    private static final Color DEFAULT_COLOR = Color.LIGHT_GRAY;
    private static final Border DEFAULT_BORDER = new TopBorder(DEFAULT_COLOR, 1);
    private int thickness;
    private Color color;

    public static Border create() {
        return DEFAULT_BORDER;
    }

    public static Border create(int thickness) {
        return new TopBorder(DEFAULT_COLOR, thickness);
    }

    public static Border create(Color color) {
        return new TopBorder(color, 1);
    }

    public static Border create(Color color, int thickness) {
        return new TopBorder(color, thickness);
    }

    public TopBorder(Color color, int thickness) {
        this.color = color;
        this.thickness = thickness;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.thickness > 0 && g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            Color oldColor = g2d.getColor();
            g2d.setColor(this.color);
            g2d.setBackground(this.color);
            g2d.drawRect(x, y, width, y + this.thickness - 1);
            g2d.setColor(oldColor);
        }
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.set(this.thickness, 0, 0, 0);
        return insets;
    }
}

