/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect.generic;

import java.io.Serializable;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.reflect.PropertyDescriptor;
import org.apache.cayenne.reflect.PropertyException;
import org.apache.cayenne.reflect.PropertyVisitor;

abstract class PersistentObjectBaseProperty
implements PropertyDescriptor,
Serializable {
    PersistentObjectBaseProperty() {
    }

    @Override
    public abstract String getName();

    @Override
    public abstract void injectValueHolder(Object var1) throws PropertyException;

    @Override
    public abstract boolean visit(PropertyVisitor var1);

    @Override
    public Object readProperty(Object object) throws PropertyException {
        try {
            return this.toPersistent(object).readProperty(this.getName());
        }
        catch (Throwable th) {
            throw new PropertyException("Error reading Persistent property: " + this.getName(), (PropertyDescriptor)this, object, th, new Object[0]);
        }
    }

    @Override
    public void writeProperty(Object object, Object oldValue, Object newValue) throws PropertyException {
        try {
            this.toPersistent(object).writeProperty(this.getName(), newValue);
        }
        catch (Throwable th) {
            throw new PropertyException("Error writing Persistent property: " + this.getName(), (PropertyDescriptor)this, object, th, new Object[0]);
        }
    }

    @Override
    public Object readPropertyDirectly(Object object) throws PropertyException {
        try {
            return this.toPersistent(object).readPropertyDirectly(this.getName());
        }
        catch (Throwable th) {
            throw new PropertyException("Error reading Persistent property: " + this.getName(), (PropertyDescriptor)this, object, th, new Object[0]);
        }
    }

    @Override
    public void writePropertyDirectly(Object object, Object oldValue, Object newValue) throws PropertyException {
        try {
            this.toPersistent(object).writePropertyDirectly(this.getName(), newValue);
        }
        catch (Throwable th) {
            throw new PropertyException("Error writing Persistent property: " + this.getName(), (PropertyDescriptor)this, object, th, new Object[0]);
        }
    }

    protected final Persistent toPersistent(Object object) throws PropertyException {
        try {
            return (Persistent)object;
        }
        catch (ClassCastException e) {
            throw new PropertyException("Object is not a Persistent: '" + object.getClass().getName() + "'", (PropertyDescriptor)this, object, (Throwable)e, new Object[0]);
        }
    }
}

