/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validation;

import java.util.function.Supplier;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.project.validation.ConfigurationNodeValidator;
import org.apache.cayenne.project.validation.Inspection;
import org.apache.cayenne.project.validation.ValidationConfig;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationResult;

class DbEntityValidator
extends ConfigurationNodeValidator<DbEntity> {
    public DbEntityValidator(Supplier<ValidationConfig> configSupplier) {
        super(configSupplier);
    }

    @Override
    public void validate(DbEntity node, ValidationResult validationResult) {
        this.on(node, validationResult).performIfEnabled(Inspection.DB_ENTITY_NO_NAME, this::checkForName).performIfEnabled(Inspection.DB_ENTITY_NAME_DUPLICATE, this::checkForNameDuplicates).performIfEnabled(Inspection.DB_ENTITY_NO_ATTRIBUTES, this::checkForAttributes).performIfEnabled(Inspection.DB_ENTITY_NO_PK, this::checkForPK);
    }

    private void checkForName(DbEntity entity, ValidationResult validationResult) {
        String name = entity.getName();
        if (Util.isEmptyString(name)) {
            this.addFailure(validationResult, entity, "Unnamed DbEntity", new Object[0]);
        }
    }

    private void checkForNameDuplicates(DbEntity entity, ValidationResult validationResult) {
        String name = entity.getName();
        DataMap map = entity.getDataMap();
        if (map == null || Util.isEmptyString(name)) {
            return;
        }
        for (DbEntity otherEntity : map.getDbEntities()) {
            if (otherEntity == entity || !name.equals(otherEntity.getName())) continue;
            this.addFailure(validationResult, entity, "Duplicate DbEntity name: %s", name);
            break;
        }
    }

    private void checkForAttributes(DbEntity entity, ValidationResult validationResult) {
        if (entity.getAttributes().isEmpty()) {
            this.addFailure(validationResult, entity, "DbEntity '%s' has no attributes defined", entity.getName());
        }
    }

    private void checkForPK(DbEntity entity, ValidationResult validationResult) {
        if (entity.getAttributes().isEmpty() || !entity.getPrimaryKeys().isEmpty()) {
            return;
        }
        DataMap map = entity.getDataMap();
        if (map == null || map.getMappedEntities(entity).isEmpty()) {
            return;
        }
        this.addFailure(validationResult, entity, "DbEntity '%s' has no primary key attributes defined", entity.getName());
    }
}

