/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validation;

import java.util.function.Supplier;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.project.validation.ConfigurationNodeValidator;
import org.apache.cayenne.project.validation.Inspection;
import org.apache.cayenne.project.validation.NameValidationHelper;
import org.apache.cayenne.project.validation.ValidationConfig;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationResult;

class DataMapValidator
extends ConfigurationNodeValidator<DataMap> {
    public DataMapValidator(Supplier<ValidationConfig> configSupplier) {
        super(configSupplier);
    }

    @Override
    public void validate(DataMap node, ValidationResult validationResult) {
        this.on(node, validationResult).performIfEnabled(Inspection.DATA_MAP_NO_NAME, this::checkForName).performIfEnabled(Inspection.DATA_MAP_NAME_DUPLICATE, this::checkForNameDuplicates).performIfEnabled(Inspection.DATA_MAP_NODE_LINKAGE, this::checkForNodeLinkage).performIfEnabled(Inspection.DATA_MAP_JAVA_PACKAGE, this::validateJavaPackage);
    }

    private void checkForName(DataMap map, ValidationResult validationResult) {
        String name = map.getName();
        if (Util.isEmptyString(name)) {
            this.addFailure(validationResult, map, "Unnamed DataMap", new Object[0]);
        }
    }

    private void checkForNameDuplicates(DataMap map, ValidationResult validationResult) {
        String name = map.getName();
        DataChannelDescriptor domain = map.getDataChannelDescriptor();
        if (domain == null || Util.isEmptyString(name)) {
            return;
        }
        for (DataMap otherMap : domain.getDataMaps()) {
            if (otherMap == map || !name.equals(otherMap.getName())) continue;
            this.addFailure(validationResult, map, "Duplicate DataMap name: %s", name);
            return;
        }
    }

    private void checkForNodeLinkage(DataMap map, ValidationResult validationResult) {
        DataChannelDescriptor domain = map.getDataChannelDescriptor();
        if (domain == null) {
            return;
        }
        boolean linked = false;
        int nodeCount = 0;
        for (DataNodeDescriptor node : domain.getNodeDescriptors()) {
            ++nodeCount;
            if (!node.getDataMapNames().contains(map.getName())) continue;
            linked = true;
            break;
        }
        if (!linked && nodeCount > 0) {
            this.addFailure(validationResult, map, "DataMap is not linked to any DataNodes", new Object[0]);
        }
    }

    private void validateJavaPackage(DataMap map, ValidationResult validationResult) {
        String javaPackage = map.getDefaultPackage();
        if (Util.isEmptyString(javaPackage)) {
            this.addFailure(validationResult, map, "Java package is not set in DataMap '%s'", map.getName());
            return;
        }
        NameValidationHelper helper = NameValidationHelper.getInstance();
        String invalidChars = helper.invalidCharsInJavaClassName(javaPackage);
        if (invalidChars != null) {
            this.addFailure(validationResult, map, "DataMap '%s' Java package '%s' contains invalid characters: %s", map.getName(), javaPackage, invalidChars);
        }
    }
}

