/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.CompoundBorder;
import javax.swing.table.DefaultTableCellRenderer;
import org.apache.cayenne.modeler.util.ModelerUtil;

public class SortButtonRenderer
extends DefaultTableCellRenderer {
    public static final int NONE = 0;
    public static final int DOWN = 1;
    public static final int UP = 2;
    private static final Icon ICON_DOWN = ModelerUtil.buildIcon("icon-sort-desc.png");
    private static final Icon ICON_UP = ModelerUtil.buildIcon("icon-sort-asc.png");
    private static final Font FONT;
    private static final CompoundBorder BORDER;
    private boolean sortingEnabled = true;
    private int currentState;
    private int currentColumn;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (this.sortingEnabled && column == this.currentColumn) {
            if (this.currentState == 1) {
                this.setIcon(ICON_DOWN);
            } else {
                this.setIcon(ICON_UP);
            }
        } else {
            this.setIcon(null);
        }
        this.setText(value == null ? "" : value.toString());
        this.setFont(FONT);
        this.setHorizontalTextPosition(2);
        this.setBorder(BORDER);
        return this;
    }

    public void setSelectedColumn(int col, boolean isAscOrder) {
        if (col < 0) {
            return;
        }
        this.currentState = isAscOrder ? 1 : 2;
        this.currentColumn = col;
    }

    public int getState(int col) {
        if (col == this.currentColumn) {
            return this.currentState;
        }
        return 0;
    }

    public boolean isSortingEnabled() {
        return this.sortingEnabled;
    }

    public void setSortingEnabled(boolean sortingEnabled) {
        this.sortingEnabled = sortingEnabled;
    }

    static {
        BORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, Color.GRAY), BorderFactory.createEmptyBorder(0, 5, 0, 0));
        FONT = new JLabel().getFont().deriveFont(1);
    }
}

