/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.undo;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.action.CreateDataMapAction;
import org.apache.cayenne.modeler.action.RemoveAction;
import org.apache.cayenne.modeler.event.DomainDisplayEvent;
import org.apache.cayenne.modeler.undo.CayenneUndoableEdit;

public class CreateDataMapUndoableEdit
extends CayenneUndoableEdit {
    private DataChannelDescriptor domain;
    private DataMap map;

    @Override
    public String getPresentationName() {
        return "Create DataMap";
    }

    public CreateDataMapUndoableEdit(DataChannelDescriptor domain, DataMap map) {
        this.domain = domain;
        this.map = map;
    }

    @Override
    public void redo() throws CannotRedoException {
        CreateDataMapAction action = this.actionManager.getAction(CreateDataMapAction.class);
        action.createDataMap(this.map);
    }

    @Override
    public void undo() throws CannotUndoException {
        RemoveAction action = this.actionManager.getAction(RemoveAction.class);
        this.controller.fireDomainDisplayEvent(new DomainDisplayEvent((Object)this, this.domain));
        action.removeDataMap(this.map);
    }
}

