/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.graph;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.event.DomainDisplayEvent;
import org.apache.cayenne.modeler.event.DomainDisplayListener;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.graph.GraphBuilder;
import org.apache.cayenne.modeler.graph.GraphRegistry;
import org.apache.cayenne.modeler.graph.GraphType;
import org.apache.cayenne.modeler.graph.action.RebuildGraphAction;
import org.apache.cayenne.modeler.graph.action.SaveAsImageAction;
import org.apache.cayenne.modeler.graph.action.ZoomInAction;
import org.apache.cayenne.modeler.graph.action.ZoomOutAction;
import org.jgraph.JGraph;
import org.jgraph.graph.DefaultGraphCell;

public class DataDomainGraphTab
extends JPanel
implements DomainDisplayListener,
ItemListener {
    ProjectController mediator;
    JComboBox<String> diagramCombo;
    JScrollPane scrollPane;
    JGraph graph;
    DataChannelDescriptor domain;
    boolean needRebuild;
    GraphRegistry graphRegistry;

    public DataDomainGraphTab(ProjectController mediator) {
        this.mediator = mediator;
        this.initView();
    }

    private void initView() {
        this.needRebuild = true;
        this.mediator.addDomainDisplayListener(this);
        this.setLayout(new BorderLayout());
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.setLayout(new FlowLayout(0, 0, 0));
        GraphType[] types = GraphType.values();
        String[] names = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            names[i] = types[i].getName();
        }
        this.diagramCombo = Application.getWidgetFactory().createComboBox(names, false);
        this.diagramCombo.addItemListener(this);
        toolbar.add(new RebuildGraphAction(this, Application.getInstance()).buildButton(1));
        toolbar.add(new SaveAsImageAction(this, Application.getInstance()).buildButton(3));
        toolbar.addSeparator();
        toolbar.add(new ZoomInAction(this, Application.getInstance()).buildButton(1));
        toolbar.add(new ZoomOutAction(this, Application.getInstance()).buildButton(3));
        toolbar.addSeparator();
        toolbar.add(new JLabel("Diagram: "));
        toolbar.add(this.diagramCombo);
        this.add((Component)toolbar, "North");
        this.scrollPane = new JScrollPane();
        this.add(this.scrollPane);
    }

    @Override
    public void currentDomainChanged(DomainDisplayEvent e) {
        if (e instanceof EntityDisplayEvent) {
            Entity<?, ?, ?> entity = ((EntityDisplayEvent)e).getEntity();
            this.diagramCombo.setSelectedIndex(entity instanceof ObjEntity ? 1 : 0);
            this.refresh();
            GraphBuilder builder = (GraphBuilder)this.getGraphRegistry().getGraphMap(this.domain).get((Object)this.getSelectedType());
            DefaultGraphCell cell = builder.getEntityCell(entity.getName());
            if (cell != null) {
                this.graph.setSelectionCell(cell);
                this.graph.scrollCellToVisible(cell);
            }
        } else if (this.domain != e.getDomain()) {
            this.needRebuild = true;
            this.domain = e.getDomain();
            if (this.isVisible()) {
                this.refresh();
            }
        }
    }

    public void refresh() {
        if (this.needRebuild && this.domain != null) {
            this.graph = this.getGraphRegistry().loadGraph(this.mediator, this.domain, this.getSelectedType());
            this.scrollPane.setViewportView(this.graph);
            this.needRebuild = false;
        }
    }

    private GraphType getSelectedType() {
        return GraphType.values()[this.diagramCombo.getSelectedIndex()];
    }

    public void rebuild() {
        if (this.domain != null) {
            JOptionPane pane = new JOptionPane("Rebuilding graph from domain will cause all user changes to be lost. Continue?", 3, 0);
            JDialog dialog = pane.createDialog(Application.getFrame(), "Confirm Rebuild");
            dialog.setVisible(true);
            if (pane.getValue().equals(0)) {
                this.getGraphRegistry().getGraphMap(this.domain).remove((Object)this.getSelectedType());
                this.itemStateChanged(null);
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.needRebuild = true;
        this.refresh();
    }

    public JGraph getGraph() {
        return this.graph;
    }

    GraphRegistry getGraphRegistry() {
        this.graphRegistry = this.mediator.getApplication().getMetaData().get(this.domain, GraphRegistry.class);
        if (this.graphRegistry == null) {
            this.graphRegistry = new GraphRegistry();
            this.mediator.getApplication().getMetaData().add(this.domain, this.graphRegistry);
        }
        return this.graphRegistry;
    }
}

