/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.DBConnectionAwareAction;
import org.apache.cayenne.modeler.dialog.db.load.DbLoadResultDialog;
import org.apache.cayenne.modeler.dialog.db.load.DbLoaderContext;
import org.apache.cayenne.modeler.dialog.db.load.LoadDataMapTask;
import org.apache.cayenne.modeler.editor.DbImportController;
import org.apache.cayenne.modeler.editor.dbimport.DbImportView;
import org.apache.cayenne.modeler.pref.DBConnectionInfo;

public class ReverseEngineeringAction
extends DBConnectionAwareAction {
    private static final String ACTION_NAME = "Reengineer Database Schema";
    private static final String ICON_NAME = "icon-dbi-runImport.png";
    private static final String DIALOG_TITLE = "Reengineer DB Schema: Connect to Database";
    private DbImportView view;
    private AtomicInteger dataMapCount;
    protected Set<DataMap> dataMaps;

    @Override
    public String getIconName() {
        return ICON_NAME;
    }

    ReverseEngineeringAction(Application application) {
        super(ReverseEngineeringAction.getActionName(), application);
    }

    public static String getActionName() {
        return ACTION_NAME;
    }

    public void performAction(Set<DataMap> dataMapSet) {
        this.resetParams();
        this.dataMaps.addAll(dataMapSet);
        this.dataMapCount.set(this.dataMaps.size());
        ProjectController projectController = Application.getInstance().getFrameController().getProjectController();
        for (DataMap dataMap : dataMapSet) {
            projectController.setCurrentDataMap(dataMap);
            this.startImport();
        }
    }

    private void startImport() {
        DbLoaderContext context = new DbLoaderContext(this.application.getMetaData());
        DBConnectionInfo connectionInfo = this.getConnectionInfo(DIALOG_TITLE);
        if (connectionInfo == null) {
            return;
        }
        context.setProjectController(this.getProjectController());
        try {
            context.setConnection(connectionInfo.makeDataSource(this.getApplication().getClassLoadingService()).getConnection());
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(Application.getFrame(), ex.getMessage(), "Error loading schemas dialog", 0);
            return;
        }
        if (!context.buildConfig(connectionInfo, this.view, true)) {
            try {
                context.getConnection().close();
            }
            catch (SQLException ex) {
                // empty catch block
            }
            return;
        }
        DbImportController dbImportController = Application.getInstance().getFrameController().getDbImportController();
        DbLoadResultDialog dbLoadResultDialog = dbImportController.createDialog();
        this.runLoaderInThread(context, () -> {
            this.application.getUndoManager().discardAllEdits();
            try {
                context.getConnection().close();
                if (!(this.dataMapCount.decrementAndGet() > 0 || context.isInterrupted() || dbLoadResultDialog.isVisible() || dbLoadResultDialog.getTableForMap().isEmpty())) {
                    dbImportController.showDialog();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        });
    }

    @Override
    public void performAction(ActionEvent event) {
        this.resetParams();
        this.dataMaps.add(Application.getInstance().getFrameController().getProjectController().getCurrentDataMap());
        this.dataMapCount.set(this.dataMaps.size());
        this.startImport();
    }

    private void resetParams() {
        this.dataMapCount = new AtomicInteger();
        this.dataMaps = new HashSet<DataMap>();
    }

    private void runLoaderInThread(DbLoaderContext context, Runnable callback) {
        Thread th = new Thread(() -> {
            LoadDataMapTask task = new LoadDataMapTask(Application.getFrame(), "Reengineering DB", context);
            task.startAndWait();
            SwingUtilities.invokeLater(callback);
        });
        th.start();
    }

    public void setView(DbImportView view) {
        this.view = view;
    }
}

