/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.exp.path.CayennePath;
import org.apache.cayenne.exp.path.CayennePathSegment;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.MappingNamespace;
import org.apache.cayenne.map.PathComponent;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.util.CayenneMapEntry;
import org.apache.cayenne.util.ToStringBuilder;
import org.apache.cayenne.util.XMLSerializable;

public abstract class Entity<E extends Entity<E, A, R>, A extends Attribute<E, A, R>, R extends Relationship<E, A, R>>
implements CayenneMapEntry,
XMLSerializable,
Serializable {
    public static final String PATH_SEPARATOR = ".";
    public static final String OUTER_JOIN_INDICATOR = "+";
    protected String name;
    protected DataMap dataMap;
    protected final Map<String, A> attributes = new LinkedHashMap<String, A>();
    protected final Map<String, R> relationships = new LinkedHashMap<String, R>();

    public Entity() {
        this(null);
    }

    public Entity(String name) {
        this.setName(name);
    }

    public String toString() {
        return new ToStringBuilder(this).append("name", this.getName()).toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Object getParent() {
        return this.getDataMap();
    }

    @Override
    public void setParent(Object parent) {
        if (parent != null && !(parent instanceof DataMap)) {
            throw new IllegalArgumentException("Expected null or DataMap, got: " + parent);
        }
        this.setDataMap((DataMap)parent);
    }

    public DataMap getDataMap() {
        return this.dataMap;
    }

    public void setDataMap(DataMap dataMap) {
        this.dataMap = dataMap;
    }

    public A getAttribute(String attributeName) {
        return (A)((Attribute)this.attributes.get(attributeName));
    }

    public void addAttribute(A attribute) {
        if (((Attribute)attribute).getName() == null) {
            throw new IllegalArgumentException("Attempt to insert unnamed attribute.");
        }
        Attribute existingAttribute = (Attribute)this.attributes.get(((Attribute)attribute).getName());
        if (existingAttribute != null) {
            if (existingAttribute == attribute) {
                return;
            }
            throw new IllegalArgumentException("An attempt to override attribute '" + ((Attribute)attribute).getName() + "'");
        }
        R existingRelationship = this.relationships.get(((Attribute)attribute).getName());
        if (existingRelationship != null) {
            throw new IllegalArgumentException("Attribute name conflict with existing relationship '" + ((Attribute)attribute).getName() + "'");
        }
        this.attributes.put(((Attribute)attribute).getName(), attribute);
        ((Attribute)attribute).setEntity(this);
    }

    public void removeAttribute(String attrName) {
        this.attributes.remove(attrName);
    }

    public void updateAttribute(A attribute) {
        this.removeAttribute(((Attribute)attribute).getName());
        this.addAttribute(attribute);
    }

    public void clearAttributes() {
        this.attributes.clear();
    }

    public R getRelationship(String relName) {
        return (R)((Relationship)this.relationships.get(relName));
    }

    public void addRelationship(R relationship) {
        if (((Relationship)relationship).getName() == null) {
            throw new IllegalArgumentException("Attempt to insert unnamed relationship.");
        }
        R existingRelationship = this.relationships.get(((Relationship)relationship).getName());
        if (existingRelationship != null) {
            if (existingRelationship == relationship) {
                return;
            }
            throw new IllegalArgumentException("An attempt to override relationship '" + ((Relationship)relationship).getName() + "'");
        }
        A existingAttribute = this.attributes.get(((Relationship)relationship).getName());
        if (existingAttribute != null) {
            throw new IllegalArgumentException("Relationship name conflict with existing attribute '" + ((Relationship)relationship).getName() + "'");
        }
        this.relationships.put(((Relationship)relationship).getName(), relationship);
        Entity sourceEntity = this;
        ((Relationship)relationship).setSourceEntity((Entity)sourceEntity);
    }

    public void removeRelationship(String relName) {
        this.relationships.remove(relName);
    }

    public void clearRelationships() {
        this.relationships.clear();
    }

    public Map<String, R> getRelationshipMap() {
        return Collections.unmodifiableMap(this.relationships);
    }

    public R getAnyRelationship(E targetEntity) {
        if (this.getRelationships().isEmpty()) {
            return null;
        }
        for (Relationship r : this.getRelationships()) {
            if (r.getTargetEntity() != targetEntity) continue;
            return (R)r;
        }
        return null;
    }

    public Collection<R> getRelationships() {
        return Collections.unmodifiableCollection(this.relationships.values());
    }

    public Map<String, A> getAttributeMap() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public Collection<A> getAttributes() {
        return Collections.unmodifiableCollection(this.attributes.values());
    }

    public Expression translateToRelatedEntity(Expression expression, String relationshipPath) {
        return this.translateToRelatedEntity(expression, CayennePath.of(relationshipPath));
    }

    public abstract Expression translateToRelatedEntity(Expression var1, CayennePath var2);

    public PathComponent<A, R> lastPathComponent(Expression path, Map<String, String> aliasMap) {
        for (PathComponent<A, R> component : this.resolvePath(path, aliasMap)) {
            if (!component.isLast()) continue;
            return this.lastPathComponent(component);
        }
        return null;
    }

    private PathComponent<A, R> lastPathComponent(PathComponent<A, R> component) {
        if (!component.isAlias()) {
            return component;
        }
        for (PathComponent<A, R> subcomponent : component.getAliasedPath()) {
            if (!subcomponent.isLast()) continue;
            return this.lastPathComponent(subcomponent);
        }
        throw new IllegalStateException("Invalid last path component: " + component.getName());
    }

    public abstract Iterable<PathComponent<A, R>> resolvePath(Expression var1, Map<String, String> var2);

    public abstract Iterator<CayenneMapEntry> resolvePathComponents(Expression var1) throws ExpressionException;

    public Iterator<CayenneMapEntry> resolvePathComponents(String path) throws ExpressionException {
        return new PathIterator(CayennePath.of(path));
    }

    public Iterator<CayenneMapEntry> resolvePathComponents(CayennePath path) throws ExpressionException {
        return new PathIterator(path);
    }

    final MappingNamespace getNonNullNamespace() {
        DataMap parent = this.getDataMap();
        if (parent == null) {
            throw new CayenneRuntimeException("Entity '%s' has no parent MappingNamespace (such as DataMap)", this.getName());
        }
        return parent;
    }

    final class PathIterator
    implements Iterator<CayenneMapEntry> {
        private final CayennePath path;
        private final Iterator<CayennePathSegment> iterator;
        private Entity<E, A, R> currentEntity;

        PathIterator(CayennePath path) {
            this.currentEntity = Entity.this;
            this.path = path;
            this.iterator = path.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public CayenneMapEntry next() {
            CayennePathSegment nextSegment = this.iterator.next();
            Object attr = this.currentEntity.getAttribute(nextSegment.value());
            if (attr != null) {
                if (this.iterator.hasNext()) {
                    throw new ExpressionException("Attribute must be the last component of the path: '%s'.", this.path, null, nextSegment.value());
                }
                return attr;
            }
            Object rel = this.currentEntity.getRelationship(nextSegment.value());
            if (rel != null) {
                this.currentEntity = ((Relationship)rel).getTargetEntity();
                if (this.currentEntity != null || !this.iterator.hasNext()) {
                    return rel;
                }
            }
            String entityName = this.currentEntity != null ? this.currentEntity.getName() : "(?)";
            throw new ExpressionException("Can't resolve path component: [%s.%s].", this.path, null, entityName, nextSegment.value());
        }
    }
}

