/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.gen.xml;

import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.ConfigurationNodeVisitor;
import org.apache.cayenne.configuration.xml.DataChannelMetaData;
import org.apache.cayenne.gen.CgenConfigList;
import org.apache.cayenne.gen.CgenConfiguration;
import org.apache.cayenne.gen.internal.Utils;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.project.extension.BaseSaverDelegate;

public class CgenSaverDelegate
extends BaseSaverDelegate {
    private DataChannelMetaData metaData;

    CgenSaverDelegate(DataChannelMetaData metaData) {
        this.metaData = metaData;
    }

    @Override
    public Void visitDataMap(DataMap dataMap) {
        CgenConfigList cgenConfigList = this.metaData.get(dataMap, CgenConfigList.class);
        if (cgenConfigList != null) {
            for (CgenConfiguration cgen : cgenConfigList.getAll()) {
                if (cgen == null) continue;
                CgenSaverDelegate.resolveOutputDir(this.getBaseDirectory().getURL(), cgen);
                this.encoder.nested(cgen, (ConfigurationNodeVisitor)this.getParentDelegate());
            }
        }
        return null;
    }

    static void resolveOutputDir(URL baseURL, CgenConfiguration cgenConfiguration) {
        if (baseURL == null) {
            return;
        }
        Path baseDirectory = CgenSaverDelegate.getBaseDirectoryForURL(baseURL);
        Path prevRootPath = cgenConfiguration.getRootPath();
        Path prevOutputPath = cgenConfiguration.buildOutputPath();
        cgenConfiguration.setRootPath(baseDirectory);
        if (prevRootPath == null) {
            Utils.getMavenSrcPathForPath(baseDirectory).map(x$0 -> Path.of(x$0, new String[0])).ifPresent(cgenConfiguration::updateOutputPath);
        }
        if (prevOutputPath != null) {
            cgenConfiguration.updateOutputPath(prevOutputPath);
        } else if (cgenConfiguration.buildOutputPath() == null) {
            cgenConfiguration.updateOutputPath(baseDirectory);
        }
    }

    private static Path getBaseDirectoryForURL(URL baseURL) {
        Path resourcePath;
        try {
            resourcePath = Paths.get(baseURL.toURI());
        }
        catch (URISyntaxException e) {
            throw new CayenneRuntimeException("Unable to resolve output path", (Throwable)e, new Object[0]);
        }
        if (Files.isRegularFile(resourcePath, new LinkOption[0])) {
            resourcePath = resourcePath.getParent();
        }
        return resourcePath;
    }
}

